/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class MixCoderDataOutputStream
extends DataOutputStream {
    private int lastValue;
    private int lastLastValue;
    private int repCount;
    private int diffshift;
    private int bm = 1;
    private int b = 0;
    public static int[] diffs = new int[100];
    public static int[] counts = new int[100];

    public MixCoderDataOutputStream(OutputStream os) {
        super(os);
    }

    public void writeMixed(int v) throws IOException {
        if (v != this.lastValue && this.repCount > 0) {
            int d = this.lastValue - this.lastLastValue;
            this.lastLastValue = this.lastValue;
            this.encodeBit(d < 0);
            if (d < 0) {
                d = -d;
            }
            this.encodeVarBits(d - this.diffshift);
            this.encodeVarBits(this.repCount - 1);
            if (d < 100) {
                int n = d;
                diffs[n] = diffs[n] + 1;
            }
            if (this.repCount < 100) {
                int n = this.repCount;
                counts[n] = counts[n] + 1;
            }
            this.diffshift = 1;
            this.repCount = 0;
        }
        this.lastValue = v;
        ++this.repCount;
    }

    @Override
    public void flush() throws IOException {
        int v = this.lastValue;
        this.writeMixed(v + 1);
        this.lastValue = v;
        this.repCount = 0;
        if (this.bm > 1) {
            this.writeByte((byte)this.b);
        }
    }

    public final void encodeBit(boolean value) throws IOException {
        if (this.bm == 256) {
            this.writeByte((byte)this.b);
            this.bm = 1;
            this.b = 0;
        }
        if (value) {
            this.b |= this.bm;
        }
        this.bm <<= 1;
    }

    public final void encodeVarBits(int value) throws IOException {
        int range = 0;
        while (value > range) {
            this.encodeBit(false);
            value -= range + 1;
            range = 2 * range + 1;
        }
        this.encodeBit(true);
        this.encodeBounded(range, value);
    }

    public final void encodeBounded(int max, int value) throws IOException {
        for (int im = 1; im <= max; im <<= 1) {
            if (this.bm == 256) {
                this.writeByte((byte)this.b);
                this.bm = 1;
                this.b = 0;
            }
            if ((value & im) != 0) {
                this.b |= this.bm;
                max -= im;
            }
            this.bm <<= 1;
        }
    }

    public static void stats() {
        int i;
        for (i = 1; i < 100; ++i) {
            System.out.println("diff[" + i + "] = " + diffs[i]);
        }
        for (i = 1; i < 100; ++i) {
            System.out.println("counts[" + i + "] = " + counts[i]);
        }
    }
}

