/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.BitCoderContext;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class MixCoderDataInputStream
extends DataInputStream {
    private int lastValue;
    private int repCount;
    private int diffshift;
    private int bits;
    private int b;
    private static final int[] vl_values = BitCoderContext.vl_values;
    private static final int[] vl_length = BitCoderContext.vl_length;

    public MixCoderDataInputStream(InputStream is) {
        super(is);
    }

    public int readMixed() throws IOException {
        if (this.repCount == 0) {
            boolean negative = this.decodeBit();
            int d = this.decodeVarBits() + this.diffshift;
            this.repCount = this.decodeVarBits() + 1;
            this.lastValue += negative ? -d : d;
            this.diffshift = 1;
        }
        --this.repCount;
        return this.lastValue;
    }

    public final boolean decodeBit() throws IOException {
        this.fillBuffer();
        boolean value = (this.b & 1) != 0;
        this.b >>>= 1;
        --this.bits;
        return value;
    }

    public final int decodeVarBits2() throws IOException {
        int range = 0;
        while (!this.decodeBit()) {
            range = 2 * range + 1;
        }
        return range + this.decodeBounded(range);
    }

    public final int decodeBounded(int max) throws IOException {
        int value = 0;
        int im = 1;
        while ((value | im) <= max) {
            if (this.decodeBit()) {
                value |= im;
            }
            im <<= 1;
        }
        return value;
    }

    public final int decodeVarBits() throws IOException {
        this.fillBuffer();
        int b12 = this.b & 0xFFF;
        int len = vl_length[b12];
        if (len <= 12) {
            this.b >>>= len;
            this.bits -= len;
            return vl_values[b12];
        }
        if (len <= 23) {
            int len2 = len >> 1;
            this.b >>>= len2 + 1;
            int mask = -1 >>> 32 - len2;
            mask += this.b & mask;
            this.b >>>= len2;
            this.bits -= len;
            return mask;
        }
        if ((this.b & 0xFFFFFF) != 0) {
            this.b >>>= 12;
            int len3 = 1 + (vl_length[this.b & 0xFFF] >> 1);
            this.b >>>= len3;
            int len2 = 11 + len3;
            this.bits -= len2 + 1;
            this.fillBuffer();
            int mask = -1 >>> 32 - len2;
            mask += this.b & mask;
            this.b >>>= len2;
            this.bits -= len2;
            return mask;
        }
        return this.decodeVarBits2();
    }

    private void fillBuffer() throws IOException {
        while (this.bits < 24) {
            int nextByte = this.read();
            if (nextByte != -1) {
                this.b |= (nextByte & 0xFF) << this.bits;
            }
            this.bits += 8;
        }
    }
}

