/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.CheapRuler;

public final class CheapAngleMeter {
    private double cosangle;

    public double getCosAngle() {
        return this.cosangle;
    }

    public double calcAngle(int lon0, int lat0, int lon1, int lat1, int lon2, int lat2) {
        double cosp;
        double dy21;
        double dx21;
        double lat2m;
        double dy10;
        double[] lonlat2m = CheapRuler.getLonLatToMeterScales(lat1);
        double lon2m = lonlat2m[0];
        double dx10 = (double)(lon1 - lon0) * lon2m;
        double dd = Math.sqrt((dx10 * dx10 + (dy10 = (double)(lat1 - lat0) * (lat2m = lonlat2m[1])) * dy10) * ((dx21 = (double)(lon2 - lon1) * lon2m) * dx21 + (dy21 = (double)(lat2 - lat1) * lat2m) * dy21));
        if (dd == 0.0) {
            this.cosangle = 1.0;
            return 0.0;
        }
        double sinp = (dy10 * dx21 - dx10 * dy21) / dd;
        this.cosangle = cosp = (dy10 * dy21 + dx10 * dx21) / dd;
        double offset = 0.0;
        double s2 = sinp * sinp;
        if (s2 > 0.5) {
            if (sinp > 0.0) {
                offset = 90.0;
                sinp = -cosp;
            } else {
                offset = -90.0;
                sinp = cosp;
            }
            s2 = cosp * cosp;
        } else if (cosp < 0.0) {
            offset = (sinp = -sinp) > 0.0 ? -180.0 : 180.0;
        }
        return offset + sinp * (57.4539 + s2 * (9.57565 + s2 * (4.30904 + s2 * 2.56491)));
    }
}

