/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.expressions.BExpressionMetaData;
import btools.router.RoutingContext;
import java.io.File;

public final class ProfileCache {
    private static File lastLookupFile;
    private static long lastLookupTimestamp;
    private BExpressionContextWay expctxWay;
    private BExpressionContextNode expctxNode;
    private File lastProfileFile;
    private long lastProfileTimestamp;
    private boolean profilesBusy;
    private long lastUseTime;
    private static ProfileCache[] apc;
    private static boolean debug;

    public static synchronized void setSize(int size) {
        apc = new ProfileCache[size];
    }

    public static synchronized boolean parseProfile(RoutingContext rc) {
        File profileFile;
        File profileDir;
        String profileBaseDir = System.getProperty("profileBaseDir");
        if (profileBaseDir == null) {
            profileDir = new File(rc.localFunction).getParentFile();
            profileFile = new File(rc.localFunction);
        } else {
            profileDir = new File(profileBaseDir);
            profileFile = new File(profileDir, rc.localFunction + ".brf");
        }
        rc.profileTimestamp = profileFile.lastModified() + rc.getKeyValueChecksum() << 24;
        File lookupFile = new File(profileDir, "lookups.dat");
        if (!lookupFile.equals(lastLookupFile) || lookupFile.lastModified() != lastLookupTimestamp) {
            if (lastLookupFile != null) {
                System.out.println("******** invalidating profile-cache after lookup-file update ******** ");
            }
            apc = new ProfileCache[apc.length];
            lastLookupFile = lookupFile;
            lastLookupTimestamp = lookupFile.lastModified();
        }
        ProfileCache lru = null;
        int unusedSlot = -1;
        for (int i = 0; i < apc.length; ++i) {
            ProfileCache pc = apc[i];
            if (pc != null) {
                if (!pc.profilesBusy && profileFile.equals(pc.lastProfileFile)) {
                    if (rc.profileTimestamp == pc.lastProfileTimestamp) {
                        rc.expctxWay = pc.expctxWay;
                        rc.expctxNode = pc.expctxNode;
                        rc.readGlobalConfig();
                        pc.profilesBusy = true;
                        return true;
                    }
                    lru = pc;
                    unusedSlot = -1;
                    break;
                }
                if (lru != null && lru.lastUseTime <= pc.lastUseTime) continue;
                lru = pc;
                continue;
            }
            if (unusedSlot >= 0) continue;
            unusedSlot = i;
        }
        BExpressionMetaData meta = new BExpressionMetaData();
        rc.expctxWay = new BExpressionContextWay(rc.memoryclass * 512, meta);
        rc.expctxNode = new BExpressionContextNode(0, meta);
        rc.expctxNode.setForeignContext(rc.expctxWay);
        meta.readMetaData(new File(profileDir, "lookups.dat"));
        rc.expctxWay.parseFile(profileFile, "global");
        rc.expctxNode.parseFile(profileFile, "global");
        rc.readGlobalConfig();
        if (rc.processUnusedTags) {
            rc.expctxWay.setAllTagsUsed();
        }
        if (lru == null || unusedSlot >= 0) {
            lru = new ProfileCache();
            if (unusedSlot >= 0) {
                ProfileCache.apc[unusedSlot] = lru;
                if (debug) {
                    System.out.println("******* adding new profile at idx=" + unusedSlot + " for " + profileFile);
                }
            }
        }
        if (lru.lastProfileFile != null && debug) {
            System.out.println("******* replacing profile of age " + (System.currentTimeMillis() - lru.lastUseTime) / 1000L + " sec " + lru.lastProfileFile + "->" + profileFile);
        }
        lru.lastProfileTimestamp = rc.profileTimestamp;
        lru.lastProfileFile = profileFile;
        lru.expctxWay = rc.expctxWay;
        lru.expctxNode = rc.expctxNode;
        lru.profilesBusy = true;
        lru.lastUseTime = System.currentTimeMillis();
        return false;
    }

    public static synchronized void releaseProfile(RoutingContext rc) {
        for (int i = 0; i < apc.length; ++i) {
            ProfileCache pc = apc[i];
            if (pc == null || rc.expctxWay != pc.expctxWay || rc.expctxNode != pc.expctxNode) continue;
            pc.profilesBusy = false;
            break;
        }
        rc.expctxWay = null;
        rc.expctxNode = null;
    }

    static {
        apc = new ProfileCache[1];
        debug = Boolean.getBoolean("debugProfileCache");
    }
}

