/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeCutter;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeFilter;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.RelationMerger;
import btools.mapcreator.RestrictionCutter5;
import btools.mapcreator.RestrictionData;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.DenseLongMap;
import btools.util.TinyDenseLongMap;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;

public class WayCutter5
extends MapCreatorBase {
    private DataOutputStream borderNidsOutStream;
    private DenseLongMap tileIndexMap;
    private File nodeTilesIn;
    private int lonoffset;
    private int latoffset;
    public RelationMerger relMerger;
    public NodeFilter nodeFilter;
    public NodeCutter nodeCutter;
    public RestrictionCutter5 restrictionCutter5;

    public static void main(String[] args) throws Exception {
        System.out.println("*** WayCutter5: Soft-Cut way-data into tiles");
        if (args.length != 4) {
            System.out.println("usage: java WayCutter5 <node-tiles-in> <way-tiles-in> <way-tiles-out> <border-nids-out>");
            return;
        }
        new WayCutter5().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]));
    }

    public void process(File nodeTilesIn, File wayTilesIn, File wayTilesOut, File borderNidsOut) throws Exception {
        this.nodeTilesIn = nodeTilesIn;
        this.outTileDir = wayTilesOut;
        this.borderNidsOutStream = this.createOutStream(borderNidsOut);
        new WayIterator(this, true).processDir(wayTilesIn, ".wtl");
        this.borderNidsOutStream.close();
    }

    @Override
    public boolean wayFileStart(File wayfile) throws Exception {
        String resfilename;
        File resfile;
        String name = wayfile.getName();
        String nodefilename = name.substring(0, name.length() - 3) + "ntl";
        File nodefile = new File(this.nodeTilesIn, nodefilename);
        this.tileIndexMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap() : new TinyDenseLongMap();
        this.lonoffset = -1;
        this.latoffset = -1;
        if (this.nodeCutter != null) {
            this.nodeCutter.nodeFileStart(null);
        }
        new NodeIterator(this, this.nodeCutter != null).processFile(nodefile);
        if (this.restrictionCutter5 != null && (resfile = new File("restrictions", resfilename = name.substring(0, name.length() - 3) + "rtl")).exists()) {
            DataInputStream di = new DataInputStream(new BufferedInputStream(new FileInputStream(resfile)));
            int ntr = 0;
            try {
                while (true) {
                    RestrictionData res = new RestrictionData(di);
                    this.restrictionCutter5.nextRestriction(res);
                    ++ntr;
                }
            }
            catch (EOFException eof) {
                di.close();
                System.out.println("read " + ntr + " turn-restrictions");
            }
        }
        return true;
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        if (this.nodeFilter != null && !this.nodeFilter.isRelevant(n)) {
            return;
        }
        if (this.nodeCutter != null) {
            this.nodeCutter.nextNode(n);
        }
        this.tileIndexMap.put(n.nid, this.getTileIndex(n.ilon, n.ilat));
    }

    @Override
    public void nextWay(WayData data) throws Exception {
        int i;
        long waytileset = 0L;
        int nnodes = data.nodes.size();
        int[] tiForNode = new int[nnodes];
        for (i = 0; i < nnodes; ++i) {
            int tileIndex = this.tileIndexMap.getInt(data.nodes.get(i));
            if (tileIndex != -1) {
                waytileset |= 1L << tileIndex;
            }
            tiForNode[i] = tileIndex;
        }
        if (this.relMerger != null) {
            this.relMerger.nextWay(data);
        }
        for (int tileIndex = 0; tileIndex < 54; ++tileIndex) {
            if ((waytileset & 1L << tileIndex) == 0L) continue;
            data.writeTo(this.getOutStreamForTile(tileIndex));
        }
        for (i = 0; i < nnodes; ++i) {
            int ti = tiForNode[i];
            if (ti == -1 || (i <= 0 || tiForNode[i - 1] == ti) && (i + 1 >= nnodes || tiForNode[i + 1] == ti)) continue;
            WayCutter5.writeId(this.borderNidsOutStream, data.nodes.get(i));
        }
    }

    @Override
    public void wayFileEnd(File wayFile) throws Exception {
        this.closeTileOutStreams();
        if (this.nodeCutter != null) {
            this.nodeCutter.nodeFileEnd(null);
        }
        if (this.restrictionCutter5 != null) {
            this.restrictionCutter5.finish();
        }
    }

    public int getTileIndexForNid(long nid) {
        return this.tileIndexMap.getInt(nid);
    }

    private int getTileIndex(int ilon, int ilat) {
        int lonoff = ilon / 45000000 * 45;
        int latoff = ilat / 30000000 * 30;
        if (this.lonoffset == -1) {
            this.lonoffset = lonoff;
        }
        if (this.latoffset == -1) {
            this.latoffset = latoff;
        }
        if (lonoff != this.lonoffset || latoff != this.latoffset) {
            throw new IllegalArgumentException("inconsistent node: " + ilon + " " + ilat);
        }
        int lon = ilon / 5000000 % 9;
        int lat = ilat / 5000000 % 6;
        if (lon < 0 || lon > 8 || lat < 0 || lat > 5) {
            throw new IllegalArgumentException("illegal pos: " + ilon + "," + ilat);
        }
        return lon * 6 + lat;
    }

    @Override
    protected String getNameForTile(int tileIndex) {
        int lon = tileIndex / 6 * 5 + this.lonoffset - 180;
        int lat = tileIndex % 6 * 5 + this.latoffset - 90;
        String slon = lon < 0 ? "W" + -lon : "E" + lon;
        String slat = lat < 0 ? "S" + -lat : "N" + lat;
        return slon + "_" + slat + ".wt5";
    }
}

