/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.util.ReducedMedianFilter;

public class SrtmRaster {
    public int ncols;
    public int nrows;
    public boolean halfcol;
    public double xllcorner;
    public double yllcorner;
    public double cellsize;
    public short[] eval_array;
    public short noDataValue;
    public boolean usingWeights = false;
    private boolean missingData = false;
    private ReducedMedianFilter rmf = new ReducedMedianFilter(256);
    private static int gridSteps;
    private static Weights[][][] allShiftWeights;
    private static double filterCenterFraction;
    private static double filterDiscRadius;

    public short getElevation(int ilon, int ilat) {
        double lon = (double)ilon / 1000000.0 - 180.0;
        double lat = (double)ilat / 1000000.0 - 90.0;
        if (this.usingWeights) {
            return this.getElevationFromShiftWeights(lon, lat);
        }
        double dcol = (lon - this.xllcorner) / this.cellsize - 0.5;
        double drow = (lat - this.yllcorner) / this.cellsize - 0.5;
        int row = (int)drow;
        int col = (int)dcol;
        if (col < 0) {
            col = 0;
        }
        if (col >= this.ncols - 1) {
            col = this.ncols - 2;
        }
        if (row < 0) {
            row = 0;
        }
        if (row >= this.nrows - 1) {
            row = this.nrows - 2;
        }
        double wrow = drow - (double)row;
        double wcol = dcol - (double)col;
        this.missingData = false;
        double eval = (1.0 - wrow) * (1.0 - wcol) * (double)this.get(row, col) + wrow * (1.0 - wcol) * (double)this.get(row + 1, col) + (1.0 - wrow) * wcol * (double)this.get(row, col + 1) + wrow * wcol * (double)this.get(row + 1, col + 1);
        return this.missingData ? (short)Short.MIN_VALUE : (short)(eval * 4.0);
    }

    private short get(int r, int c) {
        short e = this.eval_array[(this.nrows - 1 - r) * this.ncols + c];
        if (e == Short.MIN_VALUE) {
            this.missingData = true;
        }
        return e;
    }

    private short getElevationFromShiftWeights(double lon, double lat) {
        double alat = lat < 0.0 ? -lat : lat;
        int latIdx = (int)(alat /= 5.0);
        double wlat = alat - (double)latIdx;
        double dcol = (lon - this.xllcorner) / this.cellsize;
        double drow = (lat - this.yllcorner) / this.cellsize;
        int row = (int)drow;
        int col = (int)dcol;
        double dgx = (dcol - (double)col) * (double)gridSteps;
        double dgy = (drow - (double)row) * (double)gridSteps;
        int gx = (int)dgx;
        int gy = (int)dgy;
        double wx = dgx - (double)gx;
        double wy = dgy - (double)gy;
        double w00 = (1.0 - wx) * (1.0 - wy);
        double w01 = (1.0 - wx) * wy;
        double w10 = wx * (1.0 - wy);
        double w11 = wx * wy;
        Weights[][] w0 = SrtmRaster.getWeights(latIdx);
        Weights[][] w1 = SrtmRaster.getWeights(latIdx + 1);
        this.missingData = false;
        double m0 = w00 * this.getElevation(w0[gx][gy], row, col) + w01 * this.getElevation(w0[gx][gy + 1], row, col) + w10 * this.getElevation(w0[gx + 1][gy], row, col) + w11 * this.getElevation(w0[gx + 1][gy + 1], row, col);
        double m1 = w00 * this.getElevation(w1[gx][gy], row, col) + w01 * this.getElevation(w1[gx][gy + 1], row, col) + w10 * this.getElevation(w1[gx + 1][gy], row, col) + w11 * this.getElevation(w1[gx + 1][gy + 1], row, col);
        if (this.missingData) {
            return Short.MIN_VALUE;
        }
        double m = (1.0 - wlat) * m0 + wlat * m1;
        return (short)(m * 2.0);
    }

    private double getElevation(Weights w, int row, int col) {
        if (this.missingData) {
            return 0.0;
        }
        int nx = w.nx;
        int ny = w.ny;
        int mx = nx / 2;
        int my = ny / 2;
        this.rmf.reset();
        for (int ix = 0; ix < nx; ++ix) {
            for (int iy = 0; iy < ny; ++iy) {
                short val = this.get(row + iy - my, col + ix - mx);
                this.rmf.addSample(w.getWeight(ix, iy), val);
            }
        }
        return this.missingData ? 0.0 : this.rmf.calcEdgeReducedMedian(filterCenterFraction);
    }

    private static Weights[][] getWeights(int latIndex) {
        int idx = latIndex < 16 ? latIndex : 16;
        Weights[][] res = allShiftWeights[idx];
        if (res == null) {
            res = SrtmRaster.calcWeights(idx);
            SrtmRaster.allShiftWeights[idx] = res;
        }
        return res;
    }

    private static Weights[][] calcWeights(int latIndex) {
        double coslat = Math.cos((double)latIndex * 5.0 / 57.3);
        double ry = filterDiscRadius;
        double rx = ry / coslat;
        int nx = (int)rx * 2 + 3;
        int ny = (int)ry * 2 + 3;
        System.out.println("nx=" + nx + " ny=" + ny);
        int mx = nx / 2;
        int my = ny / 2;
        Weights[][] shiftWeights = new Weights[gridSteps + 1][];
        for (int gx = 0; gx <= gridSteps; ++gx) {
            shiftWeights[gx] = new Weights[gridSteps + 1];
            double x0 = (double)mx + (double)gx / (double)gridSteps;
            for (int gy = 0; gy <= gridSteps; ++gy) {
                Weights weights;
                double y0 = (double)my + (double)gy / (double)gridSteps;
                shiftWeights[gx][gy] = weights = new Weights(nx, ny);
                double sampleStep = 0.001;
                for (double x = -1.0 + sampleStep / 2.0; x < 1.0; x += sampleStep) {
                    double mx2 = 1.0 - x * x;
                    int x_idx = (int)(x0 + x * rx);
                    for (double y = -1.0 + sampleStep / 2.0; y < 1.0; y += sampleStep) {
                        if (y * y > mx2) continue;
                        int y_idx = (int)(y0 + y * ry);
                        weights.inc(x_idx, y_idx);
                    }
                }
                weights.normalize(true);
            }
        }
        return shiftWeights;
    }

    public String toString() {
        return this.ncols + "," + this.nrows + "," + this.halfcol + "," + this.xllcorner + "," + this.yllcorner + "," + this.cellsize + "," + this.noDataValue + "," + this.usingWeights;
    }

    static {
        String sFraction;
        gridSteps = 10;
        allShiftWeights = new Weights[17][][];
        filterCenterFraction = 0.2;
        filterDiscRadius = 4.999;
        String sRadius = System.getProperty("filterDiscRadius");
        if (sRadius != null && sRadius.length() > 0) {
            filterDiscRadius = Integer.parseInt(sRadius);
            System.out.println("using filterDiscRadius = " + filterDiscRadius);
        }
        if ((sFraction = System.getProperty("filterCenterFraction")) != null && sFraction.length() > 0) {
            filterCenterFraction = (double)Integer.parseInt(sFraction) / 100.0;
            System.out.println("using filterCenterFraction = " + filterCenterFraction);
        }
    }

    private static class Weights {
        int nx;
        int ny;
        double[] weights;
        long total = 0L;

        Weights(int nx, int ny) {
            this.nx = nx;
            this.ny = ny;
            this.weights = new double[nx * ny];
        }

        void inc(int ix, int iy) {
            int n = iy * this.nx + ix;
            this.weights[n] = this.weights[n] + 1.0;
            ++this.total;
        }

        void normalize(boolean verbose) {
            for (int iy = 0; iy < this.ny; ++iy) {
                StringBuilder sb = verbose ? new StringBuilder() : null;
                for (int ix = 0; ix < this.nx; ++ix) {
                    int n = iy * this.nx + ix;
                    this.weights[n] = this.weights[n] / (double)this.total;
                    if (sb == null) continue;
                    int iweight = (int)(1000.0 * this.weights[iy * this.nx + ix] + 0.5);
                    String sval = "     " + iweight;
                    sb.append(sval.substring(sval.length() - 4));
                }
                if (sb == null) continue;
                System.out.println(sb);
                System.out.println();
            }
        }

        double getWeight(int ix, int iy) {
            return this.weights[iy * this.nx + ix];
        }
    }
}

