/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.RasterCoder;
import btools.mapcreator.SrtmRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SrtmData {
    private SrtmRaster raster = new SrtmRaster();

    public SrtmData(File file) throws Exception {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            while (true) {
                ZipEntry ze;
                if (!(ze = zis.getNextEntry()).getName().endsWith(".asc")) continue;
                this.readFromStream(zis);
                return;
            }
        }
        finally {
            zis.close();
        }
    }

    public SrtmRaster getRaster() {
        return this.raster;
    }

    private String secondToken(String s) {
        StringTokenizer tk = new StringTokenizer(s, " ");
        tk.nextToken();
        return tk.nextToken();
    }

    public void readFromStream(InputStream is) throws Exception {
        int c;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int linenr = 0;
        while (++linenr <= 6) {
            String line = br.readLine();
            if (linenr == 1) {
                this.raster.ncols = Integer.parseInt(this.secondToken(line));
                continue;
            }
            if (linenr == 2) {
                this.raster.nrows = Integer.parseInt(this.secondToken(line));
                continue;
            }
            if (linenr == 3) {
                this.raster.xllcorner = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr == 4) {
                this.raster.yllcorner = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr == 5) {
                this.raster.cellsize = Double.parseDouble(this.secondToken(line));
                continue;
            }
            if (linenr != 6) continue;
            this.raster.eval_array = new short[this.raster.ncols * this.raster.nrows];
        }
        int row = 0;
        int col = 0;
        int n = 0;
        boolean negative = false;
        while ((c = br.read()) >= 0) {
            if (c == 32) {
                short val;
                if (negative) {
                    n = -n;
                }
                this.raster.eval_array[row * this.raster.ncols + col] = val = (short)(n < -250 ? Short.MIN_VALUE : (short)n);
                if (++col == this.raster.ncols) {
                    col = 0;
                    ++row;
                }
                n = 0;
                negative = false;
                continue;
            }
            if (c >= 48 && c <= 57) {
                n = 10 * n + (c - 48);
                continue;
            }
            if (c != 45) continue;
            negative = true;
        }
        br.close();
    }

    public static void main(String[] args) throws Exception {
        File[] files;
        String fromDir = args[0];
        String toDir = args[1];
        for (File f : files = new File(fromDir).listFiles()) {
            if (!f.getName().endsWith(".zip")) continue;
            System.out.println("*** reading: " + f);
            long t0 = System.currentTimeMillis();
            SrtmRaster raster = new SrtmData(f).getRaster();
            long t1 = System.currentTimeMillis();
            String name = f.getName();
            long zipTime = t1 - t0;
            File fbef = new File(new File(toDir), name.substring(0, name.length() - 3) + "bef");
            System.out.println("recoding: " + f + " to " + fbef);
            BufferedOutputStream osbef = new BufferedOutputStream(new FileOutputStream(fbef));
            new RasterCoder().encodeRaster(raster, osbef);
            ((OutputStream)osbef).close();
            System.out.println("*** re-reading: " + fbef);
            long t2 = System.currentTimeMillis();
            BufferedInputStream isc = new BufferedInputStream(new FileInputStream(fbef));
            SrtmRaster raster2 = new RasterCoder().decodeRaster(isc);
            ((InputStream)isc).close();
            long t3 = System.currentTimeMillis();
            long befTime = t3 - t2;
            System.out.println("*** zip-time: " + zipTime + "*** bef-time: " + befTime);
            String s1 = raster.toString();
            String s2 = raster2.toString();
            if (!s1.equals(s2)) {
                throw new IllegalArgumentException("missmatch: " + s1 + "<--->" + s2);
            }
            int cols = raster.ncols;
            int rows = raster.nrows;
            for (int c = 0; c < cols; ++c) {
                for (int r = 0; r < rows; ++r) {
                    int idx = r * cols + c;
                    if (raster.eval_array[idx] == raster2.eval_array[idx]) continue;
                    throw new IllegalArgumentException("missmatch: at " + c + "," + r + ": " + raster.eval_array[idx] + "<--->" + raster2.eval_array[idx]);
                }
            }
        }
    }
}

