/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.SrtmRaster;
import btools.util.MixCoderDataInputStream;
import btools.util.MixCoderDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RasterCoder {
    public void encodeRaster(SrtmRaster raster, OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        long t0 = System.currentTimeMillis();
        dos.writeInt(raster.ncols);
        dos.writeInt(raster.nrows);
        dos.writeBoolean(raster.halfcol);
        dos.writeDouble(raster.xllcorner);
        dos.writeDouble(raster.yllcorner);
        dos.writeDouble(raster.cellsize);
        dos.writeShort(raster.noDataValue);
        this._encodeRaster(raster, os);
        long t1 = System.currentTimeMillis();
        System.out.println("finished encoding in " + (t1 - t0) + " ms");
    }

    public SrtmRaster decodeRaster(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        long t0 = System.currentTimeMillis();
        SrtmRaster raster = new SrtmRaster();
        raster.ncols = dis.readInt();
        raster.nrows = dis.readInt();
        raster.halfcol = dis.readBoolean();
        raster.xllcorner = dis.readDouble();
        raster.yllcorner = dis.readDouble();
        raster.cellsize = dis.readDouble();
        raster.noDataValue = dis.readShort();
        raster.eval_array = new short[raster.ncols * raster.nrows];
        this._decodeRaster(raster, is);
        raster.usingWeights = raster.ncols > 6001;
        long t1 = System.currentTimeMillis();
        System.out.println("finished decoding in " + (t1 - t0) + " ms ncols=" + raster.ncols + " nrows=" + raster.nrows);
        return raster;
    }

    private void _encodeRaster(SrtmRaster raster, OutputStream os) throws IOException {
        MixCoderDataOutputStream mco = new MixCoderDataOutputStream(os);
        int nrows = raster.nrows;
        int ncols = raster.ncols;
        short[] pixels = raster.eval_array;
        int colstep = raster.halfcol ? 2 : 1;
        for (int row = 0; row < nrows; ++row) {
            int lastval = Short.MIN_VALUE;
            for (int col = 0; col < ncols; col += colstep) {
                int val = pixels[row * ncols + col];
                if (val == -32766) {
                    val = lastval;
                } else {
                    lastval = val;
                }
                int code = val == Short.MIN_VALUE ? -1 : (val < 0 ? val - 1 : val);
                mco.writeMixed(code);
            }
        }
        mco.flush();
    }

    private void _decodeRaster(SrtmRaster raster, InputStream is) throws IOException {
        MixCoderDataInputStream mci = new MixCoderDataInputStream(is);
        int nrows = raster.nrows;
        int ncols = raster.ncols;
        short[] pixels = raster.eval_array;
        int colstep = raster.halfcol ? 2 : 1;
        for (int row = 0; row < nrows; ++row) {
            int col;
            for (col = 0; col < ncols; col += colstep) {
                int v30;
                int code = mci.readMixed();
                int n = code == -1 ? Short.MIN_VALUE : (v30 = code < 0 ? code + 1 : code);
                if (raster.usingWeights && v30 > -32766) {
                    v30 *= 2;
                }
                pixels[row * ncols + col] = (short)v30;
            }
            if (!raster.halfcol) continue;
            for (col = 1; col < ncols - 1; col += colstep) {
                short l = pixels[row * ncols + col - 1];
                short r = pixels[row * ncols + col + 1];
                int v30 = Short.MIN_VALUE;
                if (l > -32766 && r > -32766) {
                    v30 = (short)((l + r) / 2);
                }
                pixels[row * ncols + col] = v30;
            }
        }
    }
}

