/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.expressions.BExpressionContextWay;
import btools.mapcreator.OsmNodeP;
import btools.util.CheapRuler;
import btools.util.CompactLongMap;
import btools.util.FrozenLongMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class OsmTrafficMap {
    int minLon;
    int minLat;
    int maxLon;
    int maxLat;
    private BExpressionContextWay expctxWay;
    private OsmTrafficMap oldTrafficClasses;
    private DataOutputStream newTrafficDos;
    private File oldTrafficFile;
    private File newTrafficFile;
    private int totalChanges = 0;
    private int supressedChanges = 0;
    private boolean doNotAdd = false;
    private boolean debug = false;
    private CompactLongMap<OsmTrafficElement> map = new CompactLongMap();

    public OsmTrafficMap(BExpressionContextWay expctxWay) {
        this.expctxWay = expctxWay;
        this.debug = Boolean.getBoolean("debugTrafficMap");
    }

    public void loadAll(File file, int minLon, int minLat, int maxLon, int maxLat, boolean includeMotorways) throws Exception {
        this.load(file, minLon, minLat, maxLon, maxLat, includeMotorways);
        this.oldTrafficFile = new File(file.getParentFile(), file.getName() + "_old");
        if (this.oldTrafficFile.exists()) {
            this.oldTrafficClasses = new OsmTrafficMap(null);
            this.oldTrafficClasses.doNotAdd = true;
            this.oldTrafficClasses.load(this.oldTrafficFile, minLon, minLat, maxLon, maxLat, false);
        }
        this.newTrafficFile = new File(file.getParentFile(), file.getName() + "_new");
        this.newTrafficDos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.newTrafficFile)));
    }

    public void finish() throws Exception {
        if (this.newTrafficDos != null) {
            this.newTrafficDos.close();
            this.newTrafficDos = null;
            this.oldTrafficFile.delete();
            this.newTrafficFile.renameTo(this.oldTrafficFile);
            System.out.println("TrafficMap: changes total=" + this.totalChanges + " supressed=" + this.supressedChanges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file, int minLon, int minLat, int maxLon, int maxLat, boolean includeMotorways) throws Exception {
        this.minLon = minLon;
        this.minLat = minLat;
        this.maxLon = maxLon;
        this.maxLat = maxLat;
        int trafficElements = 0;
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            try {
                while (true) {
                    long n1 = is.readLong();
                    long n2 = is.readLong();
                    int traffic = is.readInt();
                    if (traffic == -1 && !includeMotorways || !this.isInsideBounds(n1) && !this.isInsideBounds(n2) || !this.addElement(n1, n2, traffic)) continue;
                    ++trafficElements;
                }
            }
            catch (EOFException eof) {
                is.close();
            }
        }
        catch (Throwable throwable) {
            is.close();
            throw throwable;
        }
        this.map = new FrozenLongMap<OsmTrafficElement>(this.map);
        System.out.println("read traffic-elements: " + trafficElements);
    }

    public boolean addElement(long n1, long n2, int traffic) {
        OsmTrafficElement e = this.getElement(n1, n2);
        if (e == null) {
            e = new OsmTrafficElement();
            e.node2 = n2;
            e.traffic = traffic;
            OsmTrafficElement e0 = this.map.get(n1);
            if (e0 != null) {
                while (e0.next != null) {
                    e0 = e0.next;
                }
                e0.next = e;
            } else {
                this.map.fastPut(n1, e);
            }
            return true;
        }
        e.traffic = this.doNotAdd ? Math.max(e.traffic, traffic) : (e.traffic == -1 || traffic == -1 ? -1 : e.traffic + traffic);
        return false;
    }

    private boolean isInsideBounds(long id) {
        int ilon = (int)(id >> 32);
        int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
        return ilon >= this.minLon && ilon < this.maxLon && ilat >= this.minLat && ilat < this.maxLat;
    }

    public int getTrafficClass(long n1, long n2) {
        OsmTrafficElement e = this.getElement(n1, n2);
        return e == null ? 0 : e.traffic;
    }

    public int getTrafficClassForTraffic(int traffic) {
        if (traffic < 0) {
            return -1;
        }
        if (traffic < 40000) {
            return 0;
        }
        if (traffic < 80000) {
            return 2;
        }
        if (traffic < 160000) {
            return 3;
        }
        if (traffic < 320000) {
            return 4;
        }
        if (traffic < 640000) {
            return 5;
        }
        if (traffic < 1280000) {
            return 6;
        }
        return 7;
    }

    private int getTraffic(long n1, long n2) {
        int traffic2;
        OsmTrafficElement e1 = this.getElement(n1, n2);
        int traffic1 = e1 == null ? 0 : e1.traffic;
        OsmTrafficElement e2 = this.getElement(n2, n1);
        int n = traffic2 = e2 == null ? 0 : e2.traffic;
        return traffic1 == -1 || traffic2 == -1 ? -1 : (traffic1 > traffic2 ? traffic1 : traffic2);
    }

    public void freeze() {
    }

    private OsmTrafficElement getElement(long n1, long n2) {
        OsmTrafficElement e = this.map.get(n1);
        while (e != null) {
            if (e.node2 == n2) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public OsmTrafficElement getElement(long n) {
        return this.map.get(n);
    }

    public byte[] addTrafficClass(ArrayList<OsmNodeP> linkNodes, byte[] description) throws IOException {
        int oldTrafficClass;
        double distance = 0.0;
        double sum = 0.0;
        for (int i = 0; i < linkNodes.size() - 1; ++i) {
            OsmNodeP n1 = linkNodes.get(i);
            OsmNodeP n2 = linkNodes.get(i + 1);
            int traffic = this.getTraffic(n1.getIdFromPos(), n2.getIdFromPos());
            double dist = CheapRuler.distance(n1.ilon, n1.ilat, n2.ilon, n2.ilat);
            distance += dist;
            sum += dist * (double)traffic;
        }
        if (distance == 0.0) {
            return description;
        }
        int traffic = (int)(sum / distance + 0.5);
        long id0 = linkNodes.get(0).getIdFromPos();
        long id1 = linkNodes.get(linkNodes.size() - 1).getIdFromPos();
        int trafficClass = this.getTrafficClassForTraffic(traffic);
        if (this.oldTrafficClasses != null && (oldTrafficClass = this.oldTrafficClasses.getTrafficClass(id0, id1)) != trafficClass) {
            boolean supressChange;
            ++this.totalChanges;
            boolean bl = supressChange = oldTrafficClass == this.getTrafficClassForTraffic((int)((double)traffic * 1.3)) || oldTrafficClass == this.getTrafficClassForTraffic((int)((double)traffic * 0.77));
            if (this.debug) {
                System.out.println("traffic class change " + oldTrafficClass + "->" + trafficClass + " supress=" + supressChange);
            }
            if (supressChange) {
                trafficClass = oldTrafficClass;
                ++this.supressedChanges;
            }
        }
        if (trafficClass > 0) {
            this.newTrafficDos.writeLong(id0);
            this.newTrafficDos.writeLong(id1);
            this.newTrafficDos.writeInt(trafficClass);
            this.expctxWay.decode(description);
            this.expctxWay.addLookupValue("estimated_traffic_class", trafficClass + 1);
            return this.expctxWay.encode();
        }
        return description;
    }

    public static class OsmTrafficElement {
        public long node2;
        public int traffic;
        public OsmTrafficElement next;
    }
}

