/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.DenseLongMap;
import btools.util.DiffCoderDataOutputStream;
import btools.util.TinyDenseLongMap;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class NodeFilter
extends MapCreatorBase {
    private DiffCoderDataOutputStream nodesOutStream;
    private File nodeTilesOut;
    protected DenseLongMap nodebitmap;

    public static void main(String[] args) throws Exception {
        System.out.println("*** NodeFilter: Filter way related nodes");
        if (args.length != 3) {
            System.out.println("usage: java NodeFilter <node-tiles-in> <way-file-in> <node-tiles-out>");
            return;
        }
        new NodeFilter().process(new File(args[0]), new File(args[1]), new File(args[2]));
    }

    public void init() throws Exception {
        this.nodebitmap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap(512) : new TinyDenseLongMap();
    }

    public void process(File nodeTilesIn, File wayFileIn, File nodeTilesOut) throws Exception {
        this.init();
        this.nodeTilesOut = nodeTilesOut;
        new WayIterator(this, false).processFile(wayFileIn);
        new NodeIterator(this, true).processDir(nodeTilesIn, ".tls");
    }

    @Override
    public void nextWay(WayData data) throws Exception {
        int nnodes = data.nodes.size();
        for (int i = 0; i < nnodes; ++i) {
            this.nodebitmap.put(data.nodes.get(i), 0);
        }
    }

    @Override
    public void nodeFileStart(File nodefile) throws Exception {
        String filename = nodefile.getName();
        File outfile = new File(this.nodeTilesOut, filename);
        this.nodesOutStream = new DiffCoderDataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        if (this.isRelevant(n)) {
            n.writeTo(this.nodesOutStream);
        }
    }

    public boolean isRelevant(NodeData n) {
        return this.nodebitmap.getInt(n.nid) == 0;
    }

    @Override
    public void nodeFileEnd(File nodeFile) throws Exception {
        this.nodesOutStream.close();
    }
}

