/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpressionContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;

public final class BExpressionMetaData {
    private static final String CONTEXT_TAG = "---context:";
    private static final String VERSION_TAG = "---lookupversion:";
    private static final String MINOR_VERSION_TAG = "---minorversion:";
    private static final String VARLENGTH_TAG = "---readvarlength";
    public short lookupVersion = (short)-1;
    public short lookupMinorVersion = (short)-1;
    private HashMap<String, BExpressionContext> listeners = new HashMap();

    public void registerListener(String context, BExpressionContext ctx) {
        this.listeners.put(context, ctx);
    }

    public void readMetaData(File lookupsFile) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(lookupsFile));
            BExpressionContext ctx = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith(CONTEXT_TAG)) {
                    ctx = this.listeners.get(line.substring(CONTEXT_TAG.length()));
                    continue;
                }
                if (line.startsWith(VERSION_TAG)) {
                    this.lookupVersion = Short.parseShort(line.substring(VERSION_TAG.length()));
                    continue;
                }
                if (line.startsWith(MINOR_VERSION_TAG)) {
                    this.lookupMinorVersion = Short.parseShort(line.substring(MINOR_VERSION_TAG.length()));
                    continue;
                }
                if (line.startsWith(VARLENGTH_TAG) || ctx == null) continue;
                ctx.parseMetaLine(line);
            }
            br.close();
            for (BExpressionContext c : this.listeners.values()) {
                c.finishMetaParsing();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

