/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.codec.DataBuffers;
import btools.codec.TagValueValidator;
import btools.codec.TagValueWrapper;
import btools.util.BitCoderContext;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;

public final class TagValueCoder {
    private HashMap<TagValueSet, TagValueSet> identityMap;
    private Object tree;
    private BitCoderContext bc;
    private int pass;
    private int nextTagValueSetId;

    public void encodeTagValueSet(byte[] data) {
        if (this.pass == 1) {
            return;
        }
        TagValueSet tvsProbe = new TagValueSet(this.nextTagValueSetId);
        tvsProbe.data = data;
        TagValueSet tvs = this.identityMap.get(tvsProbe);
        if (this.pass == 3) {
            this.bc.encodeBounded(tvs.range - 1, tvs.code);
        } else if (this.pass == 2) {
            if (tvs == null) {
                tvs = tvsProbe;
                ++this.nextTagValueSetId;
                this.identityMap.put(tvs, tvs);
            }
            ++tvs.frequency;
        }
    }

    public TagValueWrapper decodeTagValueSet() {
        Object node = this.tree;
        while (node instanceof TreeNode) {
            TreeNode tn = (TreeNode)node;
            boolean nextBit = this.bc.decodeBit();
            node = nextBit ? tn.child2 : tn.child1;
        }
        return (TagValueWrapper)node;
    }

    public void encodeDictionary(BitCoderContext bc) {
        if (++this.pass == 3) {
            if (this.identityMap.size() == 0) {
                TagValueSet dummy = new TagValueSet(this.nextTagValueSetId++);
                this.identityMap.put(dummy, dummy);
            }
            PriorityQueue<TagValueSet> queue = new PriorityQueue<TagValueSet>(2 * this.identityMap.size(), new TagValueSet.FrequencyComparator());
            queue.addAll(this.identityMap.values());
            while (queue.size() > 1) {
                TagValueSet node = new TagValueSet(this.nextTagValueSetId++);
                node.child1 = queue.poll();
                node.child2 = queue.poll();
                node.frequency = node.child1.frequency + node.child2.frequency;
                queue.add(node);
            }
            TagValueSet root = queue.poll();
            root.encode(bc, 1, 0);
        }
        this.bc = bc;
    }

    public TagValueCoder(BitCoderContext bc, DataBuffers buffers, TagValueValidator validator) {
        this.tree = this.decodeTree(bc, buffers, validator);
        this.bc = bc;
    }

    public TagValueCoder() {
        this.identityMap = new HashMap();
    }

    private Object decodeTree(BitCoderContext bc, DataBuffers buffers, TagValueValidator validator) {
        int accessType;
        byte[] res;
        boolean isNode = bc.decodeBit();
        if (isNode) {
            TreeNode node = new TreeNode();
            node.child1 = this.decodeTree(bc, buffers, validator);
            node.child2 = this.decodeTree(bc, buffers, validator);
            return node;
        }
        byte[] buffer = buffers.tagbuf1;
        BitCoderContext ctx = buffers.bctx1;
        ctx.reset(buffer);
        int inum = 0;
        int lastEncodedInum = 0;
        boolean hasdata = false;
        while (true) {
            int delta = bc.decodeVarBits();
            if (!hasdata && delta == 0) {
                return null;
            }
            if (delta == 0) break;
            int data = bc.decodeVarBits();
            if (validator != null && !validator.isLookupIdxUsed(inum += delta)) continue;
            hasdata = true;
            ctx.encodeVarBits(inum - lastEncodedInum);
            ctx.encodeVarBits(data);
            lastEncodedInum = inum;
        }
        ctx.encodeVarBits(0);
        int len = ctx.closeAndGetEncodedLength();
        if (validator == null) {
            res = new byte[len];
            System.arraycopy(buffer, 0, res, 0, len);
        } else {
            res = validator.unify(buffer, 0, len);
        }
        int n = accessType = validator == null ? 2 : validator.accessType(res);
        if (accessType > 0) {
            TagValueWrapper w = new TagValueWrapper();
            w.data = res;
            w.accessType = accessType;
            return w;
        }
        return null;
    }

    public static final class TagValueSet {
        public byte[] data;
        public int frequency;
        public int code;
        public int range;
        public TagValueSet child1;
        public TagValueSet child2;
        private int id;

        public TagValueSet(int id) {
            this.id = id;
        }

        public void encode(BitCoderContext bc, int range, int code) {
            this.range = range;
            this.code = code;
            boolean isNode = this.child1 != null;
            bc.encodeBit(isNode);
            if (isNode) {
                this.child1.encode(bc, range << 1, code);
                this.child2.encode(bc, range << 1, code + range);
            } else {
                if (this.data == null) {
                    bc.encodeVarBits(0);
                    return;
                }
                BitCoderContext src = new BitCoderContext(this.data);
                while (true) {
                    int delta = src.decodeVarBits();
                    bc.encodeVarBits(delta);
                    if (delta == 0) break;
                    int data = src.decodeVarBits();
                    bc.encodeVarBits(data);
                }
            }
        }

        public boolean equals(Object o) {
            if (o instanceof TagValueSet) {
                TagValueSet tvs = (TagValueSet)o;
                if (this.data == null) {
                    return tvs.data == null;
                }
                if (tvs.data == null) {
                    return this.data == null;
                }
                if (this.data.length != tvs.data.length) {
                    return false;
                }
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == tvs.data[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.data == null) {
                return 0;
            }
            int h = 17;
            for (int i = 0; i < this.data.length; ++i) {
                h = (h << 8) + this.data[i];
            }
            return h;
        }

        public static class FrequencyComparator
        implements Comparator<TagValueSet> {
            @Override
            public int compare(TagValueSet tvs1, TagValueSet tvs2) {
                if (tvs1.frequency < tvs2.frequency) {
                    return -1;
                }
                if (tvs1.frequency > tvs2.frequency) {
                    return 1;
                }
                if (tvs1.id < tvs2.id) {
                    return -1;
                }
                if (tvs1.id > tvs2.id) {
                    return 1;
                }
                if (tvs1 != tvs2) {
                    throw new RuntimeException("identity corruption!");
                }
                return 0;
            }
        }
    }

    public static final class TreeNode {
        public Object child1;
        public Object child2;
    }
}

