/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.util.ByteDataWriter;

public class MicroCache
extends ByteDataWriter {
    protected int[] faid;
    protected int[] fapos;
    protected int size = 0;
    private int delcount = 0;
    private int delbytes = 0;
    private int p2size;
    public boolean virgin = true;
    public boolean ghost = false;
    public static boolean debug = false;
    public static final MicroCache emptyNonVirgin = new MicroCache(null);

    protected MicroCache(byte[] ab) {
        super(ab);
    }

    public static MicroCache emptyCache() {
        return new MicroCache(null);
    }

    protected void init(int size) {
        this.size = size;
        this.delcount = 0;
        this.delbytes = 0;
        this.p2size = 0x40000000;
        while (this.p2size > size) {
            this.p2size >>= 1;
        }
    }

    public final void finishNode(long id) {
        this.fapos[this.size] = this.aboffset;
        this.faid[this.size] = this.shrinkId(id);
        ++this.size;
    }

    public final void discardNode() {
        this.aboffset = this.startPos(this.size);
    }

    public final int getSize() {
        return this.size;
    }

    public final int getDataSize() {
        return this.ab == null ? 0 : this.ab.length;
    }

    public final boolean getAndClear(long id64) {
        if (this.size == 0) {
            return false;
        }
        int id = this.shrinkId(id64);
        int[] a = this.faid;
        int n = 0;
        for (int offset = this.p2size; offset > 0; offset >>= 1) {
            int nn = n + offset;
            if (nn >= this.size || a[nn] > id) continue;
            n = nn;
        }
        if (a[n] == id && (this.fapos[n] & Integer.MIN_VALUE) == 0) {
            this.aboffset = this.startPos(n);
            this.aboffsetEnd = this.fapos[n];
            int n2 = n;
            this.fapos[n2] = this.fapos[n2] | Integer.MIN_VALUE;
            this.delbytes += this.aboffsetEnd - this.aboffset;
            ++this.delcount;
            return true;
        }
        return false;
    }

    protected final int startPos(int n) {
        return n > 0 ? this.fapos[n - 1] & Integer.MAX_VALUE : 0;
    }

    public final int collect(int threshold) {
        if (this.delcount <= threshold) {
            return 0;
        }
        this.virgin = false;
        int nsize = this.size - this.delcount;
        if (nsize == 0) {
            this.faid = null;
            this.fapos = null;
        } else {
            int[] nfaid = new int[nsize];
            int[] nfapos = new int[nsize];
            int idx = 0;
            byte[] nab = new byte[this.ab.length - this.delbytes];
            int nab_off = 0;
            for (int i = 0; i < this.size; ++i) {
                int pos = this.fapos[i];
                if ((pos & Integer.MIN_VALUE) != 0) continue;
                int start = this.startPos(i);
                int end = this.fapos[i];
                int len = end - start;
                System.arraycopy(this.ab, start, nab, nab_off, len);
                nfaid[idx] = this.faid[i];
                nfapos[idx] = nab_off += len;
                ++idx;
            }
            this.faid = nfaid;
            this.fapos = nfapos;
            this.ab = nab;
        }
        int deleted = this.delbytes;
        this.init(nsize);
        return deleted;
    }

    public final void unGhost() {
        this.ghost = false;
        this.delcount = 0;
        this.delbytes = 0;
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.fapos[n] = this.fapos[n] & Integer.MAX_VALUE;
        }
    }

    public final long getIdForIndex(int i) {
        int id32 = this.faid[i];
        return this.expandId(id32);
    }

    public long expandId(int id32) {
        throw new IllegalArgumentException("expandId for empty cache");
    }

    public int shrinkId(long id64) {
        throw new IllegalArgumentException("shrinkId for empty cache");
    }

    public boolean isInternal(int ilon, int ilat) {
        throw new IllegalArgumentException("isInternal for empty cache");
    }

    public int encodeMicroCache(byte[] buffer) {
        throw new IllegalArgumentException("encodeMicroCache for empty cache");
    }

    public String compareWith(MicroCache mc) {
        String msg = this._compareWith(mc);
        if (msg != null) {
            StringBuilder sb = new StringBuilder(msg);
            sb.append("\nencode cache:\n").append(this.summary());
            sb.append("\ndecode cache:\n").append(mc.summary());
            return sb.toString();
        }
        return null;
    }

    private String summary() {
        StringBuilder sb = new StringBuilder("size=" + this.size + " aboffset=" + this.aboffset);
        for (int i = 0; i < this.size; ++i) {
            sb.append("\nidx=" + i + " faid=" + this.faid[i] + " fapos=" + this.fapos[i]);
        }
        return sb.toString();
    }

    private String _compareWith(MicroCache mc) {
        if (this.size != mc.size) {
            return "size missmatch: " + this.size + "->" + mc.size;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.faid[i] != mc.faid[i]) {
                return "faid missmatch at index " + i + ":" + this.faid[i] + "->" + mc.faid[i];
            }
            int start = i > 0 ? this.fapos[i - 1] : 0;
            int end = this.fapos[i] < mc.fapos[i] ? this.fapos[i] : mc.fapos[i];
            int len = end - start;
            for (int offset = 0; offset < len; ++offset) {
                if (mc.ab.length <= start + offset) {
                    return "data buffer too small";
                }
                if (this.ab[start + offset] == mc.ab[start + offset]) continue;
                return "data missmatch at index " + i + " offset=" + offset;
            }
            if (this.fapos[i] == mc.fapos[i]) continue;
            return "fapos missmatch at index " + i + ":" + this.fapos[i] + "->" + mc.fapos[i];
        }
        if (this.aboffset != mc.aboffset) {
            return "datasize missmatch: " + this.aboffset + "->" + mc.aboffset;
        }
        return null;
    }

    public void calcDelta(MicroCache mc1, MicroCache mc2) {
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < mc1.size || idx2 < mc2.size) {
            int id;
            int id2;
            int id1 = idx1 < mc1.size ? mc1.faid[idx1] : Integer.MAX_VALUE;
            int n = id2 = idx2 < mc2.size ? mc2.faid[idx2] : Integer.MAX_VALUE;
            if (id1 >= id2) {
                id = id2;
                int start2 = idx2 > 0 ? mc2.fapos[idx2 - 1] : 0;
                int len2 = mc2.fapos[idx2++] - start2;
                if (id1 == id2) {
                    int len1;
                    int start1 = idx1 > 0 ? mc1.fapos[idx1 - 1] : 0;
                    if ((len1 = mc1.fapos[idx1++] - start1) == len2) {
                        int i;
                        for (i = 0; i < len1 && mc1.ab[start1 + i] == mc2.ab[start2 + i]; ++i) {
                        }
                        if (i == len1) continue;
                    }
                }
                this.write(mc2.ab, start2, len2);
            } else {
                ++idx1;
                id = id1;
            }
            this.fapos[this.size] = this.aboffset;
            this.faid[this.size] = id;
            ++this.size;
        }
    }

    public void addDelta(MicroCache mc1, MicroCache mc2, boolean keepEmptyNodes) {
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < mc1.size || idx2 < mc2.size) {
            int id2;
            int id1 = idx1 < mc1.size ? mc1.faid[idx1] : Integer.MAX_VALUE;
            int n = id2 = idx2 < mc2.size ? mc2.faid[idx2] : Integer.MAX_VALUE;
            if (id1 >= id2) {
                int start2 = idx2 > 0 ? mc2.fapos[idx2 - 1] : 0;
                int len2 = mc2.fapos[idx2++] - start2;
                if (keepEmptyNodes || len2 > 0) {
                    this.write(mc2.ab, start2, len2);
                    this.fapos[this.size] = this.aboffset;
                    this.faid[this.size++] = id2;
                }
                if (id1 != id2) continue;
                ++idx1;
                continue;
            }
            int start1 = idx1 > 0 ? mc1.fapos[idx1 - 1] : 0;
            int len1 = mc1.fapos[idx1++] - start1;
            this.write(mc1.ab, start1, len1);
            this.fapos[this.size] = this.aboffset;
            this.faid[this.size++] = id1;
        }
    }

    static {
        MicroCache.emptyNonVirgin.virgin = false;
    }
}

