/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public class BitCoderContext {
    private byte[] ab;
    private int idxMax;
    private int idx = -1;
    private int bits;
    private int b;
    public static final int[] vl_values;
    public static final int[] vl_length;
    private static final int[] vc_values;
    private static final int[] vc_length;
    private static final int[] reverse_byte;
    private static final int[] bm2bits;

    public BitCoderContext(byte[] ab) {
        this.ab = ab;
        this.idxMax = ab.length - 1;
    }

    public final void reset(byte[] ab) {
        this.ab = ab;
        this.idxMax = ab.length - 1;
        this.reset();
    }

    public final void reset() {
        this.idx = -1;
        this.bits = 0;
        this.b = 0;
    }

    public final void encodeVarBits2(int value) {
        int range = 0;
        while (value > range) {
            this.encodeBit(false);
            value -= range + 1;
            range = 2 * range + 1;
        }
        this.encodeBit(true);
        this.encodeBounded(range, value);
    }

    public final void encodeVarBits(int value) {
        if ((value & 0xFFF) == value) {
            this.flushBuffer();
            this.b |= vc_values[value] << this.bits;
            this.bits += vc_length[value];
        } else {
            this.encodeVarBits2(value);
        }
    }

    public final int decodeVarBits2() {
        int range = 0;
        while (!this.decodeBit()) {
            range = 2 * range + 1;
        }
        return range + this.decodeBounded(range);
    }

    public final int decodeVarBits() {
        this.fillBuffer();
        int b12 = this.b & 0xFFF;
        int len = vl_length[b12];
        if (len <= 12) {
            this.b >>>= len;
            this.bits -= len;
            return vl_values[b12];
        }
        if (len <= 23) {
            int len2 = len >> 1;
            this.b >>>= len2 + 1;
            int mask = -1 >>> 32 - len2;
            mask += this.b & mask;
            this.b >>>= len2;
            this.bits -= len;
            return mask;
        }
        if ((this.b & 0xFFFFFF) != 0) {
            this.b >>>= 12;
            int len3 = 1 + (vl_length[this.b & 0xFFF] >> 1);
            this.b >>>= len3;
            int len2 = 11 + len3;
            this.bits -= len2 + 1;
            this.fillBuffer();
            int mask = -1 >>> 32 - len2;
            mask += this.b & mask;
            this.b >>>= len2;
            this.bits -= len2;
            return mask;
        }
        return this.decodeVarBits2();
    }

    public final void encodeBit(boolean value) {
        if (this.bits > 31) {
            this.ab[++this.idx] = (byte)(this.b & 0xFF);
            this.b >>>= 8;
            this.bits -= 8;
        }
        if (value) {
            this.b |= 1 << this.bits;
        }
        ++this.bits;
    }

    public final boolean decodeBit() {
        if (this.bits == 0) {
            this.bits = 8;
            this.b = this.ab[++this.idx] & 0xFF;
        }
        boolean value = (this.b & 1) != 0;
        this.b >>>= 1;
        --this.bits;
        return value;
    }

    public final void encodeBounded(int max, int value) {
        for (int im = 1; im <= max; im <<= 1) {
            if ((value & im) != 0) {
                this.encodeBit(true);
                max -= im;
                continue;
            }
            this.encodeBit(false);
        }
    }

    public final int decodeBounded(int max) {
        int value = 0;
        int im = 1;
        while ((value | im) <= max) {
            if (this.bits == 0) {
                this.bits = 8;
                this.b = this.ab[++this.idx] & 0xFF;
            }
            if ((this.b & 1) != 0) {
                value |= im;
            }
            this.b >>>= 1;
            --this.bits;
            im <<= 1;
        }
        return value;
    }

    public final int decodeBits(int count) {
        this.fillBuffer();
        int mask = -1 >>> 32 - count;
        int value = this.b & mask;
        this.b >>>= count;
        this.bits -= count;
        return value;
    }

    public final int decodeBitsReverse(int count) {
        this.fillBuffer();
        int value = 0;
        while (count > 8) {
            value = value << 8 | reverse_byte[this.b & 0xFF];
            this.b >>= 8;
            count -= 8;
            this.bits -= 8;
            this.fillBuffer();
        }
        value = value << count | reverse_byte[this.b & 0xFF] >> 8 - count;
        this.bits -= count;
        this.b >>= count;
        return value;
    }

    private void fillBuffer() {
        while (this.bits < 24) {
            if (this.idx++ < this.idxMax) {
                this.b |= (this.ab[this.idx] & 0xFF) << this.bits;
            }
            this.bits += 8;
        }
    }

    private void flushBuffer() {
        while (this.bits > 7) {
            this.ab[++this.idx] = (byte)(this.b & 0xFF);
            this.b >>>= 8;
            this.bits -= 8;
        }
    }

    public final int closeAndGetEncodedLength() {
        this.flushBuffer();
        if (this.bits > 0) {
            this.ab[++this.idx] = (byte)(this.b & 0xFF);
        }
        return this.idx + 1;
    }

    public final int getWritingBitPosition() {
        return (this.idx << 3) + 8 + this.bits;
    }

    public final int getReadingBitPosition() {
        return (this.idx << 3) + 8 - this.bits;
    }

    public final void setReadingBitPosition(int pos) {
        this.idx = pos >>> 3;
        this.bits = (this.idx << 3) + 8 - pos;
        this.b = this.ab[this.idx] & 0xFF;
        this.b >>>= 8 - this.bits;
    }

    public static void main(String[] args) {
        int value;
        int i;
        byte[] ab = new byte[581969];
        BitCoderContext ctx = new BitCoderContext(ab);
        for (i = 0; i < 31; ++i) {
            ctx.encodeVarBits((1 << i) + 3);
        }
        for (i = 0; i < 100000; i += 13) {
            ctx.encodeVarBits(i);
        }
        ctx.closeAndGetEncodedLength();
        ctx = new BitCoderContext(ab);
        for (i = 0; i < 31; ++i) {
            int v0 = (1 << i) + 3;
            value = ctx.decodeVarBits();
            if (v0 == value) continue;
            throw new RuntimeException("value mismatch value=" + value + "v0=" + v0);
        }
        for (i = 0; i < 100000; i += 13) {
            value = ctx.decodeVarBits();
            if (value == i) continue;
            throw new RuntimeException("value mismatch i=" + i + "v=" + value);
        }
    }

    static {
        int b;
        int b0;
        int i;
        vl_values = new int[4096];
        vl_length = new int[4096];
        vc_values = new int[4096];
        vc_length = new int[4096];
        reverse_byte = new int[256];
        bm2bits = new int[256];
        BitCoderContext bc = new BitCoderContext(new byte[4]);
        for (i = 0; i < 4096; ++i) {
            bc.reset();
            bc.bits = 14;
            bc.b = 4096 + i;
            b0 = bc.getReadingBitPosition();
            BitCoderContext.vl_values[i] = bc.decodeVarBits2();
            BitCoderContext.vl_length[i] = bc.getReadingBitPosition() - b0;
        }
        for (i = 0; i < 4096; ++i) {
            bc.reset();
            b0 = bc.getWritingBitPosition();
            bc.encodeVarBits2(i);
            BitCoderContext.vc_values[i] = bc.b;
            BitCoderContext.vc_length[i] = bc.getWritingBitPosition() - b0;
        }
        for (i = 0; i < 1024; ++i) {
            bc.reset();
            bc.bits = 14;
            bc.b = 4096 + i;
            b0 = bc.getReadingBitPosition();
            BitCoderContext.vl_values[i] = bc.decodeVarBits2();
            BitCoderContext.vl_length[i] = bc.getReadingBitPosition() - b0;
        }
        for (b = 0; b < 256; ++b) {
            int r = 0;
            for (int i2 = 0; i2 < 8; ++i2) {
                if ((b & 1 << i2) == 0) continue;
                r |= 1 << 7 - i2;
            }
            BitCoderContext.reverse_byte[b] = r;
        }
        for (b = 0; b < 8; ++b) {
            BitCoderContext.bm2bits[1 << b] = b;
        }
    }
}

