/*
 * Decompiled with CFR 0.152.
 */
package btools.server.request;

import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.server.ServiceContext;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;

public class ProfileUploadHandler {
    private static final int MAX_LENGTH = 100000;
    public static final String CUSTOM_PREFIX = "custom_";
    public static final String SHARED_PREFIX = "shared_";
    private ServiceContext serviceContext;

    public ProfileUploadHandler(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePostRequest(String profileId, BufferedReader br, BufferedWriter response) throws IOException {
        BufferedWriter fileWriter = null;
        try {
            String id = profileId != null ? profileId.substring(CUSTOM_PREFIX.length()) : "" + System.currentTimeMillis();
            File file = new File(this.getOrCreateCustomProfileDir(), id + ".brf");
            fileWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            ProfileUploadHandler.readPostData(br, fileWriter, id);
            fileWriter.flush();
            HashMap<String, String> responseData = new HashMap<String, String>();
            responseData.put("profileid", CUSTOM_PREFIX + id);
            this.validateProfile(id, responseData);
            response.write(this.toJSON(responseData));
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private File getOrCreateCustomProfileDir() {
        File customProfileDir = new File(this.serviceContext.profileDir, this.serviceContext.customProfileDir);
        if (!customProfileDir.exists()) {
            customProfileDir.mkdir();
        }
        return customProfileDir;
    }

    private static void readPostData(BufferedReader ir, BufferedWriter bw, String id) throws IOException {
        block4: {
            int numChars = 0;
            do {
                int c;
                if (!ir.ready()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!ir.ready()) break block4;
                }
                if ((c = ir.read()) == -1) break block4;
                bw.write(c);
            } while (++numChars <= 100000);
            throw new IOException("Maximum number of characters exceeded (100000, " + id + ")");
        }
    }

    private String toJSON(Map<String, String> data) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String> entry : data.entrySet()) {
            sb.append(first ? "\n" : ",\n");
            sb.append("  \"");
            sb.append(entry.getKey());
            sb.append("\": \"");
            sb.append(entry.getValue());
            sb.append("\"");
            first = false;
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public void validateProfile(String id, Map<String, String> responseData) {
        try {
            RoutingContext rc = new RoutingContext();
            rc.localFunction = this.serviceContext.customProfileDir + "/" + id;
            new RoutingEngine(null, null, null, null, rc);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = "";
            } else if (msg.indexOf("does not contain expressions for context") >= 0) {
                msg = msg.substring(msg.indexOf("does not contain expressions for context"));
            }
            responseData.put("error", "Profile error: " + msg);
        }
    }
}

