/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Polygon {
    private int[] ax;
    private int[] ay;
    private int minx = Integer.MAX_VALUE;
    private int miny = Integer.MAX_VALUE;
    private int maxx = Integer.MIN_VALUE;
    private int maxy = Integer.MIN_VALUE;

    public Polygon(BufferedReader br) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null && !"END".equals(line)) {
            lines.add(line);
        }
        int n = lines.size();
        this.ax = new int[n];
        this.ay = new int[n];
        for (int i = 0; i < n; ++i) {
            String line2 = (String)lines.get(i);
            StringTokenizer tk = new StringTokenizer(line2);
            double lon = Double.parseDouble(tk.nextToken());
            double lat = Double.parseDouble(tk.nextToken());
            int x = this.ax[i] = (int)(lon * 1000000.0 + 1.8E8);
            int y = this.ay[i] = (int)(lat * 1000000.0 + 9.0E7);
            if (x < this.minx) {
                this.minx = x;
            }
            if (y < this.miny) {
                this.miny = y;
            }
            if (x > this.maxx) {
                this.maxx = x;
            }
            if (y <= this.maxy) continue;
            this.maxy = y;
        }
    }

    public boolean isInPolygon(long id) {
        int x = (int)(id >> 32);
        int y = (int)(id & 0xFFFFFFFFFFFFFFFFL);
        if (x < this.minx || x > this.maxx || y < this.miny || y > this.maxy) {
            return false;
        }
        int n = this.ax.length - 1;
        boolean inside = false;
        int j = n - 1;
        int i = 0;
        while (i < n) {
            if (this.ay[i] > y != this.ay[j] > y) {
                long v = this.ax[j] - this.ax[i];
                v *= (long)(y - this.ay[i]);
                if ((long)x <= (v /= (long)(this.ay[j] - this.ay[i])) + (long)this.ax[i]) {
                    inside = !inside;
                }
            }
            j = i++;
        }
        return inside;
    }

    public boolean isInBoundingBox(long id) {
        int x = (int)(id >> 32);
        int y = (int)(id & 0xFFFFFFFFFFFFFFFFL);
        return x >= this.minx && x <= this.maxx && y >= this.miny && y <= this.maxy;
    }
}

