/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.KinematicModel;
import btools.router.KinematicPrePath;
import btools.router.OsmPath;
import btools.router.OsmPrePath;
import btools.router.RoutingContext;
import btools.util.FastMath;

final class KinematicPath
extends OsmPath {
    private double ekin;
    private double totalTime;
    private double totalEnergy;
    private float floatingAngleLeft;
    private float floatingAngleRight;

    KinematicPath() {
    }

    @Override
    protected void init(OsmPath orig) {
        KinematicPath origin = (KinematicPath)orig;
        this.ekin = origin.ekin;
        this.totalTime = origin.totalTime;
        this.totalEnergy = origin.totalEnergy;
        this.floatingAngleLeft = origin.floatingAngleLeft;
        this.floatingAngleRight = origin.floatingAngleRight;
        this.priorityclassifier = origin.priorityclassifier;
    }

    @Override
    protected void resetState() {
        this.ekin = 0.0;
        this.totalTime = 0.0;
        this.totalEnergy = 0.0;
        this.floatingAngleLeft = 0.0f;
        this.floatingAngleRight = 0.0f;
    }

    @Override
    protected double processWaySection(RoutingContext rc, double dist, double delta_h, double elevation, double angle, double cosangle, boolean isStartpoint, int nsection, int lastpriorityclassifier) {
        KinematicModel km = (KinematicModel)rc.pm;
        double cost = 0.0;
        double extraTime = 0.0;
        if (isStartpoint) {
            if (!rc.inverseDirection) {
                extraTime = 0.5 * (1.0 - cosangle) * 40.0;
            }
        } else {
            double turnspeed = 999.0;
            if (km.turnAngleDecayTime != 0.0) {
                if (angle < 0.0) {
                    this.floatingAngleLeft -= (float)angle;
                } else {
                    this.floatingAngleRight += (float)angle;
                }
                float aa = Math.max(this.floatingAngleLeft, this.floatingAngleRight);
                double curveSpeed = (double)aa > 10.0 ? 200.0 / (double)aa : 20.0;
                double distanceTime = dist / curveSpeed;
                double decayFactor = FastMath.exp(-distanceTime / km.turnAngleDecayTime);
                this.floatingAngleLeft = (float)((double)this.floatingAngleLeft * decayFactor);
                this.floatingAngleRight = (float)((double)this.floatingAngleRight * decayFactor);
                if (curveSpeed < 20.0) {
                    turnspeed = curveSpeed;
                }
            }
            if (nsection == 0) {
                double junctionspeed = 999.0;
                int classifiermask = (int)rc.expctxWay.getClassifierMask();
                boolean hasLeftWay = false;
                boolean hasRightWay = false;
                boolean hasResidential = false;
                OsmPrePath prePath = rc.firstPrePath;
                while (prePath != null) {
                    KinematicPrePath pp = (KinematicPrePath)prePath;
                    if (((pp.classifiermask ^ classifiermask) & 8) == 0) {
                        if ((pp.classifiermask & 0x20) != 0) {
                            hasResidential = true;
                        }
                        if (pp.priorityclassifier > this.priorityclassifier || pp.priorityclassifier == this.priorityclassifier && this.priorityclassifier < 20) {
                            double diff = pp.angle - angle;
                            if (diff < -40.0 && diff > -140.0) {
                                hasLeftWay = true;
                            }
                            if (diff > 40.0 && diff < 140.0) {
                                hasRightWay = true;
                            }
                        }
                    }
                    prePath = prePath.next;
                }
                double residentialSpeed = 13.0;
                if (hasLeftWay && junctionspeed > km.leftWaySpeed) {
                    junctionspeed = km.leftWaySpeed;
                }
                if (hasRightWay && junctionspeed > km.rightWaySpeed) {
                    junctionspeed = km.rightWaySpeed;
                }
                if (hasResidential && junctionspeed > residentialSpeed) {
                    junctionspeed = residentialSpeed;
                }
                if (lastpriorityclassifier < 20 ^ this.priorityclassifier < 20) {
                    extraTime += 10.0;
                    junctionspeed = 0.0;
                }
                if (lastpriorityclassifier != this.priorityclassifier && (classifiermask & 8) != 0) {
                    extraTime += 2.0;
                }
                double d = turnspeed = turnspeed > junctionspeed ? junctionspeed : turnspeed;
                if (this.message != null) {
                    this.message.vnode0 = (int)(junctionspeed * 3.6 + 0.5);
                }
            }
            this.cutEkin(km.totalweight, turnspeed);
        }
        double tcorr = (20.0 - km.outside_temp) * 0.0035;
        double ecorr = 1.375E-4 * (elevation - 100.0);
        double f_air = km.f_air * (1.0 + tcorr - ecorr);
        double distanceCost = this.evolveDistance(km, dist, delta_h, f_air);
        if (this.message != null) {
            this.message.costfactor = (float)(distanceCost / dist);
            this.message.vmax = (int)((double)km.getWayMaxspeed() * 3.6 + 0.5);
            this.message.vmaxExplicit = (int)((double)km.getWayMaxspeedExplicit() * 3.6 + 0.5);
            this.message.vmin = (int)((double)km.getWayMinspeed() * 3.6 + 0.5);
            this.message.extraTime = (int)(extraTime * 1000.0);
        }
        this.totalTime += extraTime;
        return (cost += extraTime * km.pw / km.cost0) + distanceCost;
    }

    protected double evolveDistance(KinematicModel km, double dist, double delta_h, double f_air) {
        double fh = delta_h * km.totalweight * 9.81 / dist;
        double effectiveSpeedLimit = km.getEffectiveSpeedLimit();
        double emax = 0.5 * km.totalweight * effectiveSpeedLimit * effectiveSpeedLimit;
        if (emax <= 0.0) {
            return -1.0;
        }
        double vb = km.getBreakingSpeed(effectiveSpeedLimit);
        double elow = 0.5 * km.totalweight * vb * vb;
        double elapsedTime = 0.0;
        double dissipatedEnergy = 0.0;
        double v = Math.sqrt(2.0 * this.ekin / km.totalweight);
        double d = dist;
        while (d > 0.0) {
            double timeStep;
            double delta_ekin;
            double x;
            boolean slow = this.ekin < elow;
            boolean fast = this.ekin >= emax;
            double etarget = slow ? elow : emax;
            double f = km.f_roll + f_air * v * v + fh;
            double f_recup = Math.max(0.0, fast ? -f : (slow ? km.f_recup : 0.0) - fh);
            f += f_recup;
            if (fast) {
                x = d;
                delta_ekin = x * f;
                timeStep = x / v;
                this.ekin = etarget;
            } else {
                delta_ekin = etarget - this.ekin;
                double x0 = delta_ekin / f;
                double b = 2.0 * f_air / km.totalweight;
                double x0b = x0 * b;
                x = x0 * (1.0 - x0b * (0.5 + x0b * (0.333333333 - x0b * 0.25)));
                double maxstep = Math.min(50.0, d);
                if (x >= maxstep) {
                    x = maxstep;
                    double xb = x * b;
                    delta_ekin = x * f * (1.0 + xb * (0.5 + xb * (0.166666667 + xb * 0.0416666667)));
                    this.ekin += delta_ekin;
                } else {
                    this.ekin = etarget;
                }
                double v2 = Math.sqrt(2.0 * this.ekin / km.totalweight);
                double a = f / km.totalweight;
                timeStep = (v2 - v) / a;
                v = v2;
            }
            d -= x;
            elapsedTime += timeStep;
            dissipatedEnergy += delta_ekin - x * (fh + f_recup * km.recup_efficiency);
            double ieRecup = x * f_recup * (1.0 - km.recup_efficiency);
            double eaux = timeStep * km.p_standby;
            dissipatedEnergy -= Math.max(ieRecup, eaux) * 0.5;
        }
        this.totalTime += elapsedTime;
        this.totalEnergy += (dissipatedEnergy += elapsedTime * km.p_standby) + dist * fh;
        return (km.pw * elapsedTime + dissipatedEnergy) / km.cost0;
    }

    @Override
    protected double processTargetNode(RoutingContext rc) {
        KinematicModel km = (KinematicModel)rc.pm;
        if (this.targetNode.nodeDescription != null) {
            rc.expctxNode.evaluate(false, this.targetNode.nodeDescription);
            float initialcost = rc.expctxNode.getInitialcost();
            if ((double)initialcost >= 1000000.0) {
                return -1.0;
            }
            this.cutEkin(km.totalweight, km.getNodeMaxspeed());
            if (this.message != null) {
                this.message.linknodecost += (int)initialcost;
                this.message.nodeKeyValues = rc.expctxNode.getKeyValueDescription(false, this.targetNode.nodeDescription);
                this.message.vnode1 = (int)((double)km.getNodeMaxspeed() * 3.6 + 0.5);
            }
            return initialcost;
        }
        return 0.0;
    }

    private void cutEkin(double weight, double speed) {
        double e = 0.5 * weight * speed * speed;
        if (this.ekin > e) {
            this.ekin = e;
        }
    }

    @Override
    public int elevationCorrection(RoutingContext rc) {
        return 0;
    }

    @Override
    public boolean definitlyWorseThan(OsmPath path, RoutingContext rc) {
        KinematicPath p = (KinematicPath)path;
        int c = p.cost;
        return this.cost > c + 100;
    }

    @Override
    public double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public double getTotalEnergy() {
        return this.totalEnergy;
    }
}

