/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.codec.DataBuffers;
import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.codec.StatCoderContext;
import btools.expressions.BExpressionContextWay;
import btools.expressions.BExpressionMetaData;
import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.OsmLinkP;
import btools.mapcreator.OsmNodeP;
import btools.mapcreator.OsmNodePT;
import btools.mapcreator.OsmTrafficMap;
import btools.mapcreator.RestrictionData;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.ByteArrayUnifier;
import btools.util.CompactLongMap;
import btools.util.CompactLongSet;
import btools.util.Crc32;
import btools.util.DiffCoderDataOutputStream;
import btools.util.FrozenLongMap;
import btools.util.FrozenLongSet;
import btools.util.LazyArrayOfLists;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.TreeMap;

public class WayLinker
extends MapCreatorBase
implements Runnable {
    private File nodeTilesIn;
    private File wayTilesIn;
    private File trafficTilesIn;
    private File dataTilesOut;
    private File borderFileIn;
    private File restrictionsFileIn;
    private String dataTilesSuffix;
    private boolean readingBorder;
    private CompactLongMap<OsmNodeP> nodesMap;
    private OsmTrafficMap trafficMap;
    private List<OsmNodeP> nodesList;
    private CompactLongSet borderSet;
    private short lookupVersion;
    private short lookupMinorVersion;
    private long creationTimeStamp;
    private BExpressionContextWay expctxWay;
    private ByteArrayUnifier abUnifier;
    private int minLon;
    private int minLat;
    private int microCacheEncoding = 2;
    private int divisor = 32;
    private int cellsize = 1000000 / this.divisor;
    private boolean skipEncodingCheck;
    private boolean isSlave;
    private ThreadController tc;

    private void reset() {
        this.minLon = -1;
        this.minLat = -1;
        this.nodesMap = new CompactLongMap();
        this.borderSet = new CompactLongSet();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("*** WayLinker: Format a region of an OSM map for routing");
        if (args.length != 8) {
            System.out.println("usage: java WayLinker <node-tiles-in> <way-tiles-in> <bordernodes> <restrictions> <lookup-file> <profile-file> <data-tiles-out> <data-tiles-suffix> ");
            return;
        }
        new WayLinker().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), new File(args[4]), new File(args[5]), new File(args[6]), args[7]);
    }

    public void process(File nodeTilesIn, File wayTilesIn, File borderFileIn, File restrictionsFileIn, File lookupFile, File profileFile, File dataTilesOut, String dataTilesSuffix) throws Exception {
        ThreadController tc;
        WayLinker master = new WayLinker();
        WayLinker slave = new WayLinker();
        slave.isSlave = true;
        master.isSlave = false;
        slave.tc = tc = new ThreadController();
        master.tc = tc;
        master._process(nodeTilesIn, wayTilesIn, borderFileIn, restrictionsFileIn, lookupFile, profileFile, dataTilesOut, dataTilesSuffix);
        slave._process(nodeTilesIn, wayTilesIn, borderFileIn, restrictionsFileIn, lookupFile, profileFile, dataTilesOut, dataTilesSuffix);
        Thread m = new Thread(master);
        Thread s = new Thread(slave);
        m.start();
        s.start();
        m.join();
        s.join();
    }

    private void _process(File nodeTilesIn, File wayTilesIn, File borderFileIn, File restrictionsFileIn, File lookupFile, File profileFile, File dataTilesOut, String dataTilesSuffix) throws Exception {
        this.nodeTilesIn = nodeTilesIn;
        this.wayTilesIn = wayTilesIn;
        this.trafficTilesIn = new File("../traffic");
        this.dataTilesOut = dataTilesOut;
        this.borderFileIn = borderFileIn;
        this.restrictionsFileIn = restrictionsFileIn;
        this.dataTilesSuffix = dataTilesSuffix;
        BExpressionMetaData meta = new BExpressionMetaData();
        this.expctxWay = new BExpressionContextWay(meta);
        meta.readMetaData(lookupFile);
        this.lookupVersion = meta.lookupVersion;
        this.lookupMinorVersion = meta.lookupMinorVersion;
        this.expctxWay.parseFile(profileFile, "global");
        this.creationTimeStamp = System.currentTimeMillis();
        this.abUnifier = new ByteArrayUnifier(16384, false);
        this.skipEncodingCheck = Boolean.getBoolean("skipEncodingCheck");
    }

    @Override
    public void run() {
        try {
            new WayIterator(this, true, !this.isSlave).processDir(this.wayTilesIn, ".wt5");
        }
        catch (Exception e) {
            System.out.println("******* thread (slave=" + this.isSlave + ") got Exception: " + e);
            throw new RuntimeException(e);
        }
        finally {
            if (!this.isSlave) {
                this.tc.setCurrentMasterSize(0L);
            }
        }
    }

    @Override
    public boolean wayFileStart(File wayfile) throws Exception {
        long filesize = wayfile.length();
        System.out.println("**** wayFileStart() for isSlave=" + this.isSlave + " size=" + filesize);
        if (this.isSlave ? !this.tc.setCurrentSlaveSize(filesize) : !this.tc.setCurrentMasterSize(filesize)) {
            return false;
        }
        File trafficFile = this.fileFromTemplate(wayfile, this.trafficTilesIn, "trf");
        File nodeFile = this.fileFromTemplate(wayfile, this.nodeTilesIn, "u5d");
        if (nodeFile.exists()) {
            this.reset();
            this.readingBorder = true;
            new NodeIterator(this, false).processFile(this.borderFileIn);
            this.borderSet = new FrozenLongSet(this.borderSet);
            this.readingBorder = false;
            new NodeIterator(this, true).processFile(nodeFile);
            FrozenLongMap<OsmNodeP> nodesMapFrozen = new FrozenLongMap<OsmNodeP>(this.nodesMap);
            this.nodesMap = nodesMapFrozen;
            File restrictionFile = this.fileFromTemplate(wayfile, new File(this.nodeTilesIn.getParentFile(), "restrictions55"), "rt5");
            if (restrictionFile.exists()) {
                DataInputStream di = new DataInputStream(new BufferedInputStream(new FileInputStream(restrictionFile)));
                int ntr = 0;
                try {
                    while (true) {
                        RestrictionData res = new RestrictionData(di);
                        OsmNodeP n = this.nodesMap.get(res.viaNid);
                        if (n == null) continue;
                        if (!(n instanceof OsmNodePT)) {
                            n = new OsmNodePT(n);
                            this.nodesMap.put(res.viaNid, n);
                        }
                        OsmNodePT nt = (OsmNodePT)n;
                        res.next = nt.firstRestriction;
                        nt.firstRestriction = res;
                        ++ntr;
                    }
                }
                catch (EOFException eof) {
                    di.close();
                    System.out.println("read " + ntr + " turn-restrictions");
                }
            }
            this.nodesList = nodesMapFrozen.getValueList();
        }
        if (trafficFile.exists()) {
            this.trafficMap = new OsmTrafficMap(this.expctxWay);
            this.trafficMap.loadAll(trafficFile, this.minLon, this.minLat, this.minLon + 5000000, this.minLat + 5000000, false);
        }
        return true;
    }

    @Override
    public void nextNode(NodeData data) throws Exception {
        OsmNodeP n = data.description == null ? new OsmNodeP() : new OsmNodePT(data.description);
        n.ilon = data.ilon;
        n.ilat = data.ilat;
        n.selev = data.selev;
        if (this.readingBorder || !this.borderSet.contains(data.nid)) {
            this.nodesMap.fastPut(data.nid, n);
        }
        if (this.readingBorder) {
            n.bits = (byte)(n.bits | 4);
            this.borderSet.fastAdd(data.nid);
            return;
        }
        int min_lon = n.ilon / 5000000 * 5000000;
        int min_lat = n.ilat / 5000000 * 5000000;
        if (this.minLon == -1) {
            this.minLon = min_lon;
        }
        if (this.minLat == -1) {
            this.minLat = min_lat;
        }
        if (this.minLat != min_lat || this.minLon != min_lon) {
            throw new IllegalArgumentException("inconsistent node: " + n.ilon + " " + n.ilat);
        }
    }

    private void checkRestriction(OsmNodeP n1, OsmNodeP n2, WayData w) {
        this.checkRestriction(n1, n2, w.wid, true);
        this.checkRestriction(n2, n1, w.wid, false);
    }

    private void checkRestriction(OsmNodeP n1, OsmNodeP n2, long wid, boolean checkFrom) {
        RestrictionData r = n2.getFirstRestriction();
        while (r != null) {
            if (r.fromWid == wid && (r.fromLon == 0 || checkFrom)) {
                r.fromLon = n1.ilon;
                r.fromLat = n1.ilat;
                n1.bits = (byte)(n1.bits | 0x40);
            }
            if (!(r.toWid != wid || r.toLon != 0 && checkFrom)) {
                r.toLon = n1.ilon;
                r.toLat = n1.ilat;
                n1.bits = (byte)(n1.bits | 0x40);
            }
            r = r.next;
        }
    }

    @Override
    public void nextWay(WayData way) throws Exception {
        byte[] description = this.abUnifier.unify(way.description);
        this.expctxWay.evaluate(false, description);
        boolean ok = (double)this.expctxWay.getCostfactor() < 10000.0;
        this.expctxWay.evaluate(true, description);
        if (!(ok |= (double)this.expctxWay.getCostfactor() < 10000.0)) {
            return;
        }
        byte wayBits = 0;
        this.expctxWay.decode(description);
        if (!this.expctxWay.getBooleanLookupValue("bridge")) {
            wayBits = (byte)(wayBits | 1);
        }
        if (!this.expctxWay.getBooleanLookupValue("tunnel")) {
            wayBits = (byte)(wayBits | 2);
        }
        OsmNodeP n1 = null;
        OsmNodeP n2 = null;
        for (int i = 0; i < way.nodes.size(); ++i) {
            long nid = way.nodes.get(i);
            n1 = n2;
            n2 = this.nodesMap.get(nid);
            if (n1 != null && n2 != null && n1 != n2) {
                this.checkRestriction(n1, n2, way);
                OsmLinkP link = n2.createLink(n1);
                link.descriptionBitmap = description;
                if (n1.ilon / this.cellsize != n2.ilon / this.cellsize || n1.ilat / this.cellsize != n2.ilat / this.cellsize) {
                    n2.incWayCount();
                }
            }
            if (n2 == null) continue;
            n2.bits = (byte)(n2.bits | wayBits);
            n2.incWayCount();
        }
    }

    @Override
    public void wayFileEnd(File wayfile) throws Exception {
        int ncaches = this.divisor * this.divisor;
        int indexsize = ncaches * 4;
        this.nodesMap = null;
        this.borderSet = null;
        byte[] abBuf1 = new byte[0xA00000];
        byte[] abBuf2 = new byte[0xA00000];
        int maxLon = this.minLon + 5000000;
        int maxLat = this.minLat + 5000000;
        for (OsmNodeP n : this.nodesList) {
            if (n == null || n.getFirstLink() == null || n.isTransferNode()) continue;
            n.checkDuplicateTargets();
        }
        int nLonSegs = (maxLon - this.minLon) / 1000000;
        int nLatSegs = (maxLat - this.minLat) / 1000000;
        LazyArrayOfLists seglists = new LazyArrayOfLists(nLonSegs * nLatSegs);
        for (OsmNodeP n : this.nodesList) {
            if (n == null || n.getFirstLink() == null || n.isTransferNode() || n.ilon < this.minLon || n.ilon >= maxLon || n.ilat < this.minLat || n.ilat >= maxLat) continue;
            int lonIdx = (n.ilon - this.minLon) / 1000000;
            int latIdx = (n.ilat - this.minLat) / 1000000;
            int tileIndex = lonIdx * nLatSegs + latIdx;
            seglists.getList(tileIndex).add(n);
        }
        this.nodesList = null;
        seglists.trimAll();
        File outfile = this.fileFromTemplate(wayfile, this.dataTilesOut, this.dataTilesSuffix);
        DiffCoderDataOutputStream os = this.createOutStream(outfile);
        long[] fileIndex = new long[25];
        int[] fileHeaderCrcs = new int[25];
        for (int i55 = 0; i55 < 25; ++i55) {
            os.writeLong(0L);
        }
        long filepos = 200L;
        for (int lonIdx = 0; lonIdx < nLonSegs; ++lonIdx) {
            for (int latIdx = 0; latIdx < nLatSegs; ++latIdx) {
                int tileIndex = lonIdx * nLatSegs + latIdx;
                if (seglists.getSize(tileIndex) > 0) {
                    List nlist = seglists.getList(tileIndex);
                    LazyArrayOfLists subs = new LazyArrayOfLists(ncaches);
                    byte[][] subByteArrays = new byte[ncaches][];
                    for (int ni = 0; ni < nlist.size(); ++ni) {
                        OsmNodeP n = (OsmNodeP)nlist.get(ni);
                        int subLonIdx = (n.ilon - this.minLon) / this.cellsize - this.divisor * lonIdx;
                        int subLatIdx = (n.ilat - this.minLat) / this.cellsize - this.divisor * latIdx;
                        int si = subLatIdx * this.divisor + subLonIdx;
                        subs.getList(si).add(n);
                    }
                    subs.trimAll();
                    int[] posIdx = new int[ncaches];
                    int pos = indexsize;
                    for (int si = 0; si < ncaches; ++si) {
                        List subList = subs.getList(si);
                        int size = subList.size();
                        if (size > 0) {
                            OsmNodeP n0 = (OsmNodeP)subList.get(0);
                            int lonIdxDiv = n0.ilon / this.cellsize;
                            int latIdxDiv = n0.ilat / this.cellsize;
                            MicroCache2 mc = new MicroCache2(size, abBuf2, lonIdxDiv, latIdxDiv, this.divisor);
                            TreeMap<Integer, OsmNodeP> sortedList = new TreeMap<Integer, OsmNodeP>();
                            for (OsmNodeP n : subList) {
                                long longId = n.getIdFromPos();
                                int shrinkid = ((MicroCache)mc).shrinkId(longId);
                                if (((MicroCache)mc).expandId(shrinkid) != longId) {
                                    throw new IllegalArgumentException("inconstistent shrinking: " + longId);
                                }
                                sortedList.put(shrinkid, n);
                            }
                            for (OsmNodeP n : sortedList.values()) {
                                n.writeNodeData(mc, this.trafficMap);
                            }
                            if (mc.getSize() > 0) {
                                byte[] subBytes;
                                while (true) {
                                    MicroCache2 mc2;
                                    String diffMessage;
                                    int len = ((MicroCache)mc).encodeMicroCache(abBuf1);
                                    subBytes = new byte[len];
                                    System.arraycopy(abBuf1, 0, subBytes, 0, len);
                                    if (this.skipEncodingCheck || (diffMessage = mc.compareWith(mc2 = new MicroCache2(new StatCoderContext(subBytes), new DataBuffers(null), lonIdxDiv, latIdxDiv, this.divisor, null, null))) == null) break;
                                    if (MicroCache.debug) {
                                        throw new RuntimeException("encoding crosscheck failed: " + diffMessage);
                                    }
                                    MicroCache.debug = true;
                                }
                                pos += subBytes.length + 4;
                                subByteArrays[si] = subBytes;
                            }
                        }
                        posIdx[si] = pos;
                    }
                    byte[] abSubIndex = this.compileSubFileIndex(posIdx);
                    fileHeaderCrcs[tileIndex] = Crc32.crc(abSubIndex, 0, abSubIndex.length);
                    os.write(abSubIndex, 0, abSubIndex.length);
                    for (int si = 0; si < ncaches; ++si) {
                        byte[] ab = subByteArrays[si];
                        if (ab == null) continue;
                        os.write(ab);
                        os.writeInt(Crc32.crc(ab, 0, ab.length) ^ this.microCacheEncoding);
                    }
                    filepos += (long)pos;
                }
                fileIndex[tileIndex] = filepos;
            }
        }
        byte[] abFileIndex = this.compileFileIndex(fileIndex, this.lookupVersion, this.lookupMinorVersion);
        os.writeLong(this.creationTimeStamp);
        os.writeInt(Crc32.crc(abFileIndex, 0, abFileIndex.length) ^ this.microCacheEncoding);
        for (int i55 = 0; i55 < 25; ++i55) {
            os.writeInt(fileHeaderCrcs[i55]);
        }
        os.close();
        RandomAccessFile ra = new RandomAccessFile(outfile, "rw");
        ra.write(abFileIndex, 0, abFileIndex.length);
        ra.close();
        if (this.trafficMap != null) {
            this.trafficMap.finish();
            this.trafficMap = null;
        }
        System.out.println("**** codec stats: *******\n" + StatCoderContext.getBitReport());
    }

    private byte[] compileFileIndex(long[] fileIndex, short lookupVersion, short lookupMinorVersion) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int i55 = 0; i55 < 25; ++i55) {
            long versionPrefix = i55 == 1 ? (long)lookupMinorVersion : (long)lookupVersion;
            dos.writeLong(fileIndex[i55] | (versionPrefix <<= 48));
        }
        dos.close();
        return bos.toByteArray();
    }

    private byte[] compileSubFileIndex(int[] posIdx) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        for (int si = 0; si < posIdx.length; ++si) {
            dos.writeInt(posIdx[si]);
        }
        dos.close();
        return bos.toByteArray();
    }

    public static final class ThreadController {
        long maxFileSize = 0L;
        long currentSlaveSize;
        long currentMasterSize = 2000000000L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized boolean setCurrentMasterSize(long size) {
            try {
                if (size <= this.currentSlaveSize) {
                    this.maxFileSize = Long.MAX_VALUE;
                    boolean bl = false;
                    return bl;
                }
                this.currentMasterSize = size;
                if (this.maxFileSize == 0L) {
                    this.maxFileSize = size;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.notify();
            }
        }

        synchronized boolean setCurrentSlaveSize(long size) throws Exception {
            if (size >= this.currentMasterSize) {
                return false;
            }
            while (size + this.currentMasterSize + 50000000L > this.maxFileSize) {
                System.out.println("****** slave thread waiting for permission to process file of size " + size + " currentMaster=" + this.currentMasterSize + " maxFileSize=" + this.maxFileSize);
                this.wait(10000L);
            }
            this.currentSlaveSize = size;
            return true;
        }
    }
}

