/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.RestrictionData;
import btools.mapcreator.WayCutter;
import java.io.File;

public class RestrictionCutter
extends MapCreatorBase {
    private WayCutter wayCutter;

    public void init(File outTileDir, WayCutter wayCutter) throws Exception {
        outTileDir.mkdir();
        this.outTileDir = outTileDir;
        this.wayCutter = wayCutter;
    }

    public void finish() throws Exception {
        this.closeTileOutStreams();
    }

    public void nextRestriction(RestrictionData data) throws Exception {
        int tileIndex = this.wayCutter.getTileIndexForNid(data.viaNid);
        if (tileIndex != -1) {
            data.writeTo(this.getOutStreamForTile(tileIndex));
        }
    }

    @Override
    protected String getNameForTile(int tileIndex) {
        String name = this.wayCutter.getNameForTile(tileIndex);
        return name.substring(0, name.length() - 3) + "rtl";
    }
}

