/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.RasterCoder;
import btools.mapcreator.SrtmData;
import btools.mapcreator.SrtmRaster;
import btools.util.CompactLongSet;
import btools.util.DiffCoderDataOutputStream;
import btools.util.FrozenLongSet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

public class PosUnifier
extends MapCreatorBase {
    private DiffCoderDataOutputStream nodesOutStream;
    private DiffCoderDataOutputStream borderNodesOut;
    private File nodeTilesOut;
    private CompactLongSet[] positionSets;
    private HashMap<String, SrtmRaster> srtmmap;
    private int lastSrtmLonIdx;
    private int lastSrtmLatIdx;
    private SrtmRaster lastSrtmRaster;
    private String srtmdir;
    private CompactLongSet borderNids;

    public static void main(String[] args) throws Exception {
        System.out.println("*** PosUnifier: Unify position values and enhance elevation");
        if (args.length != 5) {
            System.out.println("usage: java PosUnifier <node-tiles-in> <node-tiles-out> <bordernids-in> <bordernodes-out> <srtm-data-dir>");
            return;
        }
        new PosUnifier().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), args[4]);
    }

    public void process(File nodeTilesIn, File nodeTilesOut, File bordernidsinfile, File bordernodesoutfile, String srtmdir) throws Exception {
        this.nodeTilesOut = nodeTilesOut;
        this.srtmdir = srtmdir;
        DataInputStream dis = this.createInStream(bordernidsinfile);
        this.borderNids = new CompactLongSet();
        try {
            while (true) {
                long nid;
                if (this.borderNids.contains(nid = PosUnifier.readId(dis))) {
                    continue;
                }
                this.borderNids.fastAdd(nid);
            }
        }
        catch (EOFException eof) {
            dis.close();
            this.borderNids = new FrozenLongSet(this.borderNids);
            this.borderNodesOut = this.createOutStream(bordernodesoutfile);
            new NodeIterator(this, true).processDir(nodeTilesIn, ".n5d");
            this.borderNodesOut.close();
            return;
        }
    }

    @Override
    public void nodeFileStart(File nodefile) throws Exception {
        this.resetSrtm();
        this.nodesOutStream = this.createOutStream(this.fileFromTemplate(nodefile, this.nodeTilesOut, "u5d"));
        this.positionSets = new CompactLongSet[2500];
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        SrtmRaster srtm = this.srtmForNode(n.ilon, n.ilat);
        n.selev = (short)(srtm == null ? Short.MIN_VALUE : (int)srtm.getElevation(n.ilon, n.ilat));
        this.findUniquePos(n);
        n.writeTo(this.nodesOutStream);
        if (this.borderNids.contains(n.nid)) {
            n.writeTo(this.borderNodesOut);
        }
    }

    @Override
    public void nodeFileEnd(File nodeFile) throws Exception {
        this.nodesOutStream.close();
    }

    private boolean checkAdd(int lon, int lat) {
        int slot = lon % 5000000 / 100000 * 50 + lat % 5000000 / 100000;
        long id = (long)lon << 32 | (long)lat;
        CompactLongSet set = this.positionSets[slot];
        if (set == null) {
            this.positionSets[slot] = set = new CompactLongSet();
        }
        if (!set.contains(id)) {
            set.fastAdd(id);
            return true;
        }
        return false;
    }

    private void findUniquePos(NodeData n) {
        if (!this.checkAdd(n.ilon, n.ilat)) {
            this._findUniquePos(n);
        }
    }

    private void _findUniquePos(NodeData n) {
        int lonmod = n.ilon % 1000000;
        int londelta = lonmod < 500000 ? 1 : -1;
        int latmod = n.ilat % 1000000;
        int latdelta = latmod < 500000 ? 1 : -1;
        for (int latsteps = 0; latsteps < 100; ++latsteps) {
            for (int lonsteps = 0; lonsteps <= latsteps; ++lonsteps) {
                int lon = n.ilon + lonsteps * londelta;
                int lat = n.ilat + latsteps * latdelta;
                if (!this.checkAdd(lon, lat)) continue;
                n.ilon = lon;
                n.ilat = lat;
                return;
            }
        }
        System.out.println("*** WARNING: cannot unify position for: " + n.ilon + " " + n.ilat);
    }

    private SrtmRaster srtmForNode(int ilon, int ilat) throws Exception {
        int srtmLonIdx = (ilon + 5000000) / 5000000;
        int srtmLatIdx = (654999999 - ilat) / 5000000 - 100;
        if (srtmLonIdx == this.lastSrtmLonIdx && srtmLatIdx == this.lastSrtmLatIdx) {
            return this.lastSrtmRaster;
        }
        this.lastSrtmLonIdx = srtmLonIdx;
        this.lastSrtmLatIdx = srtmLatIdx;
        String slonidx = "0" + srtmLonIdx;
        String slatidx = "0" + srtmLatIdx;
        String filename = "srtm_" + slonidx.substring(slonidx.length() - 2) + "_" + slatidx.substring(slatidx.length() - 2);
        this.lastSrtmRaster = this.srtmmap.get(filename);
        if (this.lastSrtmRaster == null && !this.srtmmap.containsKey(filename)) {
            File f = new File(new File(this.srtmdir), filename + ".bef");
            System.out.println("checking: " + f + " ilon=" + ilon + " ilat=" + ilat);
            if (f.exists()) {
                System.out.println("*** reading: " + f);
                try {
                    BufferedInputStream isc = new BufferedInputStream(new FileInputStream(f));
                    this.lastSrtmRaster = new RasterCoder().decodeRaster(isc);
                    ((InputStream)isc).close();
                }
                catch (Exception e) {
                    System.out.println("**** ERROR reading " + f + " ****");
                }
                this.srtmmap.put(filename, this.lastSrtmRaster);
                return this.lastSrtmRaster;
            }
            f = new File(new File(this.srtmdir), filename + ".zip");
            System.out.println("reading: " + f + " ilon=" + ilon + " ilat=" + ilat);
            if (f.exists()) {
                try {
                    this.lastSrtmRaster = new SrtmData(f).getRaster();
                }
                catch (Exception e) {
                    System.out.println("**** ERROR reading " + f + " ****");
                }
            }
            this.srtmmap.put(filename, this.lastSrtmRaster);
        }
        return this.lastSrtmRaster;
    }

    private void resetSrtm() {
        this.srtmmap = new HashMap();
        this.lastSrtmLonIdx = -1;
        this.lastSrtmLatIdx = -1;
        this.lastSrtmRaster = null;
    }
}

