/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.OsmNodeP;
import btools.util.CheapRuler;
import java.util.ArrayList;

public class DPFilter {
    private static double dp_sql_threshold = 0.16000000000000003;

    public static void doDPFilter(ArrayList<OsmNodeP> nodes) {
        int first;
        int last = nodes.size() - 1;
        for (first = 0; first < last && (nodes.get((int)(first + 1)).bits & 0x40) != 0; ++first) {
        }
        while (first < last && (nodes.get((int)(last - 1)).bits & 0x40) != 0) {
            --last;
        }
        if (last - first > 1) {
            DPFilter.doDPFilter(nodes, first, last);
        }
    }

    public static void doDPFilter(ArrayList<OsmNodeP> nodes, int first, int last) {
        double maxSqDist = -1.0;
        int index = -1;
        OsmNodeP p1 = nodes.get(first);
        OsmNodeP p2 = nodes.get(last);
        double[] lonlat2m = CheapRuler.getLonLatToMeterScales(p1.ilat + p2.ilat >> 1);
        double dlon2m = lonlat2m[0];
        double dlat2m = lonlat2m[1];
        double dx = (double)(p2.ilon - p1.ilon) * dlon2m;
        double dy = (double)(p2.ilat - p1.ilat) * dlat2m;
        double d2 = dx * dx + dy * dy;
        for (int i = first + 1; i < last; ++i) {
            double dy2;
            double dx2;
            double sqDist;
            OsmNodeP p = nodes.get(i);
            double t = 0.0;
            if (d2 != 0.0) {
                t = ((double)(p.ilon - p1.ilon) * dlon2m * dx + (double)(p.ilat - p1.ilat) * dlat2m * dy) / d2;
                double d = t > 1.0 ? 1.0 : (t = t < 0.0 ? 0.0 : t);
            }
            if (!((sqDist = (dx2 = ((double)p.ilon - ((double)p1.ilon + t * (double)(p2.ilon - p1.ilon))) * dlon2m) * dx2 + (dy2 = ((double)p.ilat - ((double)p1.ilat + t * (double)(p2.ilat - p1.ilat))) * dlat2m) * dy2) > maxSqDist)) continue;
            index = i;
            maxSqDist = sqDist;
        }
        if (index >= 0) {
            if (index - first > 1) {
                DPFilter.doDPFilter(nodes, first, index);
            }
            if (maxSqDist >= dp_sql_threshold) {
                nodes.get((int)index).bits = (byte)(nodes.get((int)index).bits | 0x40);
            }
            if (last - index > 1) {
                DPFilter.doDPFilter(nodes, index, last);
            }
        }
    }
}

