/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.DataBuffers;
import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.codec.StatCoderContext;
import btools.util.Crc32;
import btools.util.ProgressListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;

public final class Rd5DiffTool
implements ProgressListener {
    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            Rd5DiffTool.reEncode(new File(args[0]), new File(args[1]));
            return;
        }
        if (args[1].endsWith(".rd5diff")) {
            if (args[0].endsWith(".rd5diff")) {
                Rd5DiffTool.addDeltas(new File(args[0]), new File(args[1]), new File(args[2]));
            } else {
                Rd5DiffTool.recoverFromDelta(new File(args[0]), new File(args[1]), new File(args[2]), new Rd5DiffTool());
            }
        } else {
            Rd5DiffTool.diff2files(new File(args[0]), new File(args[1]), new File(args[2]));
        }
    }

    @Override
    public void updateProgress(String progress) {
        System.out.println(progress);
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    private static long[] readFileIndex(DataInputStream dis, DataOutputStream dos) throws Exception {
        long[] fileIndex = new long[25];
        for (int i = 0; i < 25; ++i) {
            long lv = dis.readLong();
            fileIndex[i] = lv & 0xFFFFFFFFFFFFL;
            if (dos == null) continue;
            dos.writeLong(lv);
        }
        return fileIndex;
    }

    private static long getTileStart(long[] index, int tileIndex) {
        return tileIndex > 0 ? index[tileIndex - 1] : 200L;
    }

    private static long getTileEnd(long[] index, int tileIndex) {
        return index[tileIndex];
    }

    private static int[] readPosIndex(DataInputStream dis, DataOutputStream dos) throws Exception {
        int[] posIndex = new int[1024];
        for (int i = 0; i < 1024; ++i) {
            int iv;
            posIndex[i] = iv = dis.readInt();
            if (dos == null) continue;
            dos.writeInt(iv);
        }
        return posIndex;
    }

    private static int getPosIdx(int[] posIdx, int idx) {
        return idx == -1 ? 4096 : posIdx[idx];
    }

    private static byte[] createMicroCache(int[] posIdx, int tileIdx, DataInputStream dis, boolean deltaMode) throws Exception {
        if (posIdx == null) {
            return null;
        }
        int size = Rd5DiffTool.getPosIdx(posIdx, tileIdx) - Rd5DiffTool.getPosIdx(posIdx, tileIdx - 1);
        if (size == 0) {
            return null;
        }
        if (deltaMode) {
            size = dis.readInt();
        }
        byte[] ab = new byte[size];
        dis.readFully(ab);
        return ab;
    }

    private static MicroCache createMicroCache(byte[] ab, DataBuffers dataBuffers) throws Exception {
        if (ab == null || ab.length == 0) {
            return MicroCache.emptyCache();
        }
        StatCoderContext bc = new StatCoderContext(ab);
        return new MicroCache2(bc, dataBuffers, 0, 0, 32, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void diff2files(File f1, File f2, File outFile) throws Exception {
        byte[] abBuf1 = new byte[0xA00000];
        byte[] abBuf2 = new byte[0xA00000];
        int nodesDiff = 0;
        int diffedTiles = 0;
        long bytesDiff = 0L;
        DataInputStream dis1 = new DataInputStream(new BufferedInputStream(new FileInputStream(f1)));
        DataInputStream dis2 = new DataInputStream(new BufferedInputStream(new FileInputStream(f2)));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        long[] fileIndex1 = Rd5DiffTool.readFileIndex(dis1, null);
        long[] fileIndex2 = Rd5DiffTool.readFileIndex(dis2, dos);
        long t0 = System.currentTimeMillis();
        try {
            int len;
            DataBuffers dataBuffers = new DataBuffers();
            for (int subFileIdx = 0; subFileIdx < 25; ++subFileIdx) {
                boolean hasData1 = Rd5DiffTool.getTileStart(fileIndex1, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex1, subFileIdx);
                boolean hasData2 = Rd5DiffTool.getTileStart(fileIndex2, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex2, subFileIdx);
                int[] posIdx1 = hasData1 ? Rd5DiffTool.readPosIndex(dis1, null) : null;
                int[] posIdx2 = hasData2 ? Rd5DiffTool.readPosIndex(dis2, dos) : null;
                for (int tileIdx = 0; tileIdx < 1024; ++tileIdx) {
                    MicroCache mc;
                    byte[] ab1 = Rd5DiffTool.createMicroCache(posIdx1, tileIdx, dis1, false);
                    byte[] ab2 = Rd5DiffTool.createMicroCache(posIdx2, tileIdx, dis2, false);
                    if (ab2 == null) continue;
                    if (Arrays.equals(ab1, ab2)) {
                        mc = MicroCache.emptyCache();
                    } else {
                        MicroCache mc1 = Rd5DiffTool.createMicroCache(ab1, dataBuffers);
                        MicroCache mc2 = Rd5DiffTool.createMicroCache(ab2, dataBuffers);
                        mc = new MicroCache2(mc1.getSize() + mc2.getSize(), abBuf2, 0, 0, 32);
                        mc.calcDelta(mc1, mc2);
                    }
                    if (mc.getSize() == 0) {
                        dos.writeInt(0);
                        continue;
                    }
                    int len2 = mc.encodeMicroCache(abBuf1);
                    dos.writeInt(len2);
                    dos.write(abBuf1, 0, len2);
                    bytesDiff += (long)len2;
                    nodesDiff += mc.getSize();
                    ++diffedTiles;
                }
            }
            while ((len = dis2.read(abBuf1)) >= 0) {
                dos.write(abBuf1, 0, len);
            }
            long t1 = System.currentTimeMillis();
            System.out.println("nodesDiff=" + nodesDiff + " bytesDiff=" + bytesDiff + " diffedTiles=" + diffedTiles + " took " + (t1 - t0) + "ms");
        }
        finally {
            if (dis1 != null) {
                try {
                    dis1.close();
                }
                catch (Exception ee) {}
            }
            if (dis2 != null) {
                try {
                    dis2.close();
                }
                catch (Exception ee) {}
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverFromDelta(File f1, File f2, File outFile, ProgressListener progress) throws Exception {
        if (f2.length() == 0L) {
            Rd5DiffTool.copyFile(f1, outFile, progress);
            return;
        }
        byte[] abBuf1 = new byte[0xA00000];
        byte[] abBuf2 = new byte[0xA00000];
        boolean canceled = false;
        long t0 = System.currentTimeMillis();
        DataInputStream dis1 = new DataInputStream(new BufferedInputStream(new FileInputStream(f1)));
        DataInputStream dis2 = new DataInputStream(new BufferedInputStream(new FileInputStream(f2)));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        long[] fileIndex1 = Rd5DiffTool.readFileIndex(dis1, null);
        long[] fileIndex2 = Rd5DiffTool.readFileIndex(dis2, dos);
        int lastPct = -1;
        try {
            int len;
            DataBuffers dataBuffers = new DataBuffers();
            for (int subFileIdx = 0; subFileIdx < 25; ++subFileIdx) {
                boolean hasData1 = Rd5DiffTool.getTileStart(fileIndex1, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex1, subFileIdx);
                boolean hasData2 = Rd5DiffTool.getTileStart(fileIndex2, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex2, subFileIdx);
                int[] posIdx1 = hasData1 ? Rd5DiffTool.readPosIndex(dis1, null) : null;
                int[] posIdx2 = hasData2 ? Rd5DiffTool.readPosIndex(dis2, dos) : null;
                for (int tileIdx = 0; tileIdx < 1024; ++tileIdx) {
                    if (progress.isCanceled()) {
                        canceled = true;
                        return;
                    }
                    double bytesProcessed = Rd5DiffTool.getTileStart(fileIndex1, subFileIdx) + (long)(posIdx1 == null ? 0 : Rd5DiffTool.getPosIdx(posIdx1, tileIdx - 1));
                    int pct = (int)(100.0 * bytesProcessed / (double)Rd5DiffTool.getTileEnd(fileIndex1, 24) + 0.5);
                    if (pct != lastPct) {
                        progress.updateProgress("Applying delta: " + pct + "%");
                        lastPct = pct;
                    }
                    byte[] ab1 = Rd5DiffTool.createMicroCache(posIdx1, tileIdx, dis1, false);
                    byte[] ab2 = Rd5DiffTool.createMicroCache(posIdx2, tileIdx, dis2, true);
                    if (ab2 == null) continue;
                    if (ab2.length == 0) {
                        if (ab1 == null) continue;
                        dos.write(ab1);
                        continue;
                    }
                    MicroCache mc1 = Rd5DiffTool.createMicroCache(ab1, dataBuffers);
                    MicroCache mc2 = Rd5DiffTool.createMicroCache(ab2, dataBuffers);
                    MicroCache2 mc = new MicroCache2(mc1.getSize() + mc2.getSize(), abBuf2, 0, 0, 32);
                    mc.addDelta(mc1, mc2, false);
                    int len2 = ((MicroCache)mc).encodeMicroCache(abBuf1);
                    dos.write(abBuf1, 0, len2);
                    dos.writeInt(Crc32.crc(abBuf1, 0, len2) ^ 2);
                }
            }
            while ((len = dis2.read(abBuf1)) >= 0) {
                dos.write(abBuf1, 0, len);
            }
            long t1 = System.currentTimeMillis();
            System.out.println("recovering from diffs took " + (t1 - t0) + "ms");
        }
        finally {
            if (dis1 != null) {
                try {
                    dis1.close();
                }
                catch (Exception ee) {}
            }
            if (dis2 != null) {
                try {
                    dis2.close();
                }
                catch (Exception ee) {}
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ee) {}
                if (canceled) {
                    outFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File f1, File outFile, ProgressListener progress) throws Exception {
        boolean canceled = false;
        DataInputStream dis1 = new DataInputStream(new BufferedInputStream(new FileInputStream(f1)));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        int lastPct = -1;
        long sizeTotal = f1.length();
        long sizeRead = 0L;
        try {
            byte[] buf = new byte[65536];
            while (true) {
                int len;
                if (progress.isCanceled()) {
                    canceled = true;
                    return;
                }
                int pct = (int)(100.0 * (double)sizeRead / (double)(sizeTotal + 1L) + 0.5);
                if (pct != lastPct) {
                    progress.updateProgress("Copying: " + pct + "%");
                    lastPct = pct;
                }
                if ((len = dis1.read(buf)) <= 0) {
                    break;
                }
                sizeRead += (long)len;
                dos.write(buf, 0, len);
            }
        }
        finally {
            if (dis1 != null) {
                try {
                    dis1.close();
                }
                catch (Exception ee) {}
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ee) {}
                if (canceled) {
                    outFile.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDeltas(File f1, File f2, File outFile) throws Exception {
        byte[] abBuf1 = new byte[0xA00000];
        byte[] abBuf2 = new byte[0xA00000];
        DataInputStream dis1 = new DataInputStream(new BufferedInputStream(new FileInputStream(f1)));
        DataInputStream dis2 = new DataInputStream(new BufferedInputStream(new FileInputStream(f2)));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        long[] fileIndex1 = Rd5DiffTool.readFileIndex(dis1, null);
        long[] fileIndex2 = Rd5DiffTool.readFileIndex(dis2, dos);
        long t0 = System.currentTimeMillis();
        try {
            int len;
            DataBuffers dataBuffers = new DataBuffers();
            for (int subFileIdx = 0; subFileIdx < 25; ++subFileIdx) {
                boolean hasData1 = Rd5DiffTool.getTileStart(fileIndex1, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex1, subFileIdx);
                boolean hasData2 = Rd5DiffTool.getTileStart(fileIndex2, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex2, subFileIdx);
                int[] posIdx1 = hasData1 ? Rd5DiffTool.readPosIndex(dis1, null) : null;
                int[] posIdx2 = hasData2 ? Rd5DiffTool.readPosIndex(dis2, dos) : null;
                for (int tileIdx = 0; tileIdx < 1024; ++tileIdx) {
                    byte[] ab1 = Rd5DiffTool.createMicroCache(posIdx1, tileIdx, dis1, true);
                    byte[] ab2 = Rd5DiffTool.createMicroCache(posIdx2, tileIdx, dis2, true);
                    if (ab2 == null) continue;
                    if (ab2.length == 0) {
                        if (ab1 == null) {
                            dos.writeInt(0);
                            continue;
                        }
                        dos.writeInt(ab1.length);
                        dos.write(ab1);
                        continue;
                    }
                    MicroCache mc1 = Rd5DiffTool.createMicroCache(ab1, dataBuffers);
                    MicroCache mc2 = Rd5DiffTool.createMicroCache(ab2, dataBuffers);
                    MicroCache2 mc = new MicroCache2(mc1.getSize() + mc2.getSize(), abBuf2, 0, 0, 32);
                    mc.addDelta(mc1, mc2, true);
                    int len2 = ((MicroCache)mc).encodeMicroCache(abBuf1);
                    dos.writeInt(len2 + 4);
                    dos.write(abBuf1, 0, len2);
                    dos.writeInt(Crc32.crc(abBuf1, 0, len2) ^ 2);
                }
            }
            while ((len = dis2.read(abBuf1)) >= 0) {
                dos.write(abBuf1, 0, len);
            }
            long t1 = System.currentTimeMillis();
            System.out.println("adding diffs took " + (t1 - t0) + "ms");
        }
        finally {
            if (dis1 != null) {
                try {
                    dis1.close();
                }
                catch (Exception ee) {}
            }
            if (dis2 != null) {
                try {
                    dis2.close();
                }
                catch (Exception ee) {}
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reEncode(File f1, File outFile) throws Exception {
        byte[] abBuf1 = new byte[0xA00000];
        DataInputStream dis1 = new DataInputStream(new BufferedInputStream(new FileInputStream(f1)));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        long[] fileIndex1 = Rd5DiffTool.readFileIndex(dis1, dos);
        long t0 = System.currentTimeMillis();
        try {
            int len;
            DataBuffers dataBuffers = new DataBuffers();
            for (int subFileIdx = 0; subFileIdx < 25; ++subFileIdx) {
                boolean hasData1 = Rd5DiffTool.getTileStart(fileIndex1, subFileIdx) < Rd5DiffTool.getTileEnd(fileIndex1, subFileIdx);
                int[] posIdx1 = hasData1 ? Rd5DiffTool.readPosIndex(dis1, dos) : null;
                for (int tileIdx = 0; tileIdx < 1024; ++tileIdx) {
                    byte[] ab1 = Rd5DiffTool.createMicroCache(posIdx1, tileIdx, dis1, false);
                    if (ab1 == null) continue;
                    MicroCache mc1 = Rd5DiffTool.createMicroCache(ab1, dataBuffers);
                    int len2 = mc1.encodeMicroCache(abBuf1);
                    dos.write(abBuf1, 0, len2);
                    dos.writeInt(Crc32.crc(abBuf1, 0, len2) ^ 2);
                }
            }
            while ((len = dis1.read(abBuf1)) >= 0) {
                dos.write(abBuf1, 0, len);
            }
            long t1 = System.currentTimeMillis();
            System.out.println("re-encoding took " + (t1 - t0) + "ms");
        }
        finally {
            if (dis1 != null) {
                try {
                    dis1.close();
                }
                catch (Exception ee) {}
            }
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (Exception ee) {}
            }
        }
    }
}

