/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.Rd5DiffTool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public final class Rd5DiffManager {
    public static void main(String[] args) throws Exception {
        Rd5DiffManager.calcDiffs(new File(args[0]), new File(args[1]));
    }

    public static void calcDiffs(File oldDir, File newDir) throws Exception {
        File[] filesNew;
        File oldDiffDir = new File(oldDir, "diff");
        File newDiffDir = new File(newDir, "diff");
        for (File fn : filesNew = newDir.listFiles()) {
            File[] oldDiffs;
            String name = fn.getName();
            if (!name.endsWith(".rd5") || fn.length() < 0x100000L) continue;
            String basename = name.substring(0, name.length() - 4);
            File fo = new File(oldDir, name);
            if (!fo.isFile()) continue;
            String md5 = Rd5DiffManager.getMD5(fo);
            String md5New = Rd5DiffManager.getMD5(fn);
            System.out.println("name=" + name + " md5=" + md5);
            File specificNewDiffs = new File(newDiffDir, basename);
            specificNewDiffs.mkdirs();
            String diffFileName = md5 + ".rd5diff";
            File diffFile = new File(specificNewDiffs, diffFileName);
            String dummyDiffFileName = md5New + ".rd5diff";
            File dummyDiffFile = new File(specificNewDiffs, dummyDiffFileName);
            dummyDiffFile.createNewFile();
            Rd5DiffTool.diff2files(fo, fn, diffFile);
            File specificOldDiffs = new File(oldDiffDir, basename);
            if (!specificOldDiffs.isDirectory()) continue;
            for (File od : oldDiffs = specificOldDiffs.listFiles()) {
                File updatedDiff;
                if (!od.getName().endsWith(".rd5diff") || System.currentTimeMillis() - od.lastModified() > 777600000L || (updatedDiff = new File(specificNewDiffs, od.getName())).exists()) continue;
                Rd5DiffTool.addDeltas(od, diffFile, updatedDiff);
                updatedDiff.setLastModified(od.lastModified());
            }
        }
    }

    public static String getMD5(File f) throws Exception {
        int len;
        MessageDigest md = MessageDigest.getInstance("MD5");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        DigestInputStream dis = new DigestInputStream(bis, md);
        byte[] buf = new byte[8192];
        while ((len = dis.read(buf)) > 0) {
        }
        dis.close();
        byte[] bytes = md.digest();
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            sb.append(Rd5DiffManager.hexChar(v >>> 4)).append(Rd5DiffManager.hexChar(v & 0xF));
        }
        return sb.toString();
    }

    private static char hexChar(int v) {
        return (char)(v > 9 ? 97 + (v - 10) : 48 + v);
    }
}

