/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.codec.StatCoderContext;

public final class NoisyDiffCoder {
    private int tot;
    private int[] freqs;
    private int noisybits;
    private StatCoderContext bc;
    private int pass;

    public NoisyDiffCoder(StatCoderContext bc) {
        this.noisybits = bc.decodeVarBits();
        this.bc = bc;
    }

    public NoisyDiffCoder() {
    }

    public void encodeSignedValue(int value) {
        if (this.pass == 3) {
            this.bc.encodeNoisyDiff(value, this.noisybits);
        } else if (this.pass == 2) {
            this.count(value < 0 ? -value : value);
        }
    }

    public int decodeSignedValue() {
        return this.bc.decodeNoisyDiff(this.noisybits);
    }

    public void encodeDictionary(StatCoderContext bc) {
        if (++this.pass == 3) {
            this.noisybits = 0;
            while (this.noisybits < 14 && this.tot > 0 && this.freqs[this.noisybits] >= this.tot >> 1) {
                ++this.noisybits;
            }
            bc.encodeVarBits(this.noisybits);
        }
        this.bc = bc;
    }

    private void count(int value) {
        if (this.freqs == null) {
            this.freqs = new int[14];
        }
        int i = 0;
        for (int bm = 1; i < 14 && value >= bm; bm <<= 1) {
            int n = i++;
            this.freqs[n] = this.freqs[n] + 1;
        }
        ++this.tot;
    }
}

