/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.util.ArrayList;

public class CompactLongMap<V> {
    private long[][] al;
    private int[] pa = new int[31];
    private int size = 0;
    private int _maxKeepExponent = 14;
    protected V value_in;
    protected V value_out;
    protected static final int MAXLISTS = 31;
    private static boolean earlyDuplicateCheck;
    private Object[][] vla;

    public CompactLongMap() {
        this.al = new long[31][];
        this.al[0] = new long[1];
        this.vla = new Object[31][];
        this.vla[0] = new Object[1];
        earlyDuplicateCheck = Boolean.getBoolean("earlyDuplicateCheck");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(long id, V value) {
        try {
            this.value_in = value;
            if (this.contains(id, true)) {
                boolean bl = true;
                return bl;
            }
            this.vla[0][0] = value;
            this._add(id);
            boolean bl = false;
            return bl;
        }
        finally {
            this.value_in = null;
            this.value_out = null;
        }
    }

    public void fastPut(long id, V value) {
        if (earlyDuplicateCheck && this.contains(id)) {
            throw new IllegalArgumentException("duplicate key found in early check: " + id);
        }
        this.vla[0][0] = value;
        this._add(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long id) {
        try {
            if (this.contains(id, false)) {
                V v = this.value_out;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.value_out = null;
        }
    }

    public int size() {
        return this.size;
    }

    private boolean _add(long id) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("cannot grow beyond size Integer.MAX_VALUE");
        }
        this.al[0][0] = id;
        int bp = this.size++;
        int idx = 1;
        int n = 1;
        this.pa[0] = 1;
        this.pa[1] = 1;
        while ((bp & 1) == 1) {
            bp >>= 1;
            this.pa[idx++] = n;
            n <<= 1;
        }
        if (this.al[idx] == null) {
            this.al[idx] = new long[n];
            this.vla[idx] = new Object[n];
        }
        while (n > 0) {
            long maxId = 0L;
            int maxIdx = -1;
            for (int i = 0; i < idx; ++i) {
                int p = this.pa[i];
                if (p <= 0) continue;
                long currentId = this.al[i][p - 1];
                if (maxIdx >= 0 && currentId <= maxId) continue;
                maxIdx = i;
                maxId = currentId;
            }
            if (n < this.al[idx].length && maxId == this.al[idx][n]) {
                throw new IllegalArgumentException("duplicate key found in late check: " + maxId);
            }
            this.al[idx][--n] = maxId;
            this.vla[idx][n] = this.vla[maxIdx][this.pa[maxIdx] - 1];
            int n2 = maxIdx;
            this.pa[n2] = this.pa[n2] - 1;
        }
        while (idx-- > this._maxKeepExponent) {
            this.al[idx] = null;
            this.vla[idx] = null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long id) {
        try {
            boolean bl = this.contains(id, false);
            return bl;
        }
        finally {
            this.value_out = null;
        }
    }

    protected boolean contains(long id, boolean doPut) {
        int idx = 1;
        for (int bp = this.size; bp != 0; bp >>= 1) {
            if ((bp & 1) == 1 && this.contains(idx, id, doPut)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private boolean contains(int idx, long id, boolean doPut) {
        long[] a = this.al[idx];
        int offset = a.length;
        int n = 0;
        while ((offset >>= 1) > 0) {
            int nn = n + offset;
            if (a[nn] > id) continue;
            n = nn;
        }
        if (a[n] == id) {
            this.value_out = this.vla[idx][n];
            if (doPut) {
                this.vla[idx][n] = this.value_in;
            }
            return true;
        }
        return false;
    }

    protected void moveToFrozenArrays(long[] faid, ArrayList<V> flv) {
        for (int i = 1; i < 31; ++i) {
            this.pa[i] = 0;
        }
        for (int ti = 0; ti < this.size; ++ti) {
            int minIdx = -1;
            long minId = 0L;
            int idx = 1;
            for (int bp = this.size; bp != 0; bp >>= 1) {
                int p;
                if ((bp & 1) == 1 && (p = this.pa[idx]) < this.al[idx].length) {
                    long currentId = this.al[idx][p];
                    if (minIdx < 0 || currentId < minId) {
                        minIdx = idx;
                        minId = currentId;
                    }
                }
                ++idx;
            }
            faid[ti] = minId;
            flv.add(this.vla[minIdx][this.pa[minIdx]]);
            int n = minIdx;
            this.pa[n] = this.pa[n] + 1;
            if (ti <= 0 || faid[ti - 1] != minId) continue;
            throw new IllegalArgumentException("duplicate key found in late check: " + minId);
        }
        this.al = null;
        this.vla = null;
    }
}

