/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public final class CheapRuler {
    public static final double ILATLNG_TO_LATLNG = 1.0E-6;
    public static final int KILOMETERS_TO_METERS = 1000;
    public static final double DEG_TO_RAD = Math.PI / 180;
    private static final int SCALE_CACHE_LENGTH = 1800;
    private static final int SCALE_CACHE_INCREMENT = 100000;
    private static final double[][] SCALE_CACHE = new double[1800][];

    private static double[] calcKxKyFromILat(int ilat) {
        double lat = Math.PI / 180 * ((double)ilat * 1.0E-6 - 90.0);
        double cos = Math.cos(lat);
        double cos2 = 2.0 * cos * cos - 1.0;
        double cos3 = 2.0 * cos * cos2 - cos;
        double cos4 = 2.0 * cos * cos3 - cos2;
        double cos5 = 2.0 * cos * cos4 - cos3;
        double[] kxky = new double[]{(111.41513 * cos - 0.09455 * cos3 + 1.2E-4 * cos5) * 1.0E-6 * 1000.0, (111.13209 - 0.56605 * cos2 + 0.0012 * cos4) * 1.0E-6 * 1000.0};
        return kxky;
    }

    public static double[] getLonLatToMeterScales(int ilat) {
        return SCALE_CACHE[ilat / 100000];
    }

    public static double distance(int ilon1, int ilat1, int ilon2, int ilat2) {
        double[] kxky = CheapRuler.getLonLatToMeterScales(ilat1 + ilat2 >> 1);
        double dlon = (double)(ilon1 - ilon2) * kxky[0];
        double dlat = (double)(ilat1 - ilat2) * kxky[1];
        return Math.sqrt(dlat * dlat + dlon * dlon);
    }

    static {
        for (int i = 0; i < 1800; ++i) {
            CheapRuler.SCALE_CACHE[i] = CheapRuler.calcKxKyFromILat(i * 100000 + 50000);
        }
    }
}

