/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.server.Area;
import btools.server.NearRecentWps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SuspectManager
extends Thread {
    private static SimpleDateFormat dfTimestampZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static SuspectList allSuspects;
    private static Object allSuspectsSync;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatZ(Date date) {
        SimpleDateFormat simpleDateFormat = dfTimestampZ;
        synchronized (simpleDateFormat) {
            return dfTimestampZ.format(date);
        }
    }

    private static String formatAge(File f) {
        return SuspectManager.formatAge(System.currentTimeMillis() - f.lastModified());
    }

    private static String formatAge(long age) {
        long minutes = age / 60000L;
        if (minutes < 60L) {
            return minutes + " minutes";
        }
        long hours = minutes / 60L;
        if (hours < 24L) {
            return hours + " hours";
        }
        long days = hours / 24L;
        return days + " days";
    }

    private static String getLevelDecsription(int level) {
        switch (level) {
            case 30: {
                return "motorway";
            }
            case 28: {
                return "trunk";
            }
            case 26: {
                return "primary";
            }
            case 24: {
                return "secondary";
            }
            case 22: {
                return "tertiary";
            }
        }
        return "none";
    }

    private static void markFalsePositive(long id) throws IOException {
        new File("falsepositives/" + id).createNewFile();
        SuspectList suspects = SuspectManager.getAllSuspects(new File("worldsuspects.txt"));
        for (int isuspect = 0; isuspect < suspects.cnt; ++isuspect) {
            if (id != suspects.ids[isuspect]) continue;
            suspects.falsePositive[isuspect] = true;
        }
    }

    public static void newAndConfirmedJson(BufferedWriter bw, String filter, int level) throws IOException {
        SuspectList suspects = SuspectManager.getAllSuspects(new File("worldsuspects.txt"));
        bw.write("{\n");
        bw.write("\"type\": \"FeatureCollection\",\n");
        bw.write("\"features\": [");
        int n = 0;
        for (int isuspect = 0; isuspect < suspects.cnt; ++isuspect) {
            String status;
            long id = suspects.ids[isuspect];
            int prio = suspects.prios[isuspect];
            int nprio = (prio + 1) / 2 * 2;
            if (nprio < level || ("new".equals(filter) || "deferred".equals(filter)) && !suspects.newOrConfirmed[isuspect] || "fp".equals(filter) ^ suspects.falsePositive[isuspect]) continue;
            String dueTime = null;
            if (!"deferred".equals(filter)) {
                if (SuspectManager.isFixed(id, suspects.timestamp)) {
                    continue;
                }
            } else {
                File confirmedEntry;
                long hideTime;
                long fixedTs;
                File fixedEntry = new File("fixedsuspects/" + id);
                if (!fixedEntry.exists() || (fixedTs = fixedEntry.lastModified()) < suspects.timestamp || (hideTime = fixedTs - System.currentTimeMillis()) < 0L && (confirmedEntry = new File("confirmednegatives/" + id)).exists() && confirmedEntry.lastModified() > suspects.timestamp) continue;
                dueTime = hideTime < 0L ? "(asap)" : SuspectManager.formatAge(hideTime + 43200000L);
            }
            File confirmedEntry = new File("confirmednegatives/" + id);
            String string = status = suspects.newOrConfirmed[isuspect] ? "new" : "archived";
            if (confirmedEntry.exists()) {
                status = "confirmed " + SuspectManager.formatAge(confirmedEntry) + " ago";
            }
            if (dueTime != null) {
                status = "deferred";
            }
            if (n > 0) {
                bw.write(",");
            }
            int ilon = (int)(id >> 32);
            int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
            double dlon = (double)(ilon - 180000000) / 1000000.0;
            double dlat = (double)(ilat - 90000000) / 1000000.0;
            String slevel = SuspectManager.getLevelDecsription(nprio);
            bw.write("\n{\n");
            bw.write("  \"id\": " + n + ",\n");
            bw.write("  \"type\": \"Feature\",\n");
            bw.write("  \"properties\": {\n");
            bw.write("    \"issue_id\": \"" + id + "\",\n");
            bw.write("    \"Status\": \"" + status + "\",\n");
            if (dueTime != null) {
                bw.write("    \"DueTime\": \"" + dueTime + "\",\n");
            }
            bw.write("    \"Level\": \"" + slevel + "\"\n");
            bw.write("  },\n");
            bw.write("  \"geometry\": {\n");
            bw.write("    \"type\": \"Point\",\n");
            bw.write("    \"coordinates\": [\n");
            bw.write("      " + dlon + ",\n");
            bw.write("      " + dlat + "\n");
            bw.write("    ]\n");
            bw.write("  }\n");
            bw.write("}");
            ++n;
        }
        bw.write("\n  ]\n");
        bw.write("}\n");
        bw.flush();
    }

    public static void process(String url, BufferedWriter bw) throws IOException {
        block38: {
            String message;
            SuspectList suspects;
            Area polygon;
            String filter;
            String country;
            long id;
            block36: {
                String countryId;
                block37: {
                    File suspectFile;
                    StringTokenizer tk = new StringTokenizer(url, "/");
                    tk.nextToken();
                    tk.nextToken();
                    id = 0L;
                    country = "";
                    filter = null;
                    while (tk.hasMoreTokens()) {
                        String c = tk.nextToken();
                        if ("all".equals(c) || "new".equals(c) || "confirmed".equals(c) || "fp".equals(c) || "deferred".equals(c)) {
                            filter = c;
                            break;
                        }
                        country = country + "/" + c;
                    }
                    if (url.endsWith(".json")) {
                        StringTokenizer tk2 = new StringTokenizer(tk.nextToken(), ".");
                        int level = Integer.parseInt(tk2.nextToken());
                        SuspectManager.newAndConfirmedJson(bw, filter, level);
                        return;
                    }
                    bw.write("<html><body>\n");
                    bw.write("BRouter suspect manager. <a href=\"http://brouter.de/brouter/suspect_manager_help.html\">Help</a><br><br>\n");
                    if (filter == null) {
                        bw.write("<table>\n");
                        File countryParent = new File("worldpolys" + country);
                        File[] files = countryParent.listFiles();
                        TreeSet<String> names = new TreeSet<String>();
                        for (File f : files) {
                            String name = f.getName();
                            if (!name.endsWith(".poly")) continue;
                            names.add(name.substring(0, name.length() - 5));
                        }
                        for (String c : names) {
                            String url2 = "/brouter/suspects" + country + "/" + c;
                            String linkNew = "<td>&nbsp;<a href=\"" + url2 + "/new\">new</a>&nbsp;</td>";
                            String linkCnf = "<td>&nbsp;<a href=\"" + url2 + "/confirmed\">confirmed</a>&nbsp;</td>";
                            String linkAll = "<td>&nbsp;<a href=\"" + url2 + "/all\">all</a>&nbsp;</td>";
                            String linkSub = "";
                            if (new File(countryParent, c).exists()) {
                                linkSub = "<td>&nbsp;<a href=\"" + url2 + "\">sub-regions</a>&nbsp;</td>";
                            }
                            bw.write("<tr><td>" + c + "</td>" + linkNew + linkCnf + linkAll + linkSub + "\n");
                        }
                        bw.write("</table>\n");
                        bw.write("</body></html>\n");
                        bw.flush();
                        return;
                    }
                    polygon = null;
                    if (!"/world".equals(country)) {
                        File polyFile = new File("worldpolys" + country + ".poly");
                        if (!polyFile.exists()) {
                            bw.write("polygon file for country '" + country + "' not found\n");
                            bw.write("</body></html>\n");
                            bw.flush();
                            return;
                        }
                        polygon = new Area(polyFile);
                    }
                    if (!(suspectFile = new File("worldsuspects.txt")).exists()) {
                        bw.write("suspect file worldsuspects.txt not found\n");
                        bw.write("</body></html>\n");
                        bw.flush();
                        return;
                    }
                    suspects = SuspectManager.getAllSuspects(suspectFile);
                    boolean showWatchList = false;
                    if (tk.hasMoreTokens()) {
                        String t = tk.nextToken();
                        if ("watchlist".equals(t)) {
                            showWatchList = true;
                        } else {
                            id = Long.parseLong(t);
                        }
                    }
                    if (showWatchList) {
                        bw.write("watchlist for " + country + "\n");
                        bw.write("<br><a href=\"/brouter/suspects\">back to country list</a><br><br>\n");
                        long timeNow = System.currentTimeMillis();
                        for (int isuspect = 0; isuspect < suspects.cnt; ++isuspect) {
                            File confirmedEntry;
                            long hideTime;
                            long fixedTs;
                            File fixedEntry;
                            id = suspects.ids[isuspect];
                            if (polygon != null && !polygon.isInBoundingBox(id) || new File("falsepositives/" + id).exists() || !(fixedEntry = new File("fixedsuspects/" + id)).exists() || (fixedTs = fixedEntry.lastModified()) < suspects.timestamp || (hideTime = fixedTs - timeNow) < 0L && (confirmedEntry = new File("confirmednegatives/" + id)).exists() && confirmedEntry.lastModified() > suspects.timestamp || polygon != null && !polygon.isInArea(id)) continue;
                            String countryId2 = country + "/" + filter + "/" + id;
                            String dueTime = hideTime < 0L ? "(asap)" : SuspectManager.formatAge(hideTime + 43200000L);
                            String hint = "&nbsp;&nbsp;&nbsp;due in " + dueTime;
                            int ilon = (int)(id >> 32);
                            int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
                            double dlon = (double)(ilon - 180000000) / 1000000.0;
                            double dlat = (double)(ilat - 90000000) / 1000000.0;
                            String url2 = "/brouter/suspects" + countryId2;
                            bw.write("<a href=\"" + url2 + "\">" + dlon + "," + dlat + "</a>" + hint + "<br>\n");
                        }
                        bw.write("</body></html>\n");
                        bw.flush();
                        return;
                    }
                    message = null;
                    if (tk.hasMoreTokens()) {
                        int wps;
                        String command = tk.nextToken();
                        if ("falsepositive".equals(command)) {
                            wps = NearRecentWps.count(id);
                            if (wps < 8) {
                                message = "marking false-positive requires at least 8 recent nearby waypoints from BRouter-Web, found: " + wps;
                            } else {
                                SuspectManager.markFalsePositive(id);
                                message = "Marked issue " + id + " as false-positive";
                                id = 0L;
                            }
                        }
                        if ("confirm".equals(command)) {
                            wps = NearRecentWps.count(id);
                            if (wps < 2) {
                                message = "marking confirmed requires at least 2 recent nearby waypoints from BRouter-Web, found: " + wps;
                            } else {
                                new File("confirmednegatives/" + id).createNewFile();
                            }
                        }
                        if ("fixed".equals(command)) {
                            File fixedMarker = new File("fixedsuspects/" + id);
                            if (!fixedMarker.exists()) {
                                fixedMarker.createNewFile();
                            }
                            int hideDays = 0;
                            if (tk.hasMoreTokens()) {
                                String param = tk.nextToken();
                                hideDays = Integer.parseInt(param);
                                message = "Hide issue " + id + " for " + hideDays + " days";
                            } else {
                                message = "Marked issue " + id + " as fixed";
                            }
                            id = 0L;
                            fixedMarker.setLastModified(System.currentTimeMillis() + (long)hideDays * 86400000L);
                        }
                    }
                    if (id == 0L) break block36;
                    countryId = country + "/" + filter + "/" + id;
                    int ilon = (int)(id >> 32);
                    int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
                    double dlon = (double)(ilon - 180000000) / 1000000.0;
                    double dlat = (double)(ilat - 90000000) / 1000000.0;
                    String profile = "car-eco";
                    File configFile = new File("configs/profile.cfg");
                    if (configFile.exists()) {
                        BufferedReader br = new BufferedReader(new FileReader(configFile));
                        profile = br.readLine();
                        br.close();
                    }
                    String url1 = "http://brouter.de/brouter-web/#map=18/" + dlat + "/" + dlon + "/OpenStreetMap&lonlats=" + dlon + "," + dlat + "&profile=" + profile;
                    String url2 = "https://www.openstreetmap.org/?mlat=" + dlat + "&mlon=" + dlon + "#map=19/" + dlat + "/" + dlon + "&layers=N";
                    double slon = 0.00156;
                    double slat = 0.001;
                    String url3 = "http://127.0.0.1:8111/load_and_zoom?left=" + (dlon - slon) + "&bottom=" + (dlat - slat) + "&right=" + (dlon + slon) + "&top=" + (dlat + slat);
                    Date weekAgo = new Date(System.currentTimeMillis() - 604800000L);
                    String url4a = "https://overpass-turbo.eu/?Q=[date:&quot;" + SuspectManager.formatZ(weekAgo) + "Z&quot;];way[highway]({{bbox}});out meta geom;&C=" + dlat + ";" + dlon + ";18&R";
                    String url4b = "https://overpass-turbo.eu/?Q=(node(around%3A1%2C%7B%7Bcenter%7D%7D)-%3E.n%3Bway(bn.n)%5Bhighway%5D%3Brel(bn.n%3A%22via%22)%5Btype%3Drestriction%5D%3B)%3Bout%20meta%3B%3E%3Bout%20skel%20qt%3B&C=" + dlat + ";" + dlon + ";18&R";
                    String url5 = "https://tyrasd.github.io/latest-changes/#16/" + dlat + "/" + dlon;
                    if (message != null) {
                        bw.write("<strong>" + message + "</strong><br><br>\n");
                    }
                    bw.write("<a href=\"" + url1 + "\">Open in BRouter-Web</a><br><br>\n");
                    bw.write("<a href=\"" + url2 + "\">Open in OpenStreetmap</a><br><br>\n");
                    bw.write("<a href=\"" + url3 + "\">Open in JOSM (via remote control)</a><br><br>\n");
                    bw.write("Overpass: <a href=\"" + url4a + "\">minus one week</a> &nbsp;&nbsp; <a href=\"" + url4b + "\">node context</a><br><br>\n");
                    bw.write("<a href=\"" + url5 + "\">Open in Latest-Changes / last week</a><br><br>\n");
                    bw.write("<br>\n");
                    if (!SuspectManager.isFixed(id, suspects.timestamp)) break block37;
                    bw.write("<br><br><a href=\"/brouter/suspects/" + country + "/" + filter + "/watchlist\">back to watchlist</a><br><br>\n");
                    break block38;
                }
                bw.write("<a href=\"/brouter/suspects" + countryId + "/falsepositive\">mark false positive (=not an issue)</a><br><br>\n");
                File confirmedEntry = new File("confirmednegatives/" + id);
                if (confirmedEntry.exists()) {
                    String prefix = "<a href=\"/brouter/suspects" + countryId + "/fixed";
                    String prefix2 = " &nbsp;&nbsp;" + prefix;
                    bw.write(prefix + "\">mark as fixed</a><br><br>\n");
                    bw.write("hide for:  weeks:");
                    bw.write(prefix2 + "/7\">1w</a>");
                    bw.write(prefix2 + "/14\">2w</a>");
                    bw.write(prefix2 + "/21\">3w</a>");
                    bw.write(" &nbsp;&nbsp;&nbsp; months:");
                    bw.write(prefix2 + "/30\">1m</a>");
                    bw.write(prefix2 + "/61\">2m</a>");
                    bw.write(prefix2 + "/91\">3m</a>");
                    bw.write(prefix2 + "/122\">4m</a>");
                    bw.write(prefix2 + "/152\">5m</a>");
                    bw.write(prefix2 + "/183\">6m</a><br><br>\n");
                } else {
                    bw.write("<a href=\"/brouter/suspects" + countryId + "/confirm\">mark as a confirmed issue</a><br><br>\n");
                }
                if (polygon == null) break block38;
                bw.write("<br><br><a href=\"/brouter/suspects" + country + "/" + filter + "\">back to issue list</a><br><br>\n");
                break block38;
            }
            if (polygon == null) {
                bw.write(message + "<br>\n");
            } else {
                bw.write(filter + " suspect list for " + country + "\n");
                bw.write("<br><a href=\"/brouter/suspects" + country + "/" + filter + "/watchlist\">see watchlist</a>\n");
                bw.write("<br><a href=\"/brouter/suspects\">back to country list</a><br><br>\n");
                int maxprio = 0;
                for (int isuspect = 0; isuspect < suspects.cnt; ++isuspect) {
                    id = suspects.ids[isuspect];
                    int prio = suspects.prios[isuspect];
                    int nprio = (prio + 1) / 2 * 2;
                    if (nprio < maxprio) {
                        if (maxprio != 0) break;
                        bw.write("current level: " + SuspectManager.getLevelDecsription(maxprio) + "<br><br>\n");
                        break;
                    }
                    if (polygon != null && !polygon.isInBoundingBox(id) || new File("falsepositives/" + id).exists() || SuspectManager.isFixed(id, suspects.timestamp) || "new".equals(filter) && new File("suspectarchive/" + id).exists() || "confirmed".equals(filter) && !new File("confirmednegatives/" + id).exists() || polygon != null && !polygon.isInArea(id)) continue;
                    if (maxprio == 0) {
                        maxprio = nprio;
                        bw.write("current level: " + SuspectManager.getLevelDecsription(maxprio) + "<br><br>\n");
                    }
                    String countryId = country + "/" + filter + "/" + id;
                    File confirmedEntry = new File("confirmednegatives/" + id);
                    String hint = "";
                    if (confirmedEntry.exists()) {
                        hint = "&nbsp;&nbsp;&nbsp;confirmed " + SuspectManager.formatAge(confirmedEntry) + " ago";
                    }
                    int ilon = (int)(id >> 32);
                    int ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
                    double dlon = (double)(ilon - 180000000) / 1000000.0;
                    double dlat = (double)(ilat - 90000000) / 1000000.0;
                    String url2 = "/brouter/suspects" + countryId;
                    bw.write("<a href=\"" + url2 + "\">" + dlon + "," + dlat + "</a>" + hint + "<br>\n");
                }
            }
        }
        bw.write("</body></html>\n");
        bw.flush();
    }

    private static boolean isFixed(long id, long timestamp) {
        File fixedEntry = new File("fixedsuspects/" + id);
        return fixedEntry.exists() && fixedEntry.lastModified() > timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SuspectList getAllSuspects(File suspectFile) throws IOException {
        Object object = allSuspectsSync;
        synchronized (object) {
            String line;
            String line2;
            if (allSuspects != null && suspectFile.lastModified() == SuspectManager.allSuspects.timestamp) {
                return allSuspects;
            }
            int[] prioCount = new int[100];
            BufferedReader r = new BufferedReader(new FileReader(suspectFile));
            while ((line2 = r.readLine()) != null) {
                int nprio;
                StringTokenizer tk2 = new StringTokenizer(line2);
                tk2.nextToken();
                int prio = Integer.parseInt(tk2.nextToken());
                int n = nprio = (prio + 1) / 2 * 2;
                prioCount[n] = prioCount[n] + 1;
            }
            r.close();
            int pointer = 0;
            for (int i = 99; i >= 0; --i) {
                int cnt = prioCount[i];
                prioCount[i] = pointer;
                pointer += cnt;
            }
            allSuspects = new SuspectList(pointer, suspectFile.lastModified());
            r = new BufferedReader(new FileReader(suspectFile));
            while ((line = r.readLine()) != null) {
                int nprio;
                StringTokenizer tk2 = new StringTokenizer(line);
                long id = Long.parseLong(tk2.nextToken());
                int prio = Integer.parseInt(tk2.nextToken());
                int n = nprio = (prio + 1) / 2 * 2;
                prioCount[n] = prioCount[n] + 1;
                SuspectManager.allSuspects.ids[pointer] = id;
                SuspectManager.allSuspects.prios[pointer] = prio;
                SuspectManager.allSuspects.newOrConfirmed[pointer] = new File("confirmednegatives/" + id).exists() || !new File("suspectarchive/" + id).exists();
                SuspectManager.allSuspects.falsePositive[pointer] = new File("falsepositives/" + id).exists();
            }
            r.close();
            return allSuspects;
        }
    }

    static {
        allSuspectsSync = new Object();
    }

    private static final class SuspectList {
        int cnt;
        long[] ids;
        int[] prios;
        boolean[] newOrConfirmed;
        boolean[] falsePositive;
        long timestamp;

        SuspectList(int count, long time) {
            this.cnt = count;
            this.ids = new long[this.cnt];
            this.prios = new int[this.cnt];
            this.newOrConfirmed = new boolean[this.cnt];
            this.falsePositive = new boolean[this.cnt];
            this.timestamp = time;
        }
    }
}

