/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.router.OsmNodeNamed;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.server.NearRecentWps;
import btools.server.ServiceContext;
import btools.server.SuspectManager;
import btools.server.request.ProfileUploadHandler;
import btools.server.request.RequestHandler;
import btools.server.request.ServerHandler;
import btools.util.StackSampler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;

public class RouteServer
extends Thread {
    public static final String PROFILE_UPLOAD_URL = "/brouter/profile";
    public ServiceContext serviceContext;
    private Socket clientSocket = null;
    private RoutingEngine cr = null;
    private volatile boolean terminated;
    private static DateFormat tsFormat = new SimpleDateFormat("dd.MM.yy HH:mm", new Locale("en", "US"));

    public void stopRouter() {
        RoutingEngine e = this.cr;
        if (e != null) {
            e.terminate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formattedTimestamp() {
        DateFormat dateFormat = tsFormat;
        synchronized (dateFormat) {
            return tsFormat.format(new Date(System.currentTimeMillis()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream(), "UTF-8"));
            bw = new BufferedWriter(new OutputStreamWriter(this.clientSocket.getOutputStream(), "UTF-8"));
            String getline = null;
            String agent = null;
            String encodings = null;
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    return;
                }
                if (line.length() == 0) break;
                if (getline == null) {
                    getline = line;
                }
                if (line.startsWith("User-Agent: ")) {
                    agent = line.substring("User-Agent: ".length());
                }
                if (!line.startsWith("Accept-Encoding: ")) continue;
                encodings = line.substring("Accept-Encoding: ".length());
            }
            String excludedAgents = System.getProperty("excludedAgents");
            if (agent != null && excludedAgents != null) {
                StringTokenizer tk = new StringTokenizer(excludedAgents, ",");
                while (tk.hasMoreTokens()) {
                    if (agent.indexOf(tk.nextToken()) < 0) continue;
                    RouteServer.writeHttpHeader(bw);
                    bw.write("Bad agent: " + agent);
                    bw.flush();
                    return;
                }
            }
            if (getline.startsWith("GET /favicon.ico")) {
                return;
            }
            if (getline.startsWith("GET /robots.txt")) {
                RouteServer.writeHttpHeader(bw);
                bw.write("User-agent: *\n");
                bw.write("Disallow: /\n");
                bw.flush();
                return;
            }
            InetAddress ip = this.clientSocket.getInetAddress();
            System.out.println(RouteServer.formattedTimestamp() + " ip=" + (ip == null ? "null" : ip.toString()) + " -> " + getline);
            String url = getline.split(" ")[1];
            HashMap<String, String> params = RouteServer.getUrlParams(url);
            long maxRunningTime = RouteServer.getMaxRunningTime();
            if (!params.containsKey("lonlats") || !params.containsKey("profile")) {
                if (url.startsWith(PROFILE_UPLOAD_URL)) {
                    if (getline.startsWith("OPTIONS")) {
                        String corsHeaders = "Access-Control-Allow-Methods: GET, POST\nAccess-Control-Allow-Headers: Content-Type\n";
                        RouteServer.writeHttpHeader(bw, "text/plain", null, corsHeaders);
                        bw.flush();
                        return;
                    }
                    RouteServer.writeHttpHeader(bw, "application/json");
                    String profileId = null;
                    if (url.length() > PROFILE_UPLOAD_URL.length() + 1) {
                        profileId = url.substring(PROFILE_UPLOAD_URL.length() + 1);
                    }
                    ProfileUploadHandler uploadHandler = new ProfileUploadHandler(this.serviceContext);
                    uploadHandler.handlePostRequest(profileId, br, bw);
                    bw.flush();
                    return;
                }
                if (url.startsWith("/brouter/suspects")) {
                    RouteServer.writeHttpHeader(bw, url.endsWith(".json") ? "application/json" : "text/html");
                    SuspectManager.process(url, bw);
                    return;
                }
                throw new IllegalArgumentException("unknown request syntax: " + getline);
            }
            ServerHandler handler = new ServerHandler(this.serviceContext, params);
            RoutingContext rc = ((RequestHandler)handler).readRoutingContext();
            List<OsmNodeNamed> wplist = ((RequestHandler)handler).readWayPointList();
            if (wplist.size() < 10) {
                NearRecentWps.add(wplist);
            }
            for (Map.Entry<String, String> e : params.entrySet()) {
                if ("timode".equals(e.getKey())) {
                    rc.turnInstructionMode = Integer.parseInt(e.getValue());
                    continue;
                }
                if ("heading".equals(e.getKey())) {
                    rc.startDirection = Integer.parseInt(e.getValue());
                    rc.forceUseStartDirection = true;
                    continue;
                }
                if (!e.getKey().startsWith("profile:")) continue;
                if (rc.keyValues == null) {
                    rc.keyValues = new HashMap<String, String>();
                }
                rc.keyValues.put(e.getKey().substring(8), e.getValue());
            }
            this.cr = new RoutingEngine(null, null, this.serviceContext.segmentDir, wplist, rc);
            this.cr.quite = true;
            this.cr.doRun(maxRunningTime);
            if (this.cr.getErrorMessage() != null) {
                RouteServer.writeHttpHeader(bw);
                bw.write(this.cr.getErrorMessage());
                bw.write("\n");
            } else {
                OsmTrack track = this.cr.getFoundTrack();
                String headers = encodings == null || encodings.indexOf("gzip") < 0 ? null : "Content-Encoding: gzip\n";
                RouteServer.writeHttpHeader(bw, ((RequestHandler)handler).getMimeType(), ((RequestHandler)handler).getFileName(), headers);
                if (track != null) {
                    if (headers != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), "UTF-8");
                        w.write(((RequestHandler)handler).formatTrack(track));
                        ((Writer)w).close();
                        bw.flush();
                        this.clientSocket.getOutputStream().write(baos.toByteArray());
                    } else {
                        bw.write(((RequestHandler)handler).formatTrack(track));
                    }
                }
            }
            bw.flush();
        }
        catch (Throwable e) {
            System.out.println("RouteServer got exception (will continue): " + e);
            e.printStackTrace();
        }
        finally {
            this.cr = null;
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {}
            }
            if (this.clientSocket != null) {
                try {
                    this.clientSocket.close();
                }
                catch (Exception e) {}
            }
            this.terminated = true;
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("BRouter 1.5.5 / 22072019");
        if (args.length != 5 && args.length != 6) {
            System.out.println("serve BRouter protocol");
            System.out.println("usage: java RouteServer <segmentdir> <profiledir> <customprofiledir> <port> <maxthreads> [bindaddress]");
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.segmentDir = args[0];
        serviceContext.profileDir = args[1];
        System.setProperty("profileBaseDir", serviceContext.profileDir);
        String dirs = args[2];
        StringTokenizer tk = new StringTokenizer(dirs, ",");
        serviceContext.customProfileDir = tk.nextToken();
        serviceContext.sharedProfileDir = tk.hasMoreTokens() ? tk.nextToken() : serviceContext.customProfileDir;
        int maxthreads = Integer.parseInt(args[4]);
        TreeMap<Long, RouteServer> threadMap = new TreeMap<Long, RouteServer>();
        ServerSocket serverSocket = args.length > 5 ? new ServerSocket(Integer.parseInt(args[3]), 50, InetAddress.getByName(args[5])) : new ServerSocket(Integer.parseInt(args[3]));
        File stackLog = new File("stacks.txt");
        if (stackLog.exists()) {
            StackSampler stackSampler = new StackSampler(stackLog, 1000);
            stackSampler.start();
            System.out.println("*** sampling stacks into stacks.txt *** ");
        }
        long last_ts = 0L;
        while (true) {
            long ts;
            boolean removedItem;
            Socket clientSocket = serverSocket.accept();
            RouteServer server = new RouteServer();
            server.serviceContext = serviceContext;
            server.clientSocket = clientSocket;
            block1: do {
                removedItem = false;
                for (Map.Entry e : threadMap.entrySet()) {
                    if (!((RouteServer)e.getValue()).terminated) continue;
                    threadMap.remove(e.getKey());
                    removedItem = true;
                    continue block1;
                }
            } while (removedItem);
            if (threadMap.size() >= maxthreads) {
                Long k = (Long)threadMap.firstKey();
                RouteServer victim = (RouteServer)threadMap.get(k);
                threadMap.remove(k);
                victim.stopRouter();
            }
            for (ts = System.currentTimeMillis(); ts <= last_ts; ++ts) {
            }
            threadMap.put(ts, server);
            last_ts = ts;
            server.start();
        }
    }

    private static HashMap<String, String> getUrlParams(String url) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        String decoded = URLDecoder.decode(url, "UTF-8");
        StringTokenizer tk = new StringTokenizer(decoded, "?&");
        while (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            StringTokenizer tk2 = new StringTokenizer(t, "=");
            if (!tk2.hasMoreTokens()) continue;
            String key = tk2.nextToken();
            if (!tk2.hasMoreTokens()) continue;
            String value = tk2.nextToken();
            params.put(key, value);
        }
        return params;
    }

    private static long getMaxRunningTime() {
        long maxRunningTime = 60000L;
        String sMaxRunningTime = System.getProperty("maxRunningTime");
        if (sMaxRunningTime != null) {
            maxRunningTime = Integer.parseInt(sMaxRunningTime) * 1000;
        }
        return maxRunningTime;
    }

    private static void writeHttpHeader(BufferedWriter bw) throws IOException {
        RouteServer.writeHttpHeader(bw, "text/plain");
    }

    private static void writeHttpHeader(BufferedWriter bw, String mimeType) throws IOException {
        RouteServer.writeHttpHeader(bw, mimeType, null);
    }

    private static void writeHttpHeader(BufferedWriter bw, String mimeType, String fileName) throws IOException {
        RouteServer.writeHttpHeader(bw, mimeType, fileName, null);
    }

    private static void writeHttpHeader(BufferedWriter bw, String mimeType, String fileName, String headers) throws IOException {
        bw.write("HTTP/1.1 200 OK\n");
        bw.write("Connection: close\n");
        bw.write("Content-Type: " + mimeType + "; charset=utf-8\n");
        if (fileName != null) {
            bw.write("Content-Disposition: attachment; filename=\"" + fileName + "\"\n");
        }
        bw.write("Access-Control-Allow-Origin: *\n");
        if (headers != null) {
            bw.write(headers);
        }
        bw.write("\n");
    }
}

