/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.MatchedWaypoint;
import btools.mapaccess.NodesCache;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmLinkHolder;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodePairSet;
import btools.router.MessageData;
import btools.router.OsmNodeNamed;
import btools.router.OsmPath;
import btools.router.OsmPathElement;
import btools.router.OsmPrePath;
import btools.router.OsmTrack;
import btools.router.ProfileCache;
import btools.router.RoutingContext;
import btools.router.RoutingIslandException;
import btools.router.SearchBoundary;
import btools.util.SortedHeap;
import btools.util.StackSampler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RoutingEngine
extends Thread {
    private NodesCache nodesCache;
    private SortedHeap<OsmPath> openSet = new SortedHeap();
    private boolean finished = false;
    protected List<OsmNodeNamed> waypoints = null;
    protected List<MatchedWaypoint> matchedWaypoints;
    private int linksProcessed = 0;
    private int nodeLimit;
    private int MAXNODES_ISLAND_CHECK = 500;
    private OsmNodePairSet islandNodePairs = new OsmNodePairSet(this.MAXNODES_ISLAND_CHECK);
    protected OsmTrack foundTrack = new OsmTrack();
    private OsmTrack foundRawTrack = null;
    private int alternativeIndex = 0;
    protected String errorMessage = null;
    private volatile boolean terminated;
    protected String segmentDir;
    private String outfileBase;
    private String logfileBase;
    private boolean infoLogEnabled;
    private Writer infoLogWriter;
    private StackSampler stackSampler;
    protected RoutingContext routingContext;
    public double airDistanceCostFactor;
    private OsmTrack guideTrack;
    private OsmPathElement matchPath;
    private long startTime;
    private long maxRunningTime;
    public SearchBoundary boundary;
    public boolean quite = false;
    private Object[] extract;
    private boolean directWeaving = !Boolean.getBoolean("disableDirectWeaving");

    public RoutingEngine(String outfileBase, String logfileBase, String segmentDir, List<OsmNodeNamed> waypoints, RoutingContext rc) {
        this.segmentDir = segmentDir;
        this.outfileBase = outfileBase;
        this.logfileBase = logfileBase;
        this.waypoints = waypoints;
        this.infoLogEnabled = outfileBase != null;
        this.routingContext = rc;
        File baseFolder = new File(this.routingContext.localFunction).getParentFile();
        File file = baseFolder = baseFolder == null ? null : baseFolder.getParentFile();
        if (baseFolder != null) {
            try {
                File debugLog = new File(baseFolder, "debug.txt");
                if (debugLog.exists()) {
                    this.infoLogWriter = new FileWriter(debugLog, true);
                    this.logInfo("********** start request at ");
                    this.logInfo("********** " + new Date());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("cannot open debug-log:" + ioe);
            }
            File stackLog = new File(baseFolder, "stacks.txt");
            if (stackLog.exists()) {
                this.stackSampler = new StackSampler(stackLog, 1000);
                this.stackSampler.start();
                this.logInfo("********** started stacksampling");
            }
        }
        boolean cachedProfile = ProfileCache.parseProfile(rc);
        if (this.hasInfo()) {
            this.logInfo("parsed profile " + rc.localFunction + " cached=" + cachedProfile);
        }
    }

    private boolean hasInfo() {
        return this.infoLogEnabled || this.infoLogWriter != null;
    }

    private void logInfo(String s) {
        if (this.infoLogEnabled) {
            System.out.println(s);
        }
        if (this.infoLogWriter != null) {
            try {
                this.infoLogWriter.write(s);
                this.infoLogWriter.write(10);
                this.infoLogWriter.flush();
            }
            catch (IOException io) {
                this.infoLogWriter = null;
            }
        }
    }

    private void logThrowable(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        this.logInfo(sw.toString());
    }

    @Override
    public void run() {
        this.doRun(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun(long maxRunningTime) {
        try {
            this.routingContext.cleanNogolist(this.waypoints);
            long startTime0 = this.startTime = System.currentTimeMillis();
            this.maxRunningTime = maxRunningTime;
            int nsections = this.waypoints.size() - 1;
            OsmTrack[] refTracks = new OsmTrack[nsections];
            OsmTrack[] lastTracks = new OsmTrack[nsections];
            OsmTrack track = null;
            ArrayList<String> messageList = new ArrayList<String>();
            int i = 0;
            while (true) {
                block45: {
                    block46: {
                        block44: {
                            track = this.findTrack(refTracks, lastTracks);
                            track.message = "track-length = " + track.distance + " filtered ascend = " + track.ascend + " plain-ascend = " + track.plainAscend + " cost=" + track.cost;
                            if (track.energy != 0) {
                                track.message = track.message + " energy=" + track.getFormattedEnergy() + " time=" + track.getFormattedTime2();
                            }
                            track.name = "brouter_" + this.routingContext.getProfileName() + "_" + i;
                            messageList.add(track.message);
                            track.messageList = messageList;
                            if (this.outfileBase == null) break block44;
                            String filename = this.outfileBase + i + ".gpx";
                            OsmTrack oldTrack = new OsmTrack();
                            oldTrack.readGpx(filename);
                            if (track.equalsTrack(oldTrack)) break block45;
                            oldTrack = null;
                            track.writeGpx(filename);
                            this.foundTrack = track;
                            this.alternativeIndex = i;
                            break block46;
                        }
                        if (i != this.routingContext.getAlternativeIdx(0, 3)) break block45;
                        if ("CSV".equals(System.getProperty("reportFormat"))) {
                            track.dumpMessages(null, this.routingContext);
                        } else if (!this.quite) {
                            System.out.println(track.formatAsGpx());
                        }
                        this.foundTrack = track;
                    }
                    if (this.logfileBase == null) break;
                    String logfilename = this.logfileBase + i + ".csv";
                    track.dumpMessages(logfilename, this.routingContext);
                    break;
                }
                ++i;
            }
            long endTime = System.currentTimeMillis();
            this.logInfo("execution time = " + (double)(endTime - startTime0) / 1000.0 + " seconds");
        }
        catch (IllegalArgumentException e) {
            this.logException(e);
        }
        catch (Exception e) {
            this.logException(e);
            this.logThrowable(e);
        }
        catch (Error e) {
            this.cleanOnOOM();
            this.logException(e);
            this.logThrowable(e);
        }
        finally {
            if (this.hasInfo() && this.routingContext.expctxWay != null) {
                this.logInfo("expression cache stats=" + this.routingContext.expctxWay.cacheStats());
            }
            ProfileCache.releaseProfile(this.routingContext);
            if (this.nodesCache != null) {
                if (this.hasInfo() && this.nodesCache != null) {
                    this.logInfo("NodesCache status before close=" + this.nodesCache.formatStatus());
                }
                this.nodesCache.close();
                this.nodesCache = null;
            }
            this.openSet.clear();
            this.finished = true;
            if (this.infoLogWriter != null) {
                try {
                    this.infoLogWriter.close();
                }
                catch (Exception e) {}
                this.infoLogWriter = null;
            }
            if (this.stackSampler != null) {
                try {
                    this.stackSampler.close();
                }
                catch (Exception e) {}
                this.stackSampler = null;
            }
        }
    }

    private void logException(Throwable t) {
        this.errorMessage = t instanceof IllegalArgumentException ? t.getMessage() : t.toString();
        this.logInfo("Error (linksProcessed=" + this.linksProcessed + " open paths: " + this.openSet.getSize() + "): " + this.errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSearch() {
        try {
            MatchedWaypoint seedPoint = new MatchedWaypoint();
            seedPoint.waypoint = this.waypoints.get(0);
            ArrayList<MatchedWaypoint> listOne = new ArrayList<MatchedWaypoint>();
            listOne.add(seedPoint);
            this.matchWaypointsToNodes(listOne);
            this.findTrack("seededSearch", seedPoint, null, null, null, false);
        }
        catch (IllegalArgumentException e) {
            this.logException(e);
        }
        catch (Exception e) {
            this.logException(e);
            this.logThrowable(e);
        }
        catch (Error e) {
            this.cleanOnOOM();
            this.logException(e);
            this.logThrowable(e);
        }
        finally {
            ProfileCache.releaseProfile(this.routingContext);
            if (this.nodesCache != null) {
                this.nodesCache.close();
                this.nodesCache = null;
            }
            this.openSet.clear();
            this.finished = true;
            if (this.infoLogWriter != null) {
                try {
                    this.infoLogWriter.close();
                }
                catch (Exception e) {}
                this.infoLogWriter = null;
            }
        }
    }

    public void cleanOnOOM() {
        this.terminate();
    }

    private OsmTrack findTrack(OsmTrack[] refTracks, OsmTrack[] lastTracks) {
        while (true) {
            try {
                return this.tryFindTrack(refTracks, lastTracks);
            }
            catch (RoutingIslandException rie) {
                this.islandNodePairs.freezeTempPairs();
                this.nodesCache.clean(true);
                this.matchedWaypoints = null;
                continue;
            }
            break;
        }
    }

    private OsmTrack tryFindTrack(OsmTrack[] refTracks, OsmTrack[] lastTracks) {
        OsmTrack totaltrack = new OsmTrack();
        int nUnmatched = this.waypoints.size();
        if (this.hasInfo()) {
            for (OsmNodeNamed wp : this.waypoints) {
                this.logInfo("wp=" + wp);
            }
        }
        OsmTrack nearbyTrack = null;
        if (lastTracks[this.waypoints.size() - 2] == null) {
            StringBuilder debugInfo = this.hasInfo() ? new StringBuilder() : null;
            nearbyTrack = OsmTrack.readBinary(this.routingContext.rawTrackPath, this.waypoints.get(this.waypoints.size() - 1), this.routingContext.getNogoChecksums(), this.routingContext.profileTimestamp, debugInfo);
            if (nearbyTrack != null) {
                --nUnmatched;
            }
            if (this.hasInfo()) {
                boolean found = nearbyTrack != null;
                boolean dirty = found ? nearbyTrack.isDirty : false;
                this.logInfo("read referenceTrack, found=" + found + " dirty=" + dirty + " " + debugInfo);
            }
        }
        if (this.matchedWaypoints == null) {
            int i;
            this.matchedWaypoints = new ArrayList<MatchedWaypoint>();
            for (i = 0; i < nUnmatched; ++i) {
                MatchedWaypoint mwp = new MatchedWaypoint();
                mwp.waypoint = this.waypoints.get(i);
                mwp.name = this.waypoints.get((int)i).name;
                this.matchedWaypoints.add(mwp);
            }
            this.matchWaypointsToNodes(this.matchedWaypoints);
            this.routingContext.inverseDirection = !this.routingContext.inverseRouting;
            this.airDistanceCostFactor = 0.0;
            for (i = 0; i < this.matchedWaypoints.size() - 1; ++i) {
                OsmTrack seg;
                this.nodeLimit = this.MAXNODES_ISLAND_CHECK;
                if (this.routingContext.inverseRouting) {
                    seg = this.findTrack("start-island-check", this.matchedWaypoints.get(i), this.matchedWaypoints.get(i + 1), null, null, false);
                    if (seg != null || this.nodeLimit <= 0) continue;
                    throw new IllegalArgumentException("start island detected for section " + i);
                }
                seg = this.findTrack("target-island-check", this.matchedWaypoints.get(i + 1), this.matchedWaypoints.get(i), null, null, false);
                if (seg != null || this.nodeLimit <= 0) continue;
                throw new IllegalArgumentException("target island detected for section " + i);
            }
            this.routingContext.inverseDirection = false;
            this.nodeLimit = 0;
            if (nearbyTrack != null) {
                this.matchedWaypoints.add(nearbyTrack.endPoint);
            }
        }
        for (int i = 0; i < this.matchedWaypoints.size() - 1; ++i) {
            OsmTrack seg;
            if (lastTracks[i] != null) {
                if (refTracks[i] == null) {
                    refTracks[i] = new OsmTrack();
                }
                refTracks[i].addNodes(lastTracks[i]);
            }
            if (this.routingContext.inverseRouting) {
                this.routingContext.inverseDirection = true;
                seg = this.searchTrack(this.matchedWaypoints.get(i + 1), this.matchedWaypoints.get(i), null, refTracks[i]);
                this.routingContext.inverseDirection = false;
            } else {
                seg = this.searchTrack(this.matchedWaypoints.get(i), this.matchedWaypoints.get(i + 1), i == this.matchedWaypoints.size() - 2 ? nearbyTrack : null, refTracks[i]);
            }
            if (seg == null) {
                return null;
            }
            totaltrack.appendTrack(seg);
            lastTracks[i] = seg;
        }
        totaltrack.matchedWaypoints = this.matchedWaypoints;
        return totaltrack;
    }

    private void matchWaypointsToNodes(List<MatchedWaypoint> unmatchedWaypoints) {
        this.resetCache(false);
        this.nodesCache.matchWaypointsToNodes(unmatchedWaypoints, 250.0, this.islandNodePairs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmTrack searchTrack(MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack nearbyTrack, OsmTrack refTrack) {
        boolean wasClean;
        IllegalArgumentException dirtyMessage;
        boolean isDirty;
        double[] airDistanceCostFactors;
        OsmTrack track;
        block19: {
            track = null;
            airDistanceCostFactors = new double[]{this.routingContext.pass1coefficient, this.routingContext.pass2coefficient};
            isDirty = false;
            dirtyMessage = null;
            if (nearbyTrack != null) {
                this.airDistanceCostFactor = 0.0;
                try {
                    track = this.findTrack("re-routing", startWp, endWp, nearbyTrack, refTrack, true);
                }
                catch (IllegalArgumentException iae) {
                    if (this.terminated) {
                        throw iae;
                    }
                    if (this.matchPath != null) {
                        track = this.mergeTrack(this.matchPath, nearbyTrack);
                        isDirty = true;
                        dirtyMessage = iae;
                        this.logInfo("using fast partial recalc");
                    }
                    if (this.maxRunningTime <= 0L) break block19;
                    this.maxRunningTime += System.currentTimeMillis() - this.startTime;
                }
            }
        }
        if (track == null) {
            for (int cfi = 0; cfi < airDistanceCostFactors.length; ++cfi) {
                OsmTrack t;
                this.airDistanceCostFactor = airDistanceCostFactors[cfi];
                if (this.airDistanceCostFactor < 0.0) continue;
                try {
                    t = this.findTrack(cfi == 0 ? "pass0" : "pass1", startWp, endWp, track, refTrack, false);
                }
                catch (IllegalArgumentException iae) {
                    if (!this.terminated && this.matchPath != null) {
                        this.logInfo("supplying dirty reference track after timeout");
                        this.foundRawTrack = this.mergeTrack(this.matchPath, track);
                        this.foundRawTrack.endPoint = endWp;
                        this.foundRawTrack.nogoChecksums = this.routingContext.getNogoChecksums();
                        this.foundRawTrack.profileTimestamp = this.routingContext.profileTimestamp;
                        this.foundRawTrack.isDirty = true;
                    }
                    throw iae;
                }
                if (t == null && track != null && this.matchPath != null) {
                    t = this.mergeTrack(this.matchPath, track);
                    this.logInfo("using sloppy merge cause pass1 didn't reach destination");
                }
                if (t != null) {
                    track = t;
                    continue;
                }
                throw new IllegalArgumentException("no track found at pass=" + cfi);
            }
        }
        if (track == null) {
            throw new IllegalArgumentException("no track found");
        }
        boolean bl = wasClean = nearbyTrack != null && !nearbyTrack.isDirty;
        if (!(refTrack != null || wasClean && isDirty)) {
            this.logInfo("supplying new reference track, dirty=" + isDirty);
            track.endPoint = endWp;
            track.nogoChecksums = this.routingContext.getNogoChecksums();
            track.profileTimestamp = this.routingContext.profileTimestamp;
            track.isDirty = isDirty;
            this.foundRawTrack = track;
        }
        if (!wasClean && isDirty) {
            throw dirtyMessage;
        }
        this.airDistanceCostFactor = 0.0;
        this.guideTrack = track;
        this.startTime = System.currentTimeMillis();
        try {
            OsmTrack tt = this.findTrack("re-tracking", startWp, endWp, null, refTrack, false);
            if (tt == null) {
                throw new IllegalArgumentException("error re-tracking track");
            }
            OsmTrack osmTrack = tt;
            return osmTrack;
        }
        finally {
            this.guideTrack = null;
        }
    }

    private void resetCache(boolean detailed) {
        if (this.hasInfo() && this.nodesCache != null) {
            this.logInfo("NodesCache status before reset=" + this.nodesCache.formatStatus());
        }
        long maxmem = (long)this.routingContext.memoryclass * 1024L * 1024L;
        this.nodesCache = new NodesCache(this.segmentDir, this.routingContext.expctxWay, this.routingContext.forceSecondaryData, maxmem, this.nodesCache, detailed);
        this.islandNodePairs.clearTempPairs();
    }

    private OsmPath getStartPath(OsmNode n1, OsmNode n2, MatchedWaypoint mwp, OsmNodeNamed endPos, boolean sameSegmentSearch) {
        OsmPath p = this.getStartPath(n1, n2, new OsmNodeNamed(mwp.waypoint), endPos);
        if (sameSegmentSearch) {
            OsmPath pe = this.getEndPath(n1, p.getLink(), endPos);
            OsmPath pt = this.getEndPath(n1, p.getLink(), null);
            int costdelta = pt.cost - p.cost;
            if (pe.cost >= costdelta) {
                pe.cost -= costdelta;
                if (this.guideTrack != null) {
                    OsmPathElement startElement = p.originElement;
                    while (startElement.origin != null) {
                        startElement = startElement.origin;
                    }
                    if (pe.originElement.cost > costdelta) {
                        OsmPathElement e = pe.originElement;
                        while (e.origin != null && e.origin.cost > costdelta) {
                            e = e.origin;
                            e.cost -= costdelta;
                        }
                        e.origin = startElement;
                    } else {
                        pe.originElement = startElement;
                    }
                }
                pe.treedepth = 0;
                return pe;
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmPath getStartPath(OsmNode n1, OsmNode n2, OsmNodeNamed wp, OsmNodeNamed endPos) {
        try {
            this.routingContext.setWaypoint(wp, false);
            OsmPath bestPath = null;
            OsmLink bestLink = null;
            OsmLink startLink = new OsmLink(null, n1);
            OsmPath startPath = this.routingContext.createPath(startLink);
            startLink.addLinkHolder(startPath, null);
            double minradius = 1.0E10;
            for (OsmLink link = n1.firstlink; link != null; link = link.getNext(n1)) {
                OsmNode nextNode = link.getTarget(n1);
                if (nextNode.isHollow() || nextNode.firstlink == null || nextNode == n1 || nextNode != n2) continue;
                wp.radius = 1.0E9;
                OsmPath testPath = this.routingContext.createPath(startPath, link, null, this.guideTrack != null);
                int n = testPath.airdistance = endPos == null ? 0 : nextNode.calcDistance(endPos);
                if (!(wp.radius < minradius)) continue;
                bestPath = testPath;
                minradius = wp.radius;
                bestLink = link;
            }
            if (bestLink != null) {
                bestLink.addLinkHolder(bestPath, n1);
            }
            bestPath.treedepth = 1;
            OsmPath osmPath = bestPath;
            return osmPath;
        }
        finally {
            this.routingContext.unsetWaypoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmPath getEndPath(OsmNode n1, OsmLink link, OsmNodeNamed wp) {
        try {
            if (wp != null) {
                this.routingContext.setWaypoint(wp, true);
            }
            OsmLink startLink = new OsmLink(null, n1);
            OsmPath startPath = this.routingContext.createPath(startLink);
            startLink.addLinkHolder(startPath, null);
            if (wp != null) {
                wp.radius = 1.5;
            }
            OsmPath osmPath = this.routingContext.createPath(startPath, link, null, this.guideTrack != null);
            return osmPath;
        }
        finally {
            if (wp != null) {
                this.routingContext.unsetWaypoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmTrack findTrack(String operationName, MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack costCuttingTrack, OsmTrack refTrack, boolean fastPartialRecalc) {
        try {
            boolean detailed = this.guideTrack != null;
            this.resetCache(detailed);
            this.nodesCache.nodesMap.cleanupMode = detailed ? 0 : (this.routingContext.considerTurnRestrictions ? 2 : 1);
            OsmTrack osmTrack = this._findTrack(operationName, startWp, endWp, costCuttingTrack, refTrack, fastPartialRecalc);
            return osmTrack;
        }
        finally {
            this.nodesCache.clean(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OsmTrack _findTrack(String operationName, MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack costCuttingTrack, OsmTrack refTrack, boolean fastPartialRecalc) {
        Object pe1;
        boolean verbose = this.guideTrack != null;
        int maxTotalCost = this.guideTrack != null ? this.guideTrack.cost + 5000 : 1000000000;
        int firstMatchCost = 1000000000;
        this.logInfo("findtrack with airDistanceCostFactor=" + this.airDistanceCostFactor);
        if (costCuttingTrack != null) {
            this.logInfo("costCuttingTrack.cost=" + costCuttingTrack.cost);
        }
        this.matchPath = null;
        int nodesVisited = 0;
        long startNodeId1 = startWp.node1.getIdFromPos();
        long startNodeId2 = startWp.node2.getIdFromPos();
        long endNodeId1 = endWp == null ? -1L : endWp.node1.getIdFromPos();
        long endNodeId2 = endWp == null ? -1L : endWp.node2.getIdFromPos();
        OsmNode end1 = null;
        OsmNode end2 = null;
        OsmNodeNamed endPos = null;
        boolean sameSegmentSearch = false;
        OsmNode start1 = this.nodesCache.getGraphNode(startWp.node1);
        OsmNode start2 = this.nodesCache.getGraphNode(startWp.node2);
        if (endWp != null) {
            end1 = this.nodesCache.getGraphNode(endWp.node1);
            end2 = this.nodesCache.getGraphNode(endWp.node2);
            this.nodesCache.nodesMap.endNode1 = end1;
            this.nodesCache.nodesMap.endNode2 = end2;
            endPos = new OsmNodeNamed(endWp.crosspoint);
            boolean bl = sameSegmentSearch = start1 == end1 && start2 == end2 || start1 == end2 && start2 == end1;
        }
        if (!this.nodesCache.obtainNonHollowNode(start1)) {
            return null;
        }
        this.nodesCache.expandHollowLinkTargets(start1);
        if (!this.nodesCache.obtainNonHollowNode(start2)) {
            return null;
        }
        this.nodesCache.expandHollowLinkTargets(start2);
        this.routingContext.startDirectionValid = this.routingContext.forceUseStartDirection || fastPartialRecalc;
        this.routingContext.startDirectionValid = this.routingContext.startDirectionValid & (this.routingContext.startDirection != null && !this.routingContext.inverseDirection);
        if (this.routingContext.startDirectionValid) {
            this.logInfo("using start direction " + this.routingContext.startDirection);
        }
        OsmPath startPath1 = this.getStartPath(start1, start2, startWp, endPos, sameSegmentSearch);
        OsmPath startPath2 = this.getStartPath(start2, start1, startWp, endPos, sameSegmentSearch);
        if (costCuttingTrack != null) {
            OsmPathElement pe2;
            pe1 = costCuttingTrack.getLink(startNodeId1, startNodeId2);
            if (pe1 != null) {
                this.logInfo("initialMatch pe1.cost=" + ((OsmPathElement)pe1).cost);
                int c = startPath1.cost - ((OsmPathElement)pe1).cost;
                if (c < 0) {
                    c = 0;
                }
                if (c < firstMatchCost) {
                    firstMatchCost = c;
                }
            }
            if ((pe2 = costCuttingTrack.getLink(startNodeId2, startNodeId1)) != null) {
                this.logInfo("initialMatch pe2.cost=" + pe2.cost);
                int c = startPath2.cost - pe2.cost;
                if (c < 0) {
                    c = 0;
                }
                if (c < firstMatchCost) {
                    firstMatchCost = c;
                }
            }
            if (firstMatchCost < 1000000000) {
                this.logInfo("firstMatchCost from initial match=" + firstMatchCost);
            }
        }
        pe1 = this.openSet;
        synchronized (pe1) {
            this.openSet.clear();
            this.addToOpenset(startPath1);
            this.addToOpenset(startPath2);
        }
        ArrayList<OsmPath> openBorderList = new ArrayList<OsmPath>(4096);
        boolean memoryPanicMode = false;
        boolean needNonPanicProcessing = false;
        while (true) {
            if (this.terminated) {
                throw new IllegalArgumentException("operation killed by thread-priority-watchdog after " + (System.currentTimeMillis() - this.startTime) / 1000L + " seconds");
            }
            if (this.maxRunningTime > 0L) {
                long timeout;
                long l = timeout = this.matchPath == null && fastPartialRecalc ? this.maxRunningTime / 3L : this.maxRunningTime;
                if (System.currentTimeMillis() - this.startTime > timeout) {
                    throw new IllegalArgumentException(operationName + " timeout after " + timeout / 1000L + " seconds");
                }
            }
            SortedHeap<OsmPath> sortedHeap = this.openSet;
            synchronized (sortedHeap) {
                OsmNode nextNode;
                OsmLink link;
                OsmLinkHolder firstLinkHolder;
                OsmPath path = this.openSet.popLowestKeyValue();
                if (path == null) {
                    if (openBorderList.isEmpty()) {
                        break;
                    }
                    for (OsmPath p : openBorderList) {
                        this.openSet.add(p.cost + (int)((double)p.airdistance * this.airDistanceCostFactor), p);
                    }
                    openBorderList.clear();
                    memoryPanicMode = false;
                    needNonPanicProcessing = true;
                    continue;
                }
                if (path.airdistance == -1) {
                    path.unregisterUpTree(this.routingContext);
                    continue;
                }
                if (this.directWeaving && this.nodesCache.hasHollowLinkTargets(path.getTargetNode())) {
                    if (!memoryPanicMode && !this.nodesCache.nodesMap.isInMemoryBounds(this.openSet.getSize(), false)) {
                        OsmPath p3;
                        int nodesBefore = this.nodesCache.nodesMap.nodesCreated;
                        int pathsBefore = this.openSet.getSize();
                        this.nodesCache.nodesMap.collectOutreachers();
                        while ((p3 = this.openSet.popLowestKeyValue()) != null) {
                            if (p3.airdistance == -1 || !this.nodesCache.nodesMap.canEscape(p3.getTargetNode())) continue;
                            openBorderList.add(p3);
                        }
                        this.nodesCache.nodesMap.clearTemp();
                        for (OsmPath p : openBorderList) {
                            this.openSet.add(p.cost + (int)((double)p.airdistance * this.airDistanceCostFactor), p);
                        }
                        openBorderList.clear();
                        this.logInfo("collected, nodes/paths before=" + nodesBefore + "/" + pathsBefore + " after=" + this.nodesCache.nodesMap.nodesCreated + "/" + this.openSet.getSize() + " maxTotalCost=" + maxTotalCost);
                        if (!this.nodesCache.nodesMap.isInMemoryBounds(this.openSet.getSize(), true)) {
                            if (maxTotalCost < 1000000000 || needNonPanicProcessing || fastPartialRecalc) {
                                throw new IllegalArgumentException("memory limit reached");
                            }
                            memoryPanicMode = true;
                            this.logInfo("************************ memory limit reached, enabled memory panic mode *************************");
                        }
                    }
                    if (memoryPanicMode) {
                        openBorderList.add(path);
                        continue;
                    }
                }
                needNonPanicProcessing = false;
                if (fastPartialRecalc && this.matchPath != null && (long)path.cost > 30L * (long)firstMatchCost && !costCuttingTrack.isDirty) {
                    this.logInfo("early exit: firstMatchCost=" + firstMatchCost + " path.cost=" + path.cost);
                    if (path.cost > maxTotalCost / 2 && System.currentTimeMillis() - this.startTime < this.maxRunningTime / 3L) {
                        this.logInfo("early exit supressed, running for completion, resetting timeout");
                        this.startTime = System.currentTimeMillis();
                        fastPartialRecalc = false;
                    } else {
                        throw new IllegalArgumentException("early exit for a close recalc");
                    }
                }
                if (this.nodeLimit > 0 && --this.nodeLimit == 0) {
                    return null;
                }
                ++nodesVisited;
                ++this.linksProcessed;
                OsmLink currentLink = path.getLink();
                OsmNode sourceNode = path.getSourceNode();
                OsmNode currentNode = path.getTargetNode();
                if (currentLink.isLinkUnused()) {
                    path.unregisterUpTree(this.routingContext);
                    continue;
                }
                long currentNodeId = currentNode.getIdFromPos();
                long sourceNodeId = sourceNode.getIdFromPos();
                if (!path.didEnterDestinationArea()) {
                    this.islandNodePairs.addTempPair(sourceNodeId, currentNodeId);
                }
                if (path.treedepth != 1) {
                    OsmPathElement pe;
                    if (path.treedepth == 0) {
                        path.treedepth = 1;
                    }
                    if (sourceNodeId == endNodeId1 && currentNodeId == endNodeId2 || sourceNodeId == endNodeId2 && currentNodeId == endNodeId1) {
                        this.logInfo("found track at cost " + path.cost + " nodesVisited = " + nodesVisited);
                        OsmTrack t = this.compileTrack(path, verbose);
                        t.showspeed = this.routingContext.showspeed;
                        return t;
                    }
                    if (costCuttingTrack != null && (pe = costCuttingTrack.getLink(sourceNodeId, currentNodeId)) != null) {
                        int costEstimate;
                        int parentcost = path.originElement == null ? 0 : path.originElement.cost;
                        int c = path.cost - parentcost - pe.cost;
                        if (c > 0) {
                            parentcost += c;
                        }
                        if (parentcost < firstMatchCost) {
                            firstMatchCost = parentcost;
                        }
                        if ((costEstimate = path.cost + path.elevationCorrection(this.routingContext) + (costCuttingTrack.cost - pe.cost)) <= maxTotalCost) {
                            this.matchPath = OsmPathElement.create(path, this.routingContext.countTraffic);
                        }
                        if (costEstimate < maxTotalCost) {
                            this.logInfo("maxcost " + maxTotalCost + " -> " + costEstimate);
                            maxTotalCost = costEstimate;
                        }
                    }
                }
                int keepPathAirdistance = path.airdistance;
                for (OsmLinkHolder linkHolder = firstLinkHolder = currentLink.getFirstLinkHolder(sourceNode); linkHolder != null; linkHolder = linkHolder.getNextForLink()) {
                    ((OsmPath)linkHolder).airdistance = -1;
                }
                boolean isBidir = currentLink.isBidirectional();
                sourceNode.unlinkLink(currentLink);
                if (isBidir && currentLink.getFirstLinkHolder(currentNode) == null && !this.routingContext.considerTurnRestrictions) {
                    currentNode.unlinkLink(currentLink);
                }
                if (path.cost + path.airdistance > maxTotalCost + 100) {
                    path.unregisterUpTree(this.routingContext);
                    continue;
                }
                this.nodesCache.nodesMap.currentMaxCost = maxTotalCost;
                this.nodesCache.nodesMap.currentPathCost = path.cost;
                this.nodesCache.nodesMap.destination = endPos;
                this.routingContext.firstPrePath = null;
                for (link = currentNode.firstlink; link != null; link = link.getNext(currentNode)) {
                    OsmPrePath prePath;
                    nextNode = link.getTarget(currentNode);
                    if (!this.nodesCache.obtainNonHollowNode(nextNode) || nextNode.firstlink == null || nextNode == sourceNode || (prePath = this.routingContext.createPrePath(path, link)) == null) continue;
                    prePath.next = this.routingContext.firstPrePath;
                    this.routingContext.firstPrePath = prePath;
                }
                for (link = currentNode.firstlink; link != null; link = link.getNext(currentNode)) {
                    OsmLinkHolder dominator;
                    boolean inRadius;
                    boolean trafficSim;
                    nextNode = link.getTarget(currentNode);
                    if (!this.nodesCache.obtainNonHollowNode(nextNode) || nextNode.firstlink == null || nextNode == sourceNode) continue;
                    if (this.guideTrack != null) {
                        int gidx = path.treedepth + 1;
                        if (gidx >= this.guideTrack.nodes.size()) continue;
                        OsmPathElement guideNode = this.guideTrack.nodes.get(this.routingContext.inverseRouting ? this.guideTrack.nodes.size() - 1 - gidx : gidx);
                        long nextId = nextNode.getIdFromPos();
                        if (nextId != guideNode.getIdFromPos()) {
                            if (this.routingContext.turnInstructionMode <= 0) continue;
                            OsmPath detour = this.routingContext.createPath(path, link, refTrack, true);
                            if (!((double)detour.cost >= 0.0) || nextId == startNodeId1 || nextId == startNodeId2) continue;
                            this.guideTrack.registerDetourForId(currentNode.getIdFromPos(), OsmPathElement.create(detour, false));
                            continue;
                        }
                    }
                    OsmPath bestPath = null;
                    boolean isFinalLink = false;
                    long targetNodeId = nextNode.getIdFromPos();
                    if (!(currentNodeId != endNodeId1 && currentNodeId != endNodeId2 || targetNodeId != endNodeId1 && targetNodeId != endNodeId2)) {
                        isFinalLink = true;
                    }
                    for (OsmLinkHolder linkHolder = firstLinkHolder; linkHolder != null; linkHolder = linkHolder.getNextForLink()) {
                        OsmPath otherPath = (OsmPath)linkHolder;
                        try {
                            if (isFinalLink) {
                                endPos.radius = 1.5;
                                this.routingContext.setWaypoint(endPos, true);
                            }
                            OsmPath testPath = this.routingContext.createPath(otherPath, link, refTrack, this.guideTrack != null);
                            if (testPath.cost < 0 || bestPath != null && testPath.cost >= bestPath.cost) continue;
                            bestPath = testPath;
                            continue;
                        }
                        finally {
                            if (isFinalLink) {
                                this.routingContext.unsetWaypoint();
                            }
                        }
                    }
                    if (bestPath == null) continue;
                    boolean bl = trafficSim = endPos == null;
                    bestPath.airdistance = trafficSim ? keepPathAirdistance : (isFinalLink ? 0 : nextNode.calcDistance(endPos));
                    boolean bl2 = inRadius = this.boundary == null || this.boundary.isInBoundary(nextNode, bestPath.cost);
                    if (!inRadius || !isFinalLink && bestPath.cost + bestPath.airdistance > maxTotalCost + 100) continue;
                    for (dominator = link.getFirstLinkHolder(currentNode); !trafficSim && dominator != null && !bestPath.definitlyWorseThan((OsmPath)dominator, this.routingContext); dominator = dominator.getNextForLink()) {
                    }
                    if (dominator != null) continue;
                    if (trafficSim && this.boundary != null && path.cost == 0 && bestPath.cost > 0) {
                        bestPath.airdistance += this.boundary.getBoundaryDistance(nextNode);
                    }
                    bestPath.treedepth = path.treedepth + 1;
                    link.addLinkHolder(bestPath, currentNode);
                    this.addToOpenset(bestPath);
                }
                path.unregisterUpTree(this.routingContext);
            }
        }
        if (nodesVisited < this.MAXNODES_ISLAND_CHECK && this.islandNodePairs.getFreezeCount() < 5) {
            throw new RoutingIslandException();
        }
        return null;
    }

    private void addToOpenset(OsmPath path) {
        if (path.cost >= 0) {
            this.openSet.add(path.cost + (int)((double)path.airdistance * this.airDistanceCostFactor), path);
            path.registerUpTree();
        }
    }

    private OsmTrack compileTrack(OsmPath path, boolean verbose) {
        double eleFactor;
        OsmPathElement element = OsmPathElement.create(path, false);
        if (this.guideTrack != null) {
            element = element.origin;
        }
        float totalTime = element.getTime();
        float totalEnergy = element.getEnergy();
        OsmTrack track = new OsmTrack();
        track.cost = path.cost;
        track.energy = (int)path.getTotalEnergy();
        int distance = 0;
        double ascend = 0.0;
        double ehb = 0.0;
        int ele_start = Short.MIN_VALUE;
        int ele_end = Short.MIN_VALUE;
        double d = eleFactor = this.routingContext.inverseRouting ? -0.25 : 0.25;
        while (element != null) {
            if (this.guideTrack != null && element.message == null) {
                element.message = new MessageData();
            }
            if (this.routingContext.inverseRouting) {
                element.setTime(totalTime - element.getTime());
                element.setEnergy(totalEnergy - element.getEnergy());
                track.nodes.add(element);
            } else {
                track.nodes.add(0, element);
            }
            OsmPathElement nextElement = element.origin;
            short ele = element.getSElev();
            if (ele != Short.MIN_VALUE) {
                ele_start = ele;
            }
            if (ele_end == Short.MIN_VALUE) {
                ele_end = ele;
            }
            if (nextElement != null) {
                distance += element.calcDistance(nextElement);
                short ele_next = nextElement.getSElev();
                if (ele_next != Short.MIN_VALUE) {
                    ehb += (double)(ele - ele_next) * eleFactor;
                }
                if (ehb > 10.0) {
                    ascend += ehb - 10.0;
                    ehb = 10.0;
                } else if (ehb < 0.0) {
                    ehb = 0.0;
                }
            }
            element = nextElement;
        }
        track.distance = distance;
        track.ascend = (int)(ascend += ehb);
        track.plainAscend = (int)((double)(ele_end - ele_start) * eleFactor + 0.5);
        this.logInfo("track-length = " + track.distance);
        this.logInfo("filtered ascend = " + track.ascend);
        track.buildMap();
        if (this.guideTrack != null) {
            track.copyDetours(this.guideTrack);
            track.processVoiceHints(this.routingContext);
            track.prepareSpeedProfile(this.routingContext);
        }
        return track;
    }

    private OsmTrack mergeTrack(OsmPathElement match, OsmTrack oldTrack) {
        this.logInfo("**************** merging match=" + match.cost + " with oldTrack=" + oldTrack.cost);
        OsmPathElement element = match;
        OsmTrack track = new OsmTrack();
        track.cost = oldTrack.cost;
        while (element != null) {
            track.addNode(element);
            element = element.origin;
        }
        long lastId = 0L;
        long id1 = match.getIdFromPos();
        long id0 = match.origin == null ? 0L : match.origin.getIdFromPos();
        boolean appending = false;
        for (OsmPathElement n : oldTrack.nodes) {
            long id;
            if (appending) {
                track.nodes.add(n);
            }
            if ((id = n.getIdFromPos()) == id1 && lastId == id0) {
                appending = true;
            }
            lastId = id;
        }
        track.buildMap();
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPathPeak() {
        SortedHeap<OsmPath> sortedHeap = this.openSet;
        synchronized (sortedHeap) {
            return this.openSet.getPeakSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOpenSet() {
        if (this.extract == null) {
            this.extract = new Object[500];
        }
        SortedHeap<OsmPath> sortedHeap = this.openSet;
        synchronized (sortedHeap) {
            if (this.guideTrack != null) {
                ArrayList<OsmPathElement> nodes = this.guideTrack.nodes;
                int[] res = new int[nodes.size() * 2];
                int i = 0;
                for (OsmPathElement n : nodes) {
                    res[i++] = n.getILon();
                    res[i++] = n.getILat();
                }
                return res;
            }
            int size = this.openSet.getExtract(this.extract);
            int[] res = new int[size * 2];
            int j = 0;
            for (int i = 0; i < size; ++i) {
                OsmPath p = (OsmPath)this.extract[i];
                this.extract[i] = null;
                OsmNode n = p.getTargetNode();
                res[j++] = n.ilon;
                res[j++] = n.ilat;
            }
            return res;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getLinksProcessed() {
        return this.linksProcessed;
    }

    public int getDistance() {
        return this.foundTrack.distance;
    }

    public int getAscend() {
        return this.foundTrack.ascend;
    }

    public int getPlainAscend() {
        return this.foundTrack.plainAscend;
    }

    public String getTime() {
        return this.foundTrack.getFormattedTime2();
    }

    public OsmTrack getFoundTrack() {
        return this.foundTrack;
    }

    public int getAlternativeIndex() {
        return this.alternativeIndex;
    }

    public OsmTrack getFoundRawTrack() {
        return this.foundRawTrack;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void terminate() {
        this.terminated = true;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

