/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.OsmNodeNamed;
import btools.util.CheapRuler;
import java.util.ArrayList;
import java.util.List;

public class OsmNogoPolygon
extends OsmNodeNamed {
    public final List<Point> points = new ArrayList<Point>();
    public final boolean isClosed;

    public OsmNogoPolygon(boolean closed) {
        this.isClosed = closed;
        this.isNogo = true;
        this.name = "";
    }

    public final void addVertex(int lon, int lat) {
        this.points.add(new Point(lon, lat));
    }

    public void calcBoundingCircle() {
        int cymin = Integer.MAX_VALUE;
        int cxmin = Integer.MAX_VALUE;
        int cymax = Integer.MIN_VALUE;
        int cxmax = Integer.MIN_VALUE;
        for (int i = 0; i < this.points.size(); ++i) {
            Point p = this.points.get(i);
            if (p.x < cxmin) {
                cxmin = p.x;
            }
            if (p.x > cxmax) {
                cxmax = p.x;
            }
            if (p.y < cymin) {
                cymin = p.y;
            }
            if (p.y <= cymax) continue;
            cymax = p.y;
        }
        int cx = (cxmax + cxmin) / 2;
        int cy = (cymax + cymin) / 2;
        double[] lonlat2m = CheapRuler.getLonLatToMeterScales(cy);
        double dlon2m = lonlat2m[0];
        double dlat2m = lonlat2m[1];
        double rad = 0.0;
        double dmax = 0.0;
        int i_max = -1;
        while (true) {
            for (int i = 0; i < this.points.size(); ++i) {
                Point p = this.points.get(i);
                double dist = CheapRuler.distance(p.x, p.y, cx, cy);
                if (dist <= rad || !(dist > dmax)) continue;
                dmax = dist;
                i_max = i;
            }
            if (i_max < 0) break;
            double dd = 0.5 * (1.0 - rad / dmax);
            Point p = this.points.get(i_max);
            cx += (int)(dd * (double)(p.x - cx) + 0.5);
            cy += (int)(dd * (double)(p.y - cy) + 0.5);
            dmax = rad = CheapRuler.distance(p.x, p.y, cx, cy);
            i_max = -1;
        }
        this.ilon = cx;
        this.ilat = cy;
        this.radius = rad;
    }

    public boolean intersects(int lon0, int lat0, int lon1, int lat1) {
        int i;
        Point p0 = new Point(lon0, lat0);
        Point p1 = new Point(lon1, lat1);
        int i_last = this.points.size() - 1;
        Point p2 = this.points.get(this.isClosed ? i_last : 0);
        int n = i = this.isClosed ? 0 : 1;
        while (i <= i_last) {
            Point p3 = this.points.get(i);
            if (OsmNogoPolygon.intersect2D_2Segments(p0, p1, p2, p3) > 0) {
                return true;
            }
            p2 = p3;
            ++i;
        }
        return false;
    }

    public boolean isOnPolyline(long px, long py) {
        int i_last = this.points.size() - 1;
        Point p1 = this.points.get(0);
        for (int i = 1; i <= i_last; ++i) {
            Point p2 = this.points.get(i);
            if (OsmNogoPolygon.isOnLine(px, py, p1.x, p1.y, p2.x, p2.y)) {
                return true;
            }
            p1 = p2;
        }
        return false;
    }

    public static boolean isOnLine(long px, long py, long p0x, long p0y, long p1x, long p1y) {
        double v10x = px - p0x;
        double v10y = py - p0y;
        double v12x = p1x - p0x;
        double v12y = p1y - p0y;
        if (v10x == 0.0) {
            if (v10y == 0.0) {
                return true;
            }
            if (v12x != 0.0) {
                return false;
            }
            return v12y / v10y >= 1.0;
        }
        if (v10y == 0.0) {
            if (v12y != 0.0) {
                return false;
            }
            return v12x / v10x >= 1.0;
        }
        double kx = v12x / v10x;
        if (kx < 1.0) {
            return false;
        }
        return kx == v12y / v10y;
    }

    public boolean isWithin(long px, long py) {
        int i;
        int wn = 0;
        int i_last = this.points.size() - 1;
        Point p0 = this.points.get(this.isClosed ? i_last : 0);
        long p0x = p0.x;
        long p0y = p0.y;
        int n = i = this.isClosed ? 0 : 1;
        while (i <= i_last) {
            Point p1 = this.points.get(i);
            long p1x = p1.x;
            long p1y = p1.y;
            if (OsmNogoPolygon.isOnLine(px, py, p0x, p0y, p1x, p1y)) {
                return true;
            }
            if (p0y <= py) {
                if (p1y > py && (p1x - p0x) * (py - p0y) - (px - p0x) * (p1y - p0y) > 0L) {
                    ++wn;
                }
            } else if (p1y <= py && (p1x - p0x) * (py - p0y) - (px - p0x) * (p1y - p0y) < 0L) {
                --wn;
            }
            p0x = p1x;
            p0y = p1y;
            ++i;
        }
        return wn != 0;
    }

    public double distanceWithinPolygon(int lon1, int lat1, int lon2, int lat2) {
        int j;
        double distance = 0.0;
        Point p1 = new Point(lon1, lat1);
        Point p2 = new Point(lon2, lat2);
        Point previousIntersectionOnSegment = null;
        if (this.isWithin(lon1, lat1)) {
            previousIntersectionOnSegment = p1;
        }
        int i_last = this.points.size() - 1;
        int i = this.isClosed ? 0 : 1;
        int n = j = this.isClosed ? i_last : 0;
        while (i <= i_last) {
            Point edgePoint1 = this.points.get(j);
            Point edgePoint2 = this.points.get(i);
            int intersectsEdge = OsmNogoPolygon.intersect2D_2Segments(p1, p2, edgePoint1, edgePoint2);
            if (this.isClosed && intersectsEdge == 1) {
                int xdiffSegment = lon1 - lon2;
                int xdiffEdge = edgePoint1.x - edgePoint2.x;
                int ydiffSegment = lat1 - lat2;
                int ydiffEdge = edgePoint1.y - edgePoint2.y;
                int div = xdiffSegment * ydiffEdge - xdiffEdge * ydiffSegment;
                long dSegment = (long)lon1 * (long)lat2 - (long)lon2 * (long)lat1;
                long dEdge = (long)edgePoint1.x * (long)edgePoint2.y - (long)edgePoint2.x * (long)edgePoint1.y;
                Point intersection = new Point((int)((dSegment * (long)xdiffEdge - dEdge * (long)xdiffSegment) / (long)div), (int)((dSegment * (long)ydiffEdge - dEdge * (long)ydiffSegment) / (long)div));
                if (previousIntersectionOnSegment != null && this.isWithin(intersection.x + previousIntersectionOnSegment.x >> 1, intersection.y + previousIntersectionOnSegment.y >> 1)) {
                    distance += CheapRuler.distance(previousIntersectionOnSegment.x, previousIntersectionOnSegment.y, intersection.x, intersection.y);
                }
                previousIntersectionOnSegment = intersection;
            } else if (intersectsEdge == 2) {
                distance += Math.min(CheapRuler.distance(p1.x, p1.y, p2.x, p2.y), Math.min(CheapRuler.distance(edgePoint1.x, edgePoint1.y, edgePoint2.x, edgePoint2.y), Math.min(CheapRuler.distance(p1.x, p1.y, edgePoint2.x, edgePoint2.y), CheapRuler.distance(edgePoint1.x, edgePoint1.y, p2.x, p2.y))));
                previousIntersectionOnSegment = null;
            }
            j = i++;
        }
        if (previousIntersectionOnSegment != null && this.isWithin(lon2, lat2)) {
            distance += CheapRuler.distance(previousIntersectionOnSegment.x, previousIntersectionOnSegment.y, lon2, lat2);
        }
        return distance;
    }

    private static boolean inSegment(Point p, Point seg_p0, Point seg_p1) {
        int sp0x = seg_p0.x;
        int sp1x = seg_p1.x;
        if (sp0x != sp1x) {
            int px = p.x;
            if (sp0x <= px && px <= sp1x) {
                return true;
            }
            if (sp0x >= px && px >= sp1x) {
                return true;
            }
        } else {
            int sp0y = seg_p0.y;
            int sp1y = seg_p1.y;
            int py = p.y;
            if (sp0y <= py && py <= sp1y) {
                return true;
            }
            if (sp0y >= py && py >= sp1y) {
                return true;
            }
        }
        return false;
    }

    private static int intersect2D_2Segments(Point s1p0, Point s1p1, Point s2p0, Point s2p1) {
        long ux = s1p1.x - s1p0.x;
        long uy = s1p1.y - s1p0.y;
        long vx = s2p1.x - s2p0.x;
        long vy = s2p1.y - s2p0.y;
        long wx = s1p0.x - s2p0.x;
        long wy = s1p0.y - s2p0.y;
        double d = ux * vy - uy * vx;
        if (d == 0.0) {
            double t1;
            double t0;
            boolean dv;
            if (ux * wy - uy * wx != 0L || vx * wy - vy * wx != 0L) {
                return 0;
            }
            boolean du = ux == 0L && uy == 0L;
            boolean bl = dv = vx == 0L && vy == 0L;
            if (du && dv) {
                return wx == 0L && wy == 0L ? 0 : 1;
            }
            if (du) {
                return OsmNogoPolygon.inSegment(s1p0, s2p0, s2p1) ? 1 : 0;
            }
            if (dv) {
                return OsmNogoPolygon.inSegment(s2p0, s1p0, s1p1) ? 1 : 0;
            }
            int w2x = s1p1.x - s2p0.x;
            int w2y = s1p1.y - s2p0.y;
            if (vx != 0L) {
                t0 = wx / vx;
                t1 = (long)w2x / vx;
            } else {
                t0 = wy / vy;
                t1 = (long)w2y / vy;
            }
            if (t0 > t1) {
                double t = t0;
                t0 = t1;
                t1 = t;
            }
            if (t0 > 1.0 || t1 < 0.0) {
                return 0;
            }
            t0 = t0 < 0.0 ? 0.0 : t0;
            t1 = t1 > 1.0 ? 1.0 : t1;
            return t0 == t1 ? 1 : 2;
        }
        double sI = (double)(vx * wy - vy * wx) / d;
        if (sI < 0.0 || sI > 1.0) {
            return 0;
        }
        double tI = (double)(ux * wy - uy * wx) / d;
        return tI < 0.0 || tI > 1.0 ? 0 : 1;
    }

    public static final class Point {
        public final int y;
        public final int x;

        Point(int lon, int lat) {
            this.x = lon;
            this.y = lat;
        }
    }
}

