/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.util.LongList;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class WayData
extends MapCreatorBase {
    public long wid;
    public byte[] description;
    public LongList nodes;

    public WayData(long id) {
        this.wid = id;
        this.nodes = new LongList(16);
    }

    public WayData(long id, LongList nodes) {
        this.wid = id;
        this.nodes = nodes;
    }

    public WayData(DataInputStream di) throws Exception {
        long nid;
        this.nodes = new LongList(16);
        this.wid = WayData.readId(di);
        byte dlen = di.readByte();
        this.description = new byte[dlen];
        di.readFully(this.description);
        while ((nid = WayData.readId(di)) != -1L) {
            this.nodes.add(nid);
        }
    }

    public void writeTo(DataOutputStream dos) throws Exception {
        WayData.writeId(dos, this.wid);
        dos.writeByte(this.description.length);
        dos.write(this.description);
        int size = this.nodes.size();
        for (int i = 0; i < size; ++i) {
            WayData.writeId(dos, this.nodes.get(i));
        }
        WayData.writeId(dos, -1L);
    }
}

