/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNode;
import btools.util.ByteArrayUnifier;
import java.util.ArrayList;
import java.util.HashMap;

public final class OsmNodesMap {
    private HashMap<OsmNode, OsmNode> hmap = new HashMap(4096);
    private ByteArrayUnifier abUnifier = new ByteArrayUnifier(16384, false);
    private OsmNode testKey = new OsmNode();
    public int nodesCreated;
    public long maxmem;
    private long currentmaxmem = 4000000L;
    public int lastVisitID = 1000;
    public int baseID = 1000;
    public OsmNode destination;
    public int currentPathCost;
    public int currentMaxCost = 1000000000;
    public OsmNode endNode1;
    public OsmNode endNode2;
    public int cleanupMode = 0;
    private ArrayList<OsmNode> nodes2check;

    public void cleanupAndCount(OsmNode[] nodes) {
        if (this.cleanupMode == 0) {
            this.justCount(nodes);
        } else {
            this.cleanupPeninsulas(nodes);
        }
    }

    private void justCount(OsmNode[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            OsmNode n = nodes[i];
            if (n.firstlink == null) continue;
            ++this.nodesCreated;
        }
    }

    private void cleanupPeninsulas(OsmNode[] nodes) {
        this.baseID = this.lastVisitID++;
        for (int i = 0; i < nodes.length; ++i) {
            OsmNode n = nodes[i];
            if (n.firstlink == null || n.visitID != 1) continue;
            try {
                this.minVisitIdInSubtree(null, n);
                continue;
            }
            catch (StackOverflowError soe) {
                // empty catch block
            }
        }
    }

    private int minVisitIdInSubtree(OsmNode source, OsmNode n) {
        n.visitID = n.visitID == 1 ? this.baseID : this.lastVisitID++;
        int minId = n.visitID;
        ++this.nodesCreated;
        OsmLink nextLink = null;
        OsmLink l = n.firstlink;
        while (l != null) {
            block8: {
                int minIdSub;
                block10: {
                    block11: {
                        OsmNode t;
                        block9: {
                            nextLink = l.getNext(n);
                            t = l.getTarget(n);
                            if (t == source || t.isHollow()) break block8;
                            minIdSub = t.visitID;
                            if (minIdSub != 1) break block9;
                            minIdSub = this.baseID;
                            break block10;
                        }
                        if (minIdSub != 0) break block11;
                        int nodesCreatedUntilHere = this.nodesCreated;
                        minIdSub = this.minVisitIdInSubtree(n, t);
                        if (minIdSub > n.visitID) {
                            this.nodesCreated = nodesCreatedUntilHere;
                            n.unlinkLink(l);
                            t.unlinkLink(l);
                        }
                        break block10;
                    }
                    if (minIdSub < this.baseID) break block8;
                    if (this.cleanupMode == 2) {
                        minIdSub = this.baseID;
                    }
                }
                if (minIdSub < minId) {
                    minId = minIdSub;
                }
            }
            l = nextLink;
        }
        return minId;
    }

    public boolean isInMemoryBounds(int npaths, boolean extend) {
        long delta;
        long total = (long)this.nodesCreated * 95L + (long)npaths * 200L;
        if (extend && (delta = (total += 100000L) + 1900000L - this.currentmaxmem) > 0L) {
            this.currentmaxmem += delta;
            if (this.currentmaxmem > this.maxmem) {
                this.currentmaxmem = this.maxmem;
            }
        }
        return total <= this.currentmaxmem;
    }

    private void addActiveNode(ArrayList<OsmNode> nodes2check, OsmNode n) {
        n.visitID = this.lastVisitID;
        ++this.nodesCreated;
        nodes2check.add(n);
    }

    public boolean canEscape(OsmNode n0) {
        OsmNode t;
        OsmLink l;
        OsmNode n;
        boolean sawLowIDs = false;
        ++this.lastVisitID;
        this.nodes2check.clear();
        this.nodes2check.add(n0);
        while (!this.nodes2check.isEmpty()) {
            n = this.nodes2check.remove(this.nodes2check.size() - 1);
            if (n.visitID < this.baseID) {
                n.visitID = this.lastVisitID;
                ++this.nodesCreated;
                for (l = n.firstlink; l != null; l = l.getNext(n)) {
                    t = l.getTarget(n);
                    this.nodes2check.add(t);
                }
                continue;
            }
            if (n.visitID >= this.lastVisitID) continue;
            sawLowIDs = true;
        }
        if (sawLowIDs) {
            return true;
        }
        this.nodes2check.add(n0);
        while (!this.nodes2check.isEmpty()) {
            n = this.nodes2check.remove(this.nodes2check.size() - 1);
            if (n.visitID != this.lastVisitID) continue;
            n.visitID = this.lastVisitID;
            --this.nodesCreated;
            for (l = n.firstlink; l != null; l = l.getNext(n)) {
                t = l.getTarget(n);
                this.nodes2check.add(t);
            }
            n.vanish();
        }
        return false;
    }

    public void clearTemp() {
        this.nodes2check = null;
    }

    public void collectOutreachers() {
        this.nodes2check = new ArrayList(this.nodesCreated);
        this.nodesCreated = 0;
        for (OsmNode n : this.hmap.values()) {
            this.addActiveNode(this.nodes2check, n);
        }
        ++this.lastVisitID;
        this.baseID = this.lastVisitID;
        while (!this.nodes2check.isEmpty()) {
            int distance;
            OsmNode n = this.nodes2check.remove(this.nodes2check.size() - 1);
            n.visitID = this.lastVisitID;
            for (OsmLink l = n.firstlink; l != null; l = l.getNext(n)) {
                OsmNode t = l.getTarget(n);
                if (t.visitID == this.lastVisitID) continue;
                this.addActiveNode(this.nodes2check, t);
            }
            if (this.destination != null && this.currentMaxCost < 1000000000 && (distance = n.calcDistance(this.destination)) > this.currentMaxCost - this.currentPathCost + 100) {
                n.vanish();
            }
            if (n.firstlink != null) continue;
            --this.nodesCreated;
        }
    }

    public ByteArrayUnifier getByteArrayUnifier() {
        return this.abUnifier;
    }

    public OsmNode get(int ilon, int ilat) {
        this.testKey.ilon = ilon;
        this.testKey.ilat = ilat;
        return this.hmap.get(this.testKey);
    }

    public void remove(OsmNode node) {
        if (node != this.endNode1 && node != this.endNode2) {
            this.hmap.remove(node);
        }
    }

    public OsmNode put(OsmNode node) {
        return this.hmap.put(node, node);
    }

    private static void addLinks(OsmNode[] nodes, int idx, boolean isBorder, int[] links) {
        OsmNode n = nodes[idx];
        n.visitID = isBorder ? 1 : 0;
        n.selev = (short)idx;
        for (int i : links) {
            OsmLink link;
            OsmNode t = nodes[i];
            OsmNode osmNode = n.isLinkUnused() ? n : (link = t.isLinkUnused() ? t : null);
            if (link == null) {
                link = new OsmLink();
            }
            n.addLink(link, false, t);
        }
    }

    public static void main(String[] args) {
        OsmNode[] nodes = new OsmNode[12];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new OsmNode((i + 1000) * 1000, (i + 1000) * 1000);
        }
        OsmNodesMap.addLinks(nodes, 0, true, new int[]{1, 5});
        OsmNodesMap.addLinks(nodes, 1, true, new int[0]);
        OsmNodesMap.addLinks(nodes, 2, false, new int[]{3, 4});
        OsmNodesMap.addLinks(nodes, 3, false, new int[]{4});
        OsmNodesMap.addLinks(nodes, 4, false, new int[0]);
        OsmNodesMap.addLinks(nodes, 5, true, new int[]{6, 9});
        OsmNodesMap.addLinks(nodes, 6, false, new int[]{7, 8});
        OsmNodesMap.addLinks(nodes, 7, false, new int[0]);
        OsmNodesMap.addLinks(nodes, 8, false, new int[0]);
        OsmNodesMap.addLinks(nodes, 9, false, new int[]{10, 11});
        OsmNodesMap.addLinks(nodes, 10, false, new int[]{11});
        OsmNodesMap.addLinks(nodes, 11, false, new int[0]);
        OsmNodesMap nm = new OsmNodesMap();
        nm.cleanupMode = 2;
        nm.cleanupAndCount(nodes);
        System.out.println("nodesCreated=" + nm.nodesCreated);
        nm.cleanupAndCount(nodes);
        System.out.println("nodesCreated=" + nm.nodesCreated);
    }
}

