/*
 * Decompiled with CFR 0.152.
 */
package btools.codec;

import btools.codec.DataBuffers;
import btools.codec.IntegerFifo3Pass;
import btools.codec.LinkedListContainer;
import btools.codec.MicroCache;
import btools.codec.NoisyDiffCoder;
import btools.codec.StatCoderContext;
import btools.codec.TagValueCoder;
import btools.codec.TagValueValidator;
import btools.codec.TagValueWrapper;
import btools.codec.WaypointMatcher;
import btools.util.ByteDataReader;
import btools.util.IByteArrayUnifier;
import java.util.HashMap;

public final class MicroCache2
extends MicroCache {
    private int lonBase;
    private int latBase;
    private int cellsize;

    public MicroCache2(int size, byte[] databuffer, int lonIdx, int latIdx, int divisor) throws Exception {
        super(databuffer);
        this.faid = new int[size];
        this.fapos = new int[size];
        this.size = 0;
        this.cellsize = 1000000 / divisor;
        this.lonBase = lonIdx * this.cellsize;
        this.latBase = latIdx * this.cellsize;
    }

    public byte[] readUnified(int len, IByteArrayUnifier u) {
        byte[] b = u.unify(this.ab, this.aboffset, len);
        this.aboffset += len;
        return b;
    }

    public MicroCache2(StatCoderContext bc, DataBuffers dataBuffers, int lonIdx, int latIdx, int divisor, TagValueValidator wayValidator, WaypointMatcher waypointMatcher) throws Exception {
        super(null);
        int[] alat;
        this.cellsize = 1000000 / divisor;
        this.lonBase = lonIdx * this.cellsize;
        this.latBase = latIdx * this.cellsize;
        TagValueCoder wayTagCoder = new TagValueCoder(bc, dataBuffers, wayValidator);
        TagValueCoder nodeTagCoder = new TagValueCoder(bc, dataBuffers, null);
        NoisyDiffCoder nodeIdxDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder nodeEleDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder extLonDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder extLatDiff = new NoisyDiffCoder(bc);
        NoisyDiffCoder transEleDiff = new NoisyDiffCoder(bc);
        this.size = bc.decodeNoisyNumber(5);
        this.faid = this.size > dataBuffers.ibuf2.length ? new int[this.size] : dataBuffers.ibuf2;
        this.fapos = this.size > dataBuffers.ibuf3.length ? new int[this.size] : dataBuffers.ibuf3;
        int[] alon = this.size > dataBuffers.alon.length ? new int[this.size] : dataBuffers.alon;
        int[] nArray = alat = this.size > dataBuffers.alat.length ? new int[this.size] : dataBuffers.alat;
        if (debug) {
            System.out.println("*** decoding cache of size=" + this.size + " for lonIdx=" + lonIdx + " latIdx=" + latIdx);
        }
        bc.decodeSortedArray(this.faid, 0, this.size, 29, 0);
        for (int n = 0; n < this.size; ++n) {
            long id64 = this.expandId(this.faid[n]);
            alon[n] = (int)(id64 >> 32);
            alat[n] = (int)(id64 & 0xFFFFFFFFFFFFFFFFL);
        }
        int netdatasize = bc.decodeNoisyNumber(10);
        this.ab = netdatasize > dataBuffers.bbuf1.length ? new byte[netdatasize] : dataBuffers.bbuf1;
        this.aboffset = 0;
        int[] validBits = new int[this.size + 31 >> 5];
        int finaldatasize = 0;
        LinkedListContainer reverseLinks = new LinkedListContainer(this.size, dataBuffers.ibuf1);
        int selev = 0;
        for (int n = 0; n < this.size; ++n) {
            int featureId;
            int ilon = alon[n];
            int ilat = alat[n];
            short trExceptions = 0;
            while ((featureId = bc.decodeVarBits()) != 0) {
                int bitsize = bc.decodeNoisyNumber(5);
                if (featureId == 2) {
                    trExceptions = (short)bc.decodeBounded(1023);
                    continue;
                }
                if (featureId == 1) {
                    this.writeBoolean(true);
                    this.writeShort(trExceptions);
                    trExceptions = 0;
                    this.writeBoolean(bc.decodeBit());
                    this.writeInt(ilon + bc.decodeNoisyDiff(10));
                    this.writeInt(ilat + bc.decodeNoisyDiff(10));
                    this.writeInt(ilon + bc.decodeNoisyDiff(10));
                    this.writeInt(ilat + bc.decodeNoisyDiff(10));
                    continue;
                }
                for (int i = 0; i < bitsize; ++i) {
                    bc.decodeBit();
                }
            }
            this.writeBoolean(false);
            this.writeShort((short)(selev += nodeEleDiff.decodeSignedValue()));
            TagValueWrapper nodeTags = nodeTagCoder.decodeTagValueSet();
            this.writeVarBytes(nodeTags == null ? null : nodeTags.data);
            int links = bc.decodeNoisyNumber(1);
            if (debug) {
                System.out.println("***   decoding node " + ilon + "/" + ilat + " with links=" + links);
            }
            for (int li = 0; li < links; ++li) {
                TagValueWrapper wayTags;
                int dlat_remaining;
                int dlon_remaining;
                int sizeoffset = 0;
                int nodeIdx = n + nodeIdxDiff.decodeSignedValue();
                boolean isReverse = false;
                if (nodeIdx != n) {
                    dlon_remaining = alon[nodeIdx] - ilon;
                    dlat_remaining = alat[nodeIdx] - ilat;
                } else {
                    isReverse = bc.decodeBit();
                    dlon_remaining = extLonDiff.decodeSignedValue();
                    dlat_remaining = extLatDiff.decodeSignedValue();
                }
                if (debug) {
                    System.out.println("***     decoding link to " + (ilon + dlon_remaining) + "/" + (ilat + dlat_remaining) + " extern=" + (nodeIdx == n));
                }
                if ((wayTags = wayTagCoder.decodeTagValueSet()) != null) {
                    int startPointer = this.aboffset;
                    sizeoffset = this.writeSizePlaceHolder();
                    this.writeVarLengthSigned(dlon_remaining);
                    this.writeVarLengthSigned(dlat_remaining);
                    int n2 = n >> 5;
                    validBits[n2] = validBits[n2] | 1 << n;
                    if (nodeIdx != n) {
                        reverseLinks.addDataElement(nodeIdx, n);
                        finaldatasize += 1 + this.aboffset - startPointer;
                        int n3 = nodeIdx >> 5;
                        validBits[n3] = validBits[n3] | 1 << nodeIdx;
                    }
                    this.writeModeAndDesc(isReverse, wayTags.data);
                }
                if (!isReverse) {
                    WaypointMatcher matcher = wayTags == null || wayTags.accessType < 2 ? null : waypointMatcher;
                    int ilontarget = ilon + dlon_remaining;
                    int ilattarget = ilat + dlat_remaining;
                    if (matcher != null && !matcher.start(ilon, ilat, ilontarget, ilattarget)) {
                        matcher = null;
                    }
                    int transcount = bc.decodeVarBits();
                    if (debug) {
                        System.out.println("***       decoding geometry with count=" + transcount);
                    }
                    int count = transcount + 1;
                    for (int i = 0; i < transcount; ++i) {
                        int dlon = bc.decodePredictedValue(dlon_remaining / count);
                        int dlat = bc.decodePredictedValue(dlat_remaining / count);
                        dlon_remaining -= dlon;
                        dlat_remaining -= dlat;
                        --count;
                        int elediff = transEleDiff.decodeSignedValue();
                        if (wayTags != null) {
                            this.writeVarLengthSigned(dlon);
                            this.writeVarLengthSigned(dlat);
                            this.writeVarLengthSigned(elediff);
                        }
                        if (matcher == null) continue;
                        matcher.transferNode(ilontarget - dlon_remaining, ilattarget - dlat_remaining);
                    }
                    if (matcher != null) {
                        matcher.end();
                    }
                }
                if (wayTags == null) continue;
                this.injectSize(sizeoffset);
            }
            this.fapos[n] = this.aboffset;
        }
        int finalsize = 0;
        int startpos = 0;
        for (int i = 0; i < this.size; ++i) {
            int endpos = this.fapos[i];
            if ((validBits[i >> 5] & 1 << i) != 0) {
                finaldatasize += endpos - startpos;
                ++finalsize;
            }
            startpos = endpos;
        }
        byte[] abOld = this.ab;
        int[] faidOld = this.faid;
        int[] faposOld = this.fapos;
        int sizeOld = this.size;
        this.ab = new byte[finaldatasize];
        this.faid = new int[finalsize];
        this.fapos = new int[finalsize];
        this.aboffset = 0;
        this.size = 0;
        startpos = 0;
        for (int n = 0; n < sizeOld; ++n) {
            int endpos = faposOld[n];
            if ((validBits[n >> 5] & 1 << n) != 0) {
                int len = endpos - startpos;
                System.arraycopy(abOld, startpos, this.ab, this.aboffset, len);
                if (debug) {
                    System.out.println("*** copied " + len + " bytes from " + this.aboffset + " for node " + n);
                }
                this.aboffset += len;
                int cnt = reverseLinks.initList(n);
                if (debug) {
                    System.out.println("*** appending " + cnt + " reverse links for node " + n);
                }
                for (int ri = 0; ri < cnt; ++ri) {
                    int nodeIdx = reverseLinks.getDataElement();
                    int sizeoffset = this.writeSizePlaceHolder();
                    this.writeVarLengthSigned(alon[nodeIdx] - alon[n]);
                    this.writeVarLengthSigned(alat[nodeIdx] - alat[n]);
                    this.writeModeAndDesc(true, null);
                    this.injectSize(sizeoffset);
                }
                this.faid[this.size] = faidOld[n];
                this.fapos[this.size] = this.aboffset;
                ++this.size;
            }
            startpos = endpos;
        }
        this.init(this.size);
    }

    @Override
    public long expandId(int id32) {
        int dlon = 0;
        int dlat = 0;
        for (int bm = 1; bm < 32768; bm <<= 1) {
            if ((id32 & 1) != 0) {
                dlon |= bm;
            }
            if ((id32 & 2) != 0) {
                dlat |= bm;
            }
            id32 >>= 2;
        }
        int lon32 = this.lonBase + dlon;
        int lat32 = this.latBase + dlat;
        return (long)lon32 << 32 | (long)lat32;
    }

    @Override
    public int shrinkId(long id64) {
        int lon32 = (int)(id64 >> 32);
        int lat32 = (int)(id64 & 0xFFFFFFFFFFFFFFFFL);
        int dlon = lon32 - this.lonBase;
        int dlat = lat32 - this.latBase;
        int id32 = 0;
        for (int bm = 16384; bm > 0; bm >>= 1) {
            id32 <<= 2;
            if ((dlon & bm) != 0) {
                id32 |= 1;
            }
            if ((dlat & bm) == 0) continue;
            id32 |= 2;
        }
        return id32;
    }

    @Override
    public boolean isInternal(int ilon, int ilat) {
        return ilon >= this.lonBase && ilon < this.lonBase + this.cellsize && ilat >= this.latBase && ilat < this.latBase + this.cellsize;
    }

    @Override
    public int encodeMicroCache(byte[] buffer) {
        HashMap<Long, Integer> idMap = new HashMap<Long, Integer>();
        for (int n = 0; n < this.size; ++n) {
            idMap.put(this.expandId(this.faid[n]), n);
        }
        IntegerFifo3Pass linkCounts = new IntegerFifo3Pass(256);
        IntegerFifo3Pass transCounts = new IntegerFifo3Pass(256);
        IntegerFifo3Pass restrictionBits = new IntegerFifo3Pass(16);
        TagValueCoder wayTagCoder = new TagValueCoder();
        TagValueCoder nodeTagCoder = new TagValueCoder();
        NoisyDiffCoder nodeIdxDiff = new NoisyDiffCoder();
        NoisyDiffCoder nodeEleDiff = new NoisyDiffCoder();
        NoisyDiffCoder extLonDiff = new NoisyDiffCoder();
        NoisyDiffCoder extLatDiff = new NoisyDiffCoder();
        NoisyDiffCoder transEleDiff = new NoisyDiffCoder();
        int netdatasize = 0;
        int pass = 1;
        while (true) {
            boolean dodebug;
            boolean dostats = pass == 3;
            boolean bl = dodebug = debug && pass == 3;
            if (pass < 3) {
                netdatasize = this.fapos[this.size - 1];
            }
            StatCoderContext bc = new StatCoderContext(buffer);
            linkCounts.init();
            transCounts.init();
            restrictionBits.init();
            wayTagCoder.encodeDictionary(bc);
            if (dostats) {
                bc.assignBits("wayTagDictionary");
            }
            nodeTagCoder.encodeDictionary(bc);
            if (dostats) {
                bc.assignBits("nodeTagDictionary");
            }
            nodeIdxDiff.encodeDictionary(bc);
            nodeEleDiff.encodeDictionary(bc);
            extLonDiff.encodeDictionary(bc);
            extLatDiff.encodeDictionary(bc);
            transEleDiff.encodeDictionary(bc);
            if (dostats) {
                bc.assignBits("noisebits");
            }
            bc.encodeNoisyNumber(this.size, 5);
            if (dostats) {
                bc.assignBits("nodecount");
            }
            bc.encodeSortedArray(this.faid, 0, this.size, 0x20000000, 0);
            if (dostats) {
                bc.assignBits("node-positions");
            }
            bc.encodeNoisyNumber(netdatasize, 10);
            if (dostats) {
                bc.assignBits("netdatasize");
            }
            if (dodebug) {
                System.out.println("*** encoding cache of size=" + this.size);
            }
            short lastSelev = 0;
            for (int n = 0; n < this.size; ++n) {
                this.aboffset = this.startPos(n);
                this.aboffsetEnd = this.fapos[n];
                if (dodebug) {
                    System.out.println("*** encoding node " + n + " from " + this.aboffset + " to " + this.aboffsetEnd);
                }
                long id64 = this.expandId(this.faid[n]);
                int ilon = (int)(id64 >> 32);
                int ilat = (int)(id64 & 0xFFFFFFFFFFFFFFFFL);
                while (this.readBoolean()) {
                    short exceptions = this.readShort();
                    if (exceptions != 0) {
                        bc.encodeVarBits(2);
                        bc.encodeNoisyNumber(10, 5);
                        bc.encodeBounded(1023, exceptions & 0x3FF);
                    }
                    bc.encodeVarBits(1);
                    bc.encodeNoisyNumber(restrictionBits.getNext(), 5);
                    long b0 = bc.getWritingBitPosition();
                    bc.encodeBit(this.readBoolean());
                    bc.encodeNoisyDiff(this.readInt() - ilon, 10);
                    bc.encodeNoisyDiff(this.readInt() - ilat, 10);
                    bc.encodeNoisyDiff(this.readInt() - ilon, 10);
                    bc.encodeNoisyDiff(this.readInt() - ilat, 10);
                    restrictionBits.add((int)((long)bc.getWritingBitPosition() - b0));
                }
                bc.encodeVarBits(0);
                if (dostats) {
                    bc.assignBits("extradata");
                }
                short selev = this.readShort();
                nodeEleDiff.encodeSignedValue(selev - lastSelev);
                if (dostats) {
                    bc.assignBits("nodeele");
                }
                lastSelev = selev;
                nodeTagCoder.encodeTagValueSet(this.readVarBytes());
                if (dostats) {
                    bc.assignBits("nodeTagIdx");
                }
                int nlinks = linkCounts.getNext();
                if (dodebug) {
                    System.out.println("*** nlinks=" + nlinks);
                }
                bc.encodeNoisyNumber(nlinks, 1);
                if (dostats) {
                    bc.assignBits("link-counts");
                }
                nlinks = 0;
                while (this.hasMoreData()) {
                    int startPointer = this.aboffset;
                    int endPointer = this.getEndPointer();
                    int ilonlink = ilon + this.readVarLengthSigned();
                    int ilatlink = ilat + this.readVarLengthSigned();
                    int sizecode = this.readVarLengthUnsigned();
                    boolean isReverse = (sizecode & 1) != 0;
                    int descSize = sizecode >> 1;
                    byte[] description = null;
                    if (descSize > 0) {
                        description = new byte[descSize];
                        this.readFully(description);
                    }
                    boolean isInternal = this.isInternal(ilonlink, ilatlink);
                    if (isReverse && isInternal) {
                        if (dodebug) {
                            System.out.println("*** NOT encoding link reverse=" + isReverse + " internal=" + isInternal);
                        }
                        netdatasize -= this.aboffset - startPointer;
                        continue;
                    }
                    if (dodebug) {
                        System.out.println("*** encoding link reverse=" + isReverse + " internal=" + isInternal);
                    }
                    ++nlinks;
                    if (isInternal) {
                        long link64 = (long)ilonlink << 32 | (long)ilatlink;
                        Integer idx = (Integer)idMap.get(link64);
                        if (idx == null) {
                            throw new RuntimeException("ups: internal not found?");
                        }
                        int nodeIdx = idx;
                        if (dodebug) {
                            System.out.println("*** target nodeIdx=" + nodeIdx);
                        }
                        if (nodeIdx == n) {
                            throw new RuntimeException("ups: self ref?");
                        }
                        nodeIdxDiff.encodeSignedValue(nodeIdx - n);
                        if (dostats) {
                            bc.assignBits("nodeIdx");
                        }
                    } else {
                        nodeIdxDiff.encodeSignedValue(0);
                        bc.encodeBit(isReverse);
                        extLonDiff.encodeSignedValue(ilonlink - ilon);
                        extLatDiff.encodeSignedValue(ilatlink - ilat);
                        if (dostats) {
                            bc.assignBits("externalNode");
                        }
                    }
                    wayTagCoder.encodeTagValueSet(description);
                    if (dostats) {
                        bc.assignBits("wayDescIdx");
                    }
                    if (isReverse) continue;
                    byte[] geometry = this.readDataUntil(endPointer);
                    int count = transCounts.getNext();
                    if (dodebug) {
                        System.out.println("*** encoding geometry with count=" + count);
                    }
                    bc.encodeVarBits(count++);
                    if (dostats) {
                        bc.assignBits("transcount");
                    }
                    int transcount = 0;
                    if (geometry != null) {
                        int dlon_remaining = ilonlink - ilon;
                        int dlat_remaining = ilatlink - ilat;
                        ByteDataReader r = new ByteDataReader(geometry);
                        while (r.hasMoreData()) {
                            ++transcount;
                            int dlon = r.readVarLengthSigned();
                            int dlat = r.readVarLengthSigned();
                            bc.encodePredictedValue(dlon, dlon_remaining / count);
                            bc.encodePredictedValue(dlat, dlat_remaining / count);
                            dlon_remaining -= dlon;
                            dlat_remaining -= dlat;
                            if (count > 1) {
                                --count;
                            }
                            if (dostats) {
                                bc.assignBits("transpos");
                            }
                            transEleDiff.encodeSignedValue(r.readVarLengthSigned());
                            if (!dostats) continue;
                            bc.assignBits("transele");
                        }
                    }
                    transCounts.add(transcount);
                }
                linkCounts.add(nlinks);
            }
            if (pass == 3) {
                return bc.closeAndGetEncodedLength();
            }
            ++pass;
        }
    }
}

