/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class StackSampler
extends Thread {
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", new Locale("en", "US"));
    private BufferedWriter bw;
    private Random rand = new Random();
    private int interval;
    private int flushCnt = 0;
    private volatile boolean stopped;

    public StackSampler(File logfile, int interval) {
        this.interval = interval;
        try {
            this.bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(logfile, true)));
        }
        catch (Exception e) {
            this.printError("StackSampler: " + e.getMessage());
        }
    }

    protected void printError(String msg) {
        System.out.println(msg);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            this.dumpThreads();
        }
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dumpThreads() {
        try {
            int wait1 = this.rand.nextInt(this.interval);
            int wait2 = this.interval - wait1;
            Thread.sleep(wait1);
            StringBuilder sb = new StringBuilder(this.df.format(new Date()) + " THREADDUMP\n");
            Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> e : allThreads.entrySet()) {
                StackTraceElement[] stack;
                Thread t = e.getKey();
                if (t == Thread.currentThread() || !this.matchesFilter(stack = e.getValue())) continue;
                sb.append(" (ID=").append(t.getId()).append(" \"").append(t.getName()).append("\" ").append((Object)t.getState()).append("\n");
                for (StackTraceElement line : stack) {
                    sb.append("    ").append(line.toString()).append("\n");
                }
                sb.append("\n");
            }
            this.bw.write(sb.toString());
            if (this.flushCnt++ >= 0) {
                this.flushCnt = 0;
                this.bw.flush();
            }
            Thread.sleep(wait2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        this.stopped = true;
        this.interrupt();
    }

    private boolean matchesFilter(StackTraceElement[] stack) {
        boolean positiveMatch = false;
        for (StackTraceElement e : stack) {
            String s = e.toString();
            if (s.indexOf("btools") >= 0) {
                positiveMatch = true;
            }
            if (s.indexOf("Thread.sleep") < 0 && s.indexOf("PlainSocketImpl.socketAccept") < 0) continue;
            return false;
        }
        return positiveMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("StackSampler...");
        Class<?> clazz = Class.forName(args[0]);
        String[] args2 = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            args2[i - 1] = args[i];
        }
        StackSampler t = new StackSampler(new File("stacks.log"), 1000);
        t.start();
        try {
            clazz.getMethod("main", String[].class).invoke(null, new Object[]{args2});
        }
        finally {
            t.close();
        }
    }
}

