/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.mapaccess.GeometryDecoder;
import btools.mapaccess.OsmLink;
import btools.router.OsmNodeNamed;
import btools.router.OsmNogoPolygon;
import btools.router.OsmPath;
import btools.router.OsmPathModel;
import btools.router.OsmPrePath;
import btools.router.OsmTrack;
import btools.router.StdModel;
import btools.util.CheapAngleMeter;
import btools.util.CheapRuler;
import java.io.DataOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class RoutingContext {
    public int alternativeIdx = 0;
    public String localFunction;
    public long profileTimestamp;
    public Map<String, String> keyValues;
    public String rawTrackPath;
    public BExpressionContextWay expctxWay;
    public BExpressionContextNode expctxNode;
    public GeometryDecoder geometryDecoder = new GeometryDecoder();
    public int memoryclass = 64;
    public int downhillcostdiv;
    public int downhillcutoff;
    public int uphillcostdiv;
    public int uphillcutoff;
    public boolean carMode;
    public boolean bikeMode;
    public boolean footMode;
    public boolean considerTurnRestrictions;
    public boolean processUnusedTags;
    public boolean forceSecondaryData;
    public double pass1coefficient;
    public double pass2coefficient;
    public int elevationpenaltybuffer;
    public int elevationmaxbuffer;
    public int elevationbufferreduce;
    public double cost1speed;
    public double additionalcostfactor;
    public double changetime;
    public double buffertime;
    public double waittimeadjustment;
    public double inittimeadjustment;
    public double starttimeoffset;
    public boolean transitonly;
    public List<OsmNodeNamed> nogopoints = null;
    private List<OsmNodeNamed> keepnogopoints = null;
    public Integer startDirection;
    public boolean startDirectionValid;
    public boolean forceUseStartDirection;
    public CheapAngleMeter anglemeter = new CheapAngleMeter();
    public double nogoCost = 0.0;
    public boolean isEndpoint = false;
    public boolean shortestmatch = false;
    public double wayfraction;
    public int ilatshortest;
    public int ilonshortest;
    public boolean countTraffic;
    public boolean inverseDirection;
    public DataOutput trafficOutputStream;
    public double farTrafficWeight;
    public double nearTrafficWeight;
    public double farTrafficDecayLength;
    public double nearTrafficDecayLength;
    public double trafficDirectionFactor;
    public double trafficSourceExponent;
    public double trafficSourceMinDist;
    public boolean showspeed;
    public boolean inverseRouting;
    public OsmPrePath firstPrePath;
    public int turnInstructionMode;
    public double turnInstructionCatchingRange;
    public boolean turnInstructionRoundabouts;
    public double totalMass;
    public double maxSpeed;
    public double S_C_x;
    public double defaultC_r;
    public double bikerPower;
    public OsmPathModel pm;

    public void setAlternativeIdx(int idx) {
        this.alternativeIdx = idx;
    }

    public int getAlternativeIdx(int min, int max) {
        return this.alternativeIdx < min ? min : (this.alternativeIdx > max ? max : this.alternativeIdx);
    }

    public String getProfileName() {
        int idx;
        String name;
        String string = name = this.localFunction == null ? "unknown" : this.localFunction;
        if (name.endsWith(".brf")) {
            name = name.substring(0, this.localFunction.length() - 4);
        }
        if ((idx = name.lastIndexOf(File.separatorChar)) >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    private void setModel(String className) {
        if (className == null) {
            this.pm = new StdModel();
        } else {
            try {
                Class<?> clazz = Class.forName(className);
                this.pm = (OsmPathModel)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create path-model: " + e);
            }
        }
        this.initModel();
    }

    public void initModel() {
        this.pm.init(this.expctxWay, this.expctxNode, this.keyValues);
    }

    public long getKeyValueChecksum() {
        long s = 0L;
        if (this.keyValues != null) {
            for (Map.Entry<String, String> e : this.keyValues.entrySet()) {
                s += (long)(e.getKey().hashCode() + e.getValue().hashCode());
            }
        }
        return s;
    }

    public void readGlobalConfig() {
        BExpressionContextWay expctxGlobal = this.expctxWay;
        this.setModel(expctxGlobal._modelClass);
        this.downhillcostdiv = (int)expctxGlobal.getVariableValue("downhillcost", 0.0f);
        this.downhillcutoff = (int)(expctxGlobal.getVariableValue("downhillcutoff", 0.0f) * 10000.0f);
        this.uphillcostdiv = (int)expctxGlobal.getVariableValue("uphillcost", 0.0f);
        this.uphillcutoff = (int)(expctxGlobal.getVariableValue("uphillcutoff", 0.0f) * 10000.0f);
        if (this.downhillcostdiv != 0) {
            this.downhillcostdiv = 1000000 / this.downhillcostdiv;
        }
        if (this.uphillcostdiv != 0) {
            this.uphillcostdiv = 1000000 / this.uphillcostdiv;
        }
        this.carMode = 0.0f != expctxGlobal.getVariableValue("validForCars", 0.0f);
        this.bikeMode = 0.0f != expctxGlobal.getVariableValue("validForBikes", 0.0f);
        this.footMode = 0.0f != expctxGlobal.getVariableValue("validForFoot", 0.0f);
        this.considerTurnRestrictions = 0.0f != expctxGlobal.getVariableValue("considerTurnRestrictions", this.carMode ? 1.0f : 0.0f);
        this.processUnusedTags = 0.0f != expctxGlobal.getVariableValue("processUnusedTags", 0.0f);
        this.forceSecondaryData = 0.0f != expctxGlobal.getVariableValue("forceSecondaryData", 0.0f);
        this.pass1coefficient = expctxGlobal.getVariableValue("pass1coefficient", 1.5f);
        this.pass2coefficient = expctxGlobal.getVariableValue("pass2coefficient", 0.0f);
        this.elevationpenaltybuffer = (int)(expctxGlobal.getVariableValue("elevationpenaltybuffer", 5.0f) * 1000000.0f);
        this.elevationmaxbuffer = (int)(expctxGlobal.getVariableValue("elevationmaxbuffer", 10.0f) * 1000000.0f);
        this.elevationbufferreduce = (int)(expctxGlobal.getVariableValue("elevationbufferreduce", 0.0f) * 10000.0f);
        this.cost1speed = expctxGlobal.getVariableValue("cost1speed", 22.0f);
        this.additionalcostfactor = expctxGlobal.getVariableValue("additionalcostfactor", 1.5f);
        this.changetime = expctxGlobal.getVariableValue("changetime", 180.0f);
        this.buffertime = expctxGlobal.getVariableValue("buffertime", 120.0f);
        this.waittimeadjustment = expctxGlobal.getVariableValue("waittimeadjustment", 0.9f);
        this.inittimeadjustment = expctxGlobal.getVariableValue("inittimeadjustment", 0.2f);
        this.starttimeoffset = expctxGlobal.getVariableValue("starttimeoffset", 0.0f);
        this.transitonly = expctxGlobal.getVariableValue("transitonly", 0.0f) != 0.0f;
        this.farTrafficWeight = expctxGlobal.getVariableValue("farTrafficWeight", 2.0f);
        this.nearTrafficWeight = expctxGlobal.getVariableValue("nearTrafficWeight", 2.0f);
        this.farTrafficDecayLength = expctxGlobal.getVariableValue("farTrafficDecayLength", 30000.0f);
        this.nearTrafficDecayLength = expctxGlobal.getVariableValue("nearTrafficDecayLength", 3000.0f);
        this.trafficDirectionFactor = expctxGlobal.getVariableValue("trafficDirectionFactor", 0.9f);
        this.trafficSourceExponent = expctxGlobal.getVariableValue("trafficSourceExponent", -0.7f);
        this.trafficSourceMinDist = expctxGlobal.getVariableValue("trafficSourceMinDist", 3000.0f);
        this.showspeed = 0.0f != expctxGlobal.getVariableValue("showspeed", 0.0f);
        this.inverseRouting = 0.0f != expctxGlobal.getVariableValue("inverseRouting", 0.0f);
        int tiMode = (int)expctxGlobal.getVariableValue("turnInstructionMode", 0.0f);
        if (tiMode != 1) {
            this.turnInstructionMode = tiMode;
        }
        this.turnInstructionCatchingRange = expctxGlobal.getVariableValue("turnInstructionCatchingRange", 40.0f);
        this.turnInstructionRoundabouts = expctxGlobal.getVariableValue("turnInstructionRoundabouts", 1.0f) != 0.0f;
        this.totalMass = expctxGlobal.getVariableValue("totalMass", 90.0f);
        this.maxSpeed = (double)expctxGlobal.getVariableValue("maxSpeed", 45.0f) / 3.6;
        this.S_C_x = expctxGlobal.getVariableValue("S_C_x", 0.225f);
        this.defaultC_r = expctxGlobal.getVariableValue("C_r", 0.01f);
        this.bikerPower = expctxGlobal.getVariableValue("bikerPower", 100.0f);
    }

    public static void prepareNogoPoints(List<OsmNodeNamed> nogos) {
        for (OsmNodeNamed nogo : nogos) {
            if (nogo instanceof OsmNogoPolygon) continue;
            String s = nogo.name;
            int idx = s.indexOf(32);
            if (idx > 0) {
                s = s.substring(0, idx);
            }
            int ir = 20;
            if (s.length() > 4) {
                try {
                    ir = Integer.parseInt(s.substring(4));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            nogo.radius = ir;
        }
    }

    public void cleanNogolist(List<OsmNodeNamed> waypoints) {
        if (this.nogopoints == null) {
            return;
        }
        ArrayList<OsmNodeNamed> nogos = new ArrayList<OsmNodeNamed>();
        for (OsmNodeNamed nogo : this.nogopoints) {
            boolean goodGuy = true;
            for (OsmNodeNamed wp : waypoints) {
                if (!((double)wp.calcDistance(nogo) < nogo.radius) || nogo instanceof OsmNogoPolygon && !(((OsmNogoPolygon)nogo).isClosed ? ((OsmNogoPolygon)nogo).isWithin(wp.ilon, wp.ilat) : ((OsmNogoPolygon)nogo).isOnPolyline(wp.ilon, wp.ilat))) continue;
                goodGuy = false;
                break;
            }
            if (!goodGuy) continue;
            nogos.add(nogo);
        }
        this.nogopoints = nogos.isEmpty() ? null : nogos;
    }

    public long[] getNogoChecksums() {
        long[] cs = new long[3];
        int n = this.nogopoints == null ? 0 : this.nogopoints.size();
        for (int i = 0; i < n; ++i) {
            OsmNodeNamed nogo = this.nogopoints.get(i);
            cs[0] = cs[0] + (long)nogo.ilon;
            cs[1] = cs[1] + (long)nogo.ilat;
            cs[2] = cs[2] + (long)(nogo.radius * 10.0);
        }
        return cs;
    }

    public void setWaypoint(OsmNodeNamed wp, boolean endpoint) {
        this.keepnogopoints = this.nogopoints;
        this.nogopoints = new ArrayList<OsmNodeNamed>();
        this.nogopoints.add(wp);
        if (this.keepnogopoints != null) {
            this.nogopoints.addAll(this.keepnogopoints);
        }
        this.isEndpoint = endpoint;
    }

    public void unsetWaypoint() {
        this.nogopoints = this.keepnogopoints;
        this.isEndpoint = false;
    }

    public int calcDistance(int lon1, int lat1, int lon2, int lat2) {
        double[] lonlat2m = CheapRuler.getLonLatToMeterScales(lat1 + lat2 >> 1);
        double dlon2m = lonlat2m[0];
        double dlat2m = lonlat2m[1];
        double dx = (double)(lon2 - lon1) * dlon2m;
        double dy = (double)(lat2 - lat1) * dlat2m;
        double d = Math.sqrt(dy * dy + dx * dx);
        this.shortestmatch = false;
        if (this.nogopoints != null && !this.nogopoints.isEmpty() && d > 0.0) {
            for (int ngidx = 0; ngidx < this.nogopoints.size(); ++ngidx) {
                OsmNodeNamed nogo = this.nogopoints.get(ngidx);
                double x1 = (double)(lon1 - nogo.ilon) * dlon2m;
                double y1 = (double)(lat1 - nogo.ilat) * dlat2m;
                double r12 = x1 * x1 + y1 * y1;
                double x2 = (double)(lon2 - nogo.ilon) * dlon2m;
                double y2 = (double)(lat2 - nogo.ilat) * dlat2m;
                double r22 = x2 * x2 + y2 * y2;
                double radius = Math.abs(r12 < r22 ? y1 * dx - x1 * dy : y2 * dx - x2 * dy) / d;
                if (!(radius < nogo.radius)) continue;
                double s1 = x1 * dx + y1 * dy;
                double s2 = x2 * dx + y2 * dy;
                if (s1 < 0.0) {
                    s1 = -s1;
                    s2 = -s2;
                }
                if (s2 > 0.0 && (radius = Math.sqrt(s1 < s2 ? r12 : r22)) > nogo.radius) continue;
                if (nogo.isNogo) {
                    if (!(nogo instanceof OsmNogoPolygon)) {
                        if (Double.isNaN(nogo.nogoWeight)) {
                            this.nogoCost = -1.0;
                            continue;
                        }
                        this.nogoCost = nogo.distanceWithinRadius(lon1, lat1, lon2, lat2, d) * nogo.nogoWeight;
                        continue;
                    }
                    if (!((OsmNogoPolygon)nogo).intersects(lon1, lat1, lon2, lat2)) continue;
                    if (Double.isNaN(nogo.nogoWeight)) {
                        this.nogoCost = -1.0;
                        continue;
                    }
                    if (((OsmNogoPolygon)nogo).isClosed) {
                        this.nogoCost = ((OsmNogoPolygon)nogo).distanceWithinPolygon(lon1, lat1, lon2, lat2) * nogo.nogoWeight;
                        continue;
                    }
                    this.nogoCost = nogo.nogoWeight;
                    continue;
                }
                this.shortestmatch = true;
                nogo.radius = radius;
                if (s2 < 0.0) {
                    this.wayfraction = -s2 / (d * d);
                    double xm = x2 - this.wayfraction * dx;
                    double ym = y2 - this.wayfraction * dy;
                    this.ilonshortest = (int)(xm / dlon2m + (double)nogo.ilon);
                    this.ilatshortest = (int)(ym / dlat2m + (double)nogo.ilat);
                } else if (s1 > s2) {
                    this.wayfraction = 0.0;
                    this.ilonshortest = lon2;
                    this.ilatshortest = lat2;
                } else {
                    this.wayfraction = 1.0;
                    this.ilonshortest = lon1;
                    this.ilatshortest = lat1;
                }
                if (this.isEndpoint) {
                    this.wayfraction = 1.0 - this.wayfraction;
                    lon2 = this.ilonshortest;
                    lat2 = this.ilatshortest;
                } else {
                    this.nogoCost = 0.0;
                    lon1 = this.ilonshortest;
                    lat1 = this.ilatshortest;
                }
                dx = (double)(lon2 - lon1) * dlon2m;
                dy = (double)(lat2 - lat1) * dlat2m;
                d = Math.sqrt(dy * dy + dx * dx);
            }
        }
        return (int)(d + 1.0);
    }

    public OsmPrePath createPrePath(OsmPath origin, OsmLink link) {
        OsmPrePath p = this.pm.createPrePath();
        if (p != null) {
            p.init(origin, link, this);
        }
        return p;
    }

    public OsmPath createPath(OsmLink link) {
        OsmPath p = this.pm.createPath();
        p.init(link);
        return p;
    }

    public OsmPath createPath(OsmPath origin, OsmLink link, OsmTrack refTrack, boolean detailMode) {
        OsmPath p = this.pm.createPath();
        p.init(origin, link, refTrack, detailMode, this);
        return p;
    }
}

