/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.OsmLinkHolder;
import btools.mapaccess.OsmNode;

public class OsmLink {
    public byte[] descriptionBitmap;
    public byte[] geometry;
    protected OsmNode n1;
    protected OsmNode n2;
    protected OsmLink previous;
    protected OsmLink next;
    private OsmLinkHolder reverselinkholder = null;
    private OsmLinkHolder firstlinkholder = null;

    protected OsmLink() {
    }

    public OsmLink(OsmNode source, OsmNode target) {
        this.n1 = source;
        this.n2 = target;
    }

    public final OsmNode getTarget(OsmNode source) {
        return this.n2 != source && this.n2 != null ? this.n2 : this.n1;
    }

    public final OsmLink getNext(OsmNode source) {
        return this.n2 != source && this.n2 != null ? this.next : this.previous;
    }

    protected final OsmLink clear(OsmNode source) {
        OsmLink n;
        if (this.n2 != null && this.n2 != source) {
            n = this.next;
            this.next = null;
            this.n2 = null;
            this.firstlinkholder = null;
        } else if (this.n1 != null && this.n1 != source) {
            n = this.previous;
            this.previous = null;
            this.n1 = null;
            this.reverselinkholder = null;
        } else {
            throw new IllegalArgumentException("internal error: setNext: unknown source");
        }
        if (this.n1 == null && this.n2 == null) {
            this.descriptionBitmap = null;
            this.geometry = null;
        }
        return n;
    }

    public final void setFirstLinkHolder(OsmLinkHolder holder, OsmNode source) {
        if (this.n2 != null && this.n2 != source) {
            this.firstlinkholder = holder;
        } else if (this.n1 != null && this.n1 != source) {
            this.reverselinkholder = holder;
        } else {
            throw new IllegalArgumentException("internal error: setFirstLinkHolder: unknown source");
        }
    }

    public final OsmLinkHolder getFirstLinkHolder(OsmNode source) {
        if (this.n2 != null && this.n2 != source) {
            return this.firstlinkholder;
        }
        if (this.n1 != null && this.n1 != source) {
            return this.reverselinkholder;
        }
        throw new IllegalArgumentException("internal error: getFirstLinkHolder: unknown source");
    }

    public final boolean isReverse(OsmNode source) {
        return this.n1 != source && this.n1 != null;
    }

    public final boolean isBidirectional() {
        return this.n1 != null && this.n2 != null;
    }

    public final boolean isLinkUnused() {
        return this.n1 == null && this.n2 == null;
    }

    public final void addLinkHolder(OsmLinkHolder holder, OsmNode source) {
        OsmLinkHolder firstHolder = this.getFirstLinkHolder(source);
        if (firstHolder != null) {
            holder.setNextForLink(firstHolder);
        }
        this.setFirstLinkHolder(holder, source);
    }
}

