/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmNode;

public final class SearchBoundary {
    private int minlon0;
    private int minlat0;
    private int maxlon0;
    private int maxlat0;
    private int minlon;
    private int minlat;
    private int maxlon;
    private int maxlat;
    private int radius;
    private OsmNode p;
    int direction;

    public SearchBoundary(OsmNode n, int radius, int direction) {
        this.radius = radius;
        this.direction = direction;
        this.p = new OsmNode(n.ilon, n.ilat);
        int lon = n.ilon / 5000000 * 5000000;
        int lat = n.ilat / 5000000 * 5000000;
        this.minlon0 = lon - 5000000;
        this.minlat0 = lat - 5000000;
        this.maxlon0 = lon + 10000000;
        this.maxlat0 = lat + 10000000;
        this.minlon = lon - 1000000;
        this.minlat = lat - 1000000;
        this.maxlon = lon + 6000000;
        this.maxlat = lat + 6000000;
    }

    public static String getFileName(OsmNode n) {
        int lon = n.ilon / 5000000 * 5000000;
        int lat = n.ilat / 5000000 * 5000000;
        int dlon = lon / 1000000 - 180;
        int dlat = lat / 1000000 - 90;
        String slon = dlon < 0 ? "W" + -dlon : "E" + dlon;
        String slat = dlat < 0 ? "S" + -dlat : "N" + dlat;
        return slon + "_" + slat + ".trf";
    }

    public boolean isInBoundary(OsmNode n, int cost) {
        if (this.radius > 0) {
            return n.calcDistance(this.p) < this.radius;
        }
        if (cost == 0) {
            return n.ilon > this.minlon0 && n.ilon < this.maxlon0 && n.ilat > this.minlat0 && n.ilat < this.maxlat0;
        }
        return n.ilon > this.minlon && n.ilon < this.maxlon && n.ilat > this.minlat && n.ilat < this.maxlat;
    }

    public int getBoundaryDistance(OsmNode n) {
        switch (this.direction) {
            case 0: {
                return n.calcDistance(new OsmNode(n.ilon, this.minlat));
            }
            case 1: {
                return n.calcDistance(new OsmNode(this.minlon, n.ilat));
            }
            case 2: {
                return n.calcDistance(new OsmNode(n.ilon, this.maxlat));
            }
            case 3: {
                return n.calcDistance(new OsmNode(this.maxlon, n.ilat));
            }
        }
        throw new IllegalArgumentException("undefined direction: " + this.direction);
    }
}

