/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.MatchedWaypoint;
import btools.mapaccess.OsmPos;
import btools.router.MessageData;
import btools.router.OsmNodeNamed;
import btools.router.OsmPathElement;
import btools.router.RoutingContext;
import btools.router.VoiceHint;
import btools.router.VoiceHintList;
import btools.router.VoiceHintProcessor;
import btools.util.CompactLongMap;
import btools.util.FrozenLongMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public final class OsmTrack {
    private static final String MESSAGES_HEADER = "Longitude\tLatitude\tElevation\tDistance\tCostPerKm\tElevCost\tTurnCost\tNodeCost\tInitialCost\tWayTags\tNodeTags";
    public MatchedWaypoint endPoint;
    public long[] nogoChecksums;
    public long profileTimestamp;
    public boolean isDirty;
    public boolean showspeed;
    public ArrayList<OsmPathElement> nodes = new ArrayList();
    private CompactLongMap<OsmPathElementHolder> nodesMap;
    private CompactLongMap<OsmPathElementHolder> detourMap;
    private VoiceHintList voiceHints;
    private boolean sendSpeedProfile;
    public String message = null;
    public ArrayList<String> messageList = null;
    public String name = "unset";
    public int distance;
    public int ascend;
    public int plainAscend;
    public int cost;
    public int energy;
    public List<String> iternity;

    public void addNode(OsmPathElement node) {
        this.nodes.add(0, node);
    }

    public void registerDetourForId(long id, OsmPathElement detour) {
        if (this.detourMap == null) {
            this.detourMap = new CompactLongMap();
        }
        OsmPathElementHolder nh = new OsmPathElementHolder();
        nh.node = detour;
        OsmPathElementHolder h = this.detourMap.get(id);
        if (h != null) {
            while (h.nextHolder != null) {
                h = h.nextHolder;
            }
            h.nextHolder = nh;
        } else {
            this.detourMap.fastPut(id, nh);
        }
    }

    public void copyDetours(OsmTrack source) {
        this.detourMap = source.detourMap == null ? null : new FrozenLongMap<OsmPathElementHolder>(source.detourMap);
    }

    public void buildMap() {
        this.nodesMap = new CompactLongMap();
        for (OsmPathElement node : this.nodes) {
            long id = node.getIdFromPos();
            OsmPathElementHolder nh = new OsmPathElementHolder();
            nh.node = node;
            OsmPathElementHolder h = this.nodesMap.get(id);
            if (h != null) {
                while (h.nextHolder != null) {
                    h = h.nextHolder;
                }
                h.nextHolder = nh;
                continue;
            }
            this.nodesMap.fastPut(id, nh);
        }
        this.nodesMap = new FrozenLongMap<OsmPathElementHolder>(this.nodesMap);
    }

    private ArrayList<String> aggregateMessages() {
        ArrayList<String> res = new ArrayList<String>();
        MessageData current = null;
        for (OsmPathElement n : this.nodes) {
            if (n.message == null || n.message.wayKeyValues == null) continue;
            MessageData md = n.message.copy();
            if (current != null) {
                if (current.nodeKeyValues != null || !current.wayKeyValues.equals(md.wayKeyValues)) {
                    res.add(current.toMessage());
                } else {
                    md.add(current);
                }
            }
            current = md;
        }
        if (current != null) {
            res.add(current.toMessage());
        }
        return res;
    }

    private ArrayList<String> aggregateSpeedProfile() {
        ArrayList<String> res = new ArrayList<String>();
        int vmax = -1;
        int vmaxe = -1;
        int vmin = -1;
        int extraTime = 0;
        for (int i = this.nodes.size() - 1; i > 0; --i) {
            OsmPathElement n = this.nodes.get(i);
            MessageData m = n.message;
            int vnode = this.getVNode(i);
            if (m == null || vmax == m.vmax && vmin == m.vmin && vmaxe == m.vmaxExplicit && vnode >= m.vmax && extraTime == m.extraTime) continue;
            vmax = m.vmax;
            vmin = m.vmin;
            vmaxe = m.vmaxExplicit;
            extraTime = m.extraTime;
            res.add(i + "," + vmaxe + "," + vmax + "," + vmin + "," + vnode + "," + extraTime);
        }
        return res;
    }

    public void writeBinary(String filename) throws Exception {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.endPoint.writeToStream(dos);
        dos.writeInt(this.nodes.size());
        for (OsmPathElement node : this.nodes) {
            node.writeToStream(dos);
        }
        dos.writeLong(this.nogoChecksums[0]);
        dos.writeLong(this.nogoChecksums[1]);
        dos.writeLong(this.nogoChecksums[2]);
        dos.writeBoolean(this.isDirty);
        dos.writeLong(this.profileTimestamp);
        dos.close();
    }

    public static OsmTrack readBinary(String filename, OsmNodeNamed newEp, long[] nogoChecksums, long profileChecksum, StringBuilder debugInfo) {
        File f;
        OsmTrack t = null;
        if (filename != null && (f = new File(filename)).exists()) {
            try {
                boolean targetMatch;
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                MatchedWaypoint ep = MatchedWaypoint.readFromStream(dis);
                int dlon = ep.waypoint.ilon - newEp.ilon;
                int dlat = ep.waypoint.ilat - newEp.ilat;
                boolean bl = targetMatch = dlon < 20 && dlon > -20 && dlat < 20 && dlat > -20;
                if (debugInfo != null) {
                    debugInfo.append("target-delta = " + dlon + "/" + dlat + " targetMatch=" + targetMatch);
                }
                if (targetMatch) {
                    boolean profileCheckOk;
                    t = new OsmTrack();
                    t.endPoint = ep;
                    int n = dis.readInt();
                    OsmPathElement last_pe = null;
                    for (int i = 0; i < n; ++i) {
                        OsmPathElement pe = OsmPathElement.readFromStream(dis);
                        pe.origin = last_pe;
                        last_pe = pe;
                        t.nodes.add(pe);
                    }
                    t.cost = last_pe.cost;
                    t.buildMap();
                    long[] al = new long[3];
                    long pchecksum = 0L;
                    try {
                        al[0] = dis.readLong();
                        al[1] = dis.readLong();
                        al[2] = dis.readLong();
                    }
                    catch (EOFException eof) {
                        // empty catch block
                    }
                    try {
                        t.isDirty = dis.readBoolean();
                    }
                    catch (EOFException eof) {
                        // empty catch block
                    }
                    try {
                        pchecksum = dis.readLong();
                    }
                    catch (EOFException eof) {
                        // empty catch block
                    }
                    boolean nogoCheckOk = Math.abs(al[0] - nogoChecksums[0]) <= 20L && Math.abs(al[1] - nogoChecksums[1]) <= 20L && Math.abs(al[2] - nogoChecksums[2]) <= 20L;
                    boolean bl2 = profileCheckOk = pchecksum == profileChecksum;
                    if (debugInfo != null) {
                        debugInfo.append(" nogoCheckOk=" + nogoCheckOk + " profileCheckOk=" + profileCheckOk);
                        debugInfo.append(" al=" + OsmTrack.formatLongs(al) + " nogoChecksums=" + OsmTrack.formatLongs(nogoChecksums));
                    }
                    if (!nogoCheckOk || !profileCheckOk) {
                        return null;
                    }
                }
                dis.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception reading rawTrack: " + e);
            }
        }
        return t;
    }

    private static String formatLongs(long[] al) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (long l : al) {
            sb.append(l);
            sb.append(' ');
        }
        sb.append('}');
        return sb.toString();
    }

    public void addNodes(OsmTrack t) {
        for (OsmPathElement n : t.nodes) {
            this.addNode(n);
        }
        this.buildMap();
    }

    public boolean containsNode(OsmPos node) {
        return this.nodesMap.contains(node.getIdFromPos());
    }

    public OsmPathElement getLink(long n1, long n2) {
        OsmPathElementHolder h = this.nodesMap.get(n2);
        while (h != null) {
            OsmPathElement e1 = h.node.origin;
            if (e1 != null && e1.getIdFromPos() == n1) {
                return h.node;
            }
            h = h.nextHolder;
        }
        return null;
    }

    public void appendTrack(OsmTrack t) {
        int ourSize = this.nodes.size();
        float t0 = ourSize > 0 ? this.nodes.get(ourSize - 1).getTime() : 0.0f;
        float e0 = ourSize > 0 ? this.nodes.get(ourSize - 1).getEnergy() : 0.0f;
        for (int i = 0; i < t.nodes.size(); ++i) {
            if (i <= 0 && ourSize != 0) continue;
            OsmPathElement e = t.nodes.get(i);
            e.setTime(e.getTime() + t0);
            e.setEnergy(e.getEnergy() + e0);
            this.nodes.add(e);
        }
        if (t.voiceHints != null) {
            if (ourSize > 0) {
                for (VoiceHint hint : t.voiceHints.list) {
                    hint.indexInTrack = hint.indexInTrack + ourSize - 1;
                }
            }
            if (this.voiceHints == null) {
                this.voiceHints = t.voiceHints;
            } else {
                this.voiceHints.list.addAll(t.voiceHints.list);
            }
        }
        this.distance += t.distance;
        this.ascend += t.ascend;
        this.plainAscend += t.plainAscend;
        this.cost += t.cost;
        this.energy += t.energy;
        this.showspeed |= t.showspeed;
        this.sendSpeedProfile |= t.sendSpeedProfile;
    }

    public void writeGpx(String filename) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        this.formatAsGpx(bw);
        bw.close();
    }

    public String formatAsGpx() {
        try {
            StringWriter sw = new StringWriter(8192);
            BufferedWriter bw = new BufferedWriter(sw);
            this.formatAsGpx(bw);
            bw.close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String formatAsGpx(BufferedWriter sb) throws IOException {
        double t;
        float rteTime;
        int turnInstructionMode = this.voiceHints != null ? this.voiceHints.turnInstructionMode : 0;
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        for (int i = this.messageList.size() - 1; i >= 0; --i) {
            String message = this.messageList.get(i);
            if (i < this.messageList.size() - 1) {
                message = "(alt-index " + i + ": " + message + " )";
            }
            if (message == null) continue;
            sb.append("<!-- ").append(message).append(" -->\n");
        }
        if (turnInstructionMode == 4) {
            sb.append("<!-- $transport-mode$").append(this.voiceHints.getTransportMode()).append("$ -->\n");
            sb.append("<!--          cmd    idx        lon        lat d2next  geometry -->\n");
            sb.append("<!-- $turn-instruction-start$\n");
            for (VoiceHint hint : this.voiceHints.list) {
                sb.append(String.format("     $turn$%6s;%6d;%10s;%10s;%6d;%s$\n", hint.getCommandString(), hint.indexInTrack, OsmTrack.formatILon(hint.ilon), OsmTrack.formatILat(hint.ilat), (int)hint.distanceToNext, hint.formatGeometry()));
            }
            sb.append("    $turn-instruction-end$ -->\n");
        }
        sb.append("<gpx \n");
        sb.append(" xmlns=\"http://www.topografix.com/GPX/1/1\" \n");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        if (turnInstructionMode == 2) {
            sb.append(" xmlns:locus=\"http://www.locusmap.eu\" \n");
        }
        sb.append(" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\" \n");
        if (turnInstructionMode == 3) {
            sb.append(" creator=\"OsmAndRouter\" version=\"1.1\">\n");
        } else {
            sb.append(" creator=\"BRouter-1.5.3\" version=\"1.1\">\n");
        }
        if (turnInstructionMode == 3) {
            float lastRteTime = this.voiceHints.list.get(0).getTime();
            sb.append(" <rte>\n");
            for (int i = 0; i < this.voiceHints.list.size(); ++i) {
                VoiceHint hint = this.voiceHints.list.get(i);
                sb.append("  <rtept lat=\"").append(OsmTrack.formatILat(hint.ilat)).append("\" lon=\"").append(OsmTrack.formatILon(hint.ilon)).append("\">\n").append("   <desc>").append(hint.getMessageString()).append("</desc>\n   <extensions>\n");
                rteTime = i < this.voiceHints.list.size() - 1 ? this.voiceHints.list.get(i + 1).getTime() : this.nodes.get(this.nodes.size() - 1).getTime();
                if (rteTime != lastRteTime) {
                    t = rteTime - lastRteTime;
                    sb.append("    <time>").append("" + (int)(t + 0.5)).append("</time>\n");
                    lastRteTime = rteTime;
                }
                sb.append("    <turn>").append(hint.getCommandString()).append("</turn>\n    <turn-angle>").append("" + (int)hint.angle).append("</turn-angle>\n    <offset>").append("" + hint.indexInTrack).append("</offset>\n  </extensions>\n </rtept>\n");
            }
            sb.append("</rte>\n");
        }
        if (turnInstructionMode == 2) {
            float lastRteTime = 0.0f;
            for (VoiceHint hint : this.voiceHints.list) {
                sb.append(" <wpt lon=\"").append(OsmTrack.formatILon(hint.ilon)).append("\" lat=\"").append(OsmTrack.formatILat(hint.ilat)).append("\">").append(hint.selev == Short.MIN_VALUE ? "" : "<ele>" + (double)hint.selev / 4.0 + "</ele>").append("<name>").append(hint.getMessageString()).append("</name>").append("<extensions><locus:rteDistance>").append("" + hint.distanceToNext).append("</locus:rteDistance>");
                rteTime = hint.getTime();
                if (rteTime != lastRteTime) {
                    t = rteTime - lastRteTime;
                    double speed = hint.distanceToNext / t;
                    sb.append("<locus:rteTime>").append("" + t).append("</locus:rteTime>").append("<locus:rteSpeed>").append("" + speed).append("</locus:rteSpeed>");
                    lastRteTime = rteTime;
                }
                sb.append("<locus:rtePointAction>").append("" + hint.getLocusAction()).append("</locus:rtePointAction></extensions>").append("</wpt>\n");
            }
        }
        if (turnInstructionMode == 5) {
            for (VoiceHint hint : this.voiceHints.list) {
                sb.append(" <wpt lon=\"").append(OsmTrack.formatILon(hint.ilon)).append("\" lat=\"").append(OsmTrack.formatILat(hint.ilat)).append("\">").append("<name>").append(hint.getMessageString()).append("</name>").append("<sym>").append(hint.getSymbolString().toLowerCase()).append("</sym>").append("<type>").append(hint.getSymbolString()).append("</type>").append("</wpt>\n");
            }
        }
        sb.append(" <trk>\n");
        sb.append("  <name>").append(this.name).append("</name>\n");
        if (turnInstructionMode == 1) {
            sb.append("  <type>").append(this.voiceHints.getTransportMode()).append("</type>\n");
        }
        if (turnInstructionMode == 2) {
            sb.append("  <extensions><locus:rteComputeType>").append("" + this.voiceHints.getLocusRouteType()).append("</locus:rteComputeType></extensions>\n");
            sb.append("  <extensions><locus:rteSimpleRoundabouts>1</locus:rteSimpleRoundabouts></extensions>\n");
        }
        sb.append("  <trkseg>\n");
        for (int idx = 0; idx < this.nodes.size(); ++idx) {
            String sele;
            OsmPathElement n = this.nodes.get(idx);
            String string = sele = n.getSElev() == Short.MIN_VALUE ? "" : "<ele>" + n.getElev() + "</ele>";
            if (turnInstructionMode == 1) {
                for (VoiceHint hint : this.voiceHints.list) {
                    if (hint.indexInTrack != idx) continue;
                    sele = sele + "<sym>" + hint.getCommandString() + "</sym>";
                }
            }
            sb.append("   <trkpt lon=\"").append(OsmTrack.formatILon(n.getILon())).append("\" lat=\"").append(OsmTrack.formatILat(n.getILat())).append("\">").append(sele).append("</trkpt>\n");
        }
        sb.append("  </trkseg>\n");
        sb.append(" </trk>\n");
        sb.append("</gpx>\n");
        return sb.toString();
    }

    public void writeKml(String filename) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.write(this.formatAsKml());
        bw.close();
    }

    public String formatAsKml() {
        StringBuilder sb = new StringBuilder(8192);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        sb.append("  <Document>\n");
        sb.append("    <name>KML Samples</name>\n");
        sb.append("    <open>1</open>\n");
        sb.append("    <distance>3.497064</distance>\n");
        sb.append("    <traveltime>872</traveltime>\n");
        sb.append("    <description>To enable simple instructions add: 'instructions=1' as parameter to the URL</description>\n");
        sb.append("    <Folder>\n");
        sb.append("      <name>Paths</name>\n");
        sb.append("      <visibility>0</visibility>\n");
        sb.append("      <description>Examples of paths.</description>\n");
        sb.append("      <Placemark>\n");
        sb.append("        <name>Tessellated</name>\n");
        sb.append("        <visibility>0</visibility>\n");
        sb.append("        <description><![CDATA[If the <tessellate> tag has a value of 1, the line will contour to the underlying terrain]]></description>\n");
        sb.append("        <LineString>\n");
        sb.append("          <tessellate>1</tessellate>\n");
        sb.append("         <coordinates> ");
        for (OsmPathElement n : this.nodes) {
            sb.append(OsmTrack.formatILon(n.getILon())).append(",").append(OsmTrack.formatILat(n.getILat())).append("\n");
        }
        sb.append("          </coordinates>\n");
        sb.append("        </LineString>\n");
        sb.append("      </Placemark>\n");
        sb.append("    </Folder>\n");
        sb.append("  </Document>\n");
        sb.append("</kml>\n");
        return sb.toString();
    }

    public String formatAsGeoJson() {
        StringBuilder sb = new StringBuilder(8192);
        sb.append("{\n");
        sb.append("  \"type\": \"FeatureCollection\",\n");
        sb.append("  \"features\": [\n");
        sb.append("    {\n");
        sb.append("      \"type\": \"Feature\",\n");
        sb.append("      \"properties\": {\n");
        sb.append("        \"creator\": \"BRouter-1.1\",\n");
        sb.append("        \"name\": \"").append(this.name).append("\",\n");
        sb.append("        \"track-length\": \"").append(this.distance).append("\",\n");
        sb.append("        \"filtered ascend\": \"").append(this.ascend).append("\",\n");
        sb.append("        \"plain-ascend\": \"").append(this.plainAscend).append("\",\n");
        sb.append("        \"total-time\": \"").append(this.getTotalSeconds()).append("\",\n");
        sb.append("        \"total-energy\": \"").append(this.energy).append("\",\n");
        sb.append("        \"cost\": \"").append(this.cost).append("\",\n");
        if (this.voiceHints != null && !this.voiceHints.list.isEmpty()) {
            sb.append("        \"voicehints\": [\n");
            for (VoiceHint hint : this.voiceHints.list) {
                sb.append("          [").append(hint.indexInTrack).append(',').append(hint.getCommand()).append(',').append(hint.getExitNumber()).append("],\n");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append("        ],\n");
        }
        if (this.sendSpeedProfile) {
            ArrayList<String> sp = this.aggregateSpeedProfile();
            if (sp.size() > 0) {
                sb.append("        \"speedprofile\": [\n");
                for (int i = sp.size() - 1; i >= 0; --i) {
                    sb.append("          [").append(sp.get(i)).append(i > 0 ? "],\n" : "]\n");
                }
                sb.append("        ]\n");
            }
        } else {
            sb.append("        \"messages\": [\n");
            sb.append("          [\"").append(MESSAGES_HEADER.replaceAll("\t", "\", \"")).append("\"],\n");
            for (String m : this.aggregateMessages()) {
                sb.append("          [\"").append(m.replaceAll("\t", "\", \"")).append("\"],\n");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append("        ]\n");
        }
        sb.append("      },\n");
        if (this.iternity != null) {
            sb.append("      \"iternity\": [\n");
            for (String s : this.iternity) {
                sb.append("        \"").append(s).append("\",\n");
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            sb.append("        ],\n");
        }
        sb.append("      \"geometry\": {\n");
        sb.append("        \"type\": \"LineString\",\n");
        sb.append("        \"coordinates\": [\n");
        OsmPathElement nn = null;
        for (OsmPathElement n : this.nodes) {
            String sele;
            String string = sele = n.getSElev() == Short.MIN_VALUE ? "" : ", " + n.getElev();
            if (this.showspeed) {
                int speed = 0;
                if (nn != null) {
                    int dist = n.calcDistance(nn);
                    float dt = n.getTime() - nn.getTime();
                    if (dt != 0.0f) {
                        speed = (int)((double)(3.6f * (float)dist / dt) + 0.5);
                    }
                }
                sele = ", " + speed;
            }
            sb.append("          [").append(OsmTrack.formatILon(n.getILon())).append(", ").append(OsmTrack.formatILat(n.getILat())).append(sele).append("],\n");
            nn = n;
        }
        sb.deleteCharAt(sb.lastIndexOf(","));
        sb.append("        ]\n");
        sb.append("      }\n");
        sb.append("    }\n");
        sb.append("  ]\n");
        sb.append("}\n");
        return sb.toString();
    }

    private int getVNode(int i) {
        MessageData m1 = i + 1 < this.nodes.size() ? this.nodes.get((int)(i + 1)).message : null;
        MessageData m0 = i < this.nodes.size() ? this.nodes.get((int)i).message : null;
        int vnode0 = m1 == null ? 999 : m1.vnode0;
        int vnode1 = m0 == null ? 999 : m0.vnode1;
        return vnode0 < vnode1 ? vnode0 : vnode1;
    }

    private int getTotalSeconds() {
        float s = this.nodes.size() < 2 ? 0.0f : this.nodes.get(this.nodes.size() - 1).getTime() - this.nodes.get(0).getTime();
        return (int)((double)s + 0.5);
    }

    public String getFormattedTime() {
        return this.format1((double)this.getTotalSeconds() / 60.0) + "m";
    }

    public String getFormattedTime2() {
        int seconds = (int)((double)this.getTotalSeconds() + 0.5);
        int hours = seconds / 3600;
        int minutes = (seconds - hours * 3600) / 60;
        seconds = seconds - hours * 3600 - minutes * 60;
        String time = "";
        if (hours != 0) {
            time = "" + hours + "h ";
        }
        if (minutes != 0) {
            time = time + minutes + "m ";
        }
        if (seconds != 0) {
            time = time + seconds + "s";
        }
        return time;
    }

    public String getFormattedEnergy() {
        return this.format1((double)this.energy / 3600000.0) + "kwh";
    }

    private static String formatILon(int ilon) {
        return OsmTrack.formatPos(ilon - 180000000);
    }

    private static String formatILat(int ilat) {
        return OsmTrack.formatPos(ilat - 90000000);
    }

    private static String formatPos(int p) {
        boolean negative;
        boolean bl = negative = p < 0;
        if (negative) {
            p = -p;
        }
        char[] ac = new char[12];
        int i = 11;
        while (p != 0 || i > 3) {
            ac[i--] = (char)(48 + p % 10);
            p /= 10;
            if (i != 5) continue;
            ac[i--] = 46;
        }
        if (negative) {
            ac[i--] = 45;
        }
        return new String(ac, i + 1, 11 - i);
    }

    private String format1(double n) {
        String s = "" + (long)(n * 10.0 + 0.5);
        int len = s.length();
        return s.substring(0, len - 1) + "." + s.charAt(len - 1);
    }

    public void dumpMessages(String filename, RoutingContext rc) throws Exception {
        BufferedWriter bw = filename == null ? null : new BufferedWriter(new FileWriter(filename));
        this.writeMessages(bw, rc);
    }

    public void writeMessages(BufferedWriter bw, RoutingContext rc) throws Exception {
        this.dumpLine(bw, MESSAGES_HEADER);
        for (String m : this.aggregateMessages()) {
            this.dumpLine(bw, m);
        }
        if (bw != null) {
            bw.close();
        }
    }

    private void dumpLine(BufferedWriter bw, String s) throws Exception {
        if (bw == null) {
            System.out.println(s);
        } else {
            bw.write(s);
            bw.write("\n");
        }
    }

    public void readGpx(String filename) throws Exception {
        String line;
        File f = new File(filename);
        if (!f.exists()) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        while ((line = br.readLine()) != null) {
            int idx0 = line.indexOf("<trkpt lon=\"");
            if (idx0 < 0) continue;
            int idx1 = line.indexOf(34, idx0 += 12);
            int ilon = (int)((Double.parseDouble(line.substring(idx0, idx1)) + 180.0) * 1000000.0 + 0.5);
            int idx2 = line.indexOf(" lat=\"");
            if (idx2 < 0) continue;
            int idx3 = line.indexOf(34, idx2 += 6);
            int ilat = (int)((Double.parseDouble(line.substring(idx2, idx3)) + 90.0) * 1000000.0 + 0.5);
            this.nodes.add(OsmPathElement.create(ilon, ilat, (short)0, null, false));
        }
        br.close();
    }

    public boolean equalsTrack(OsmTrack t) {
        if (this.nodes.size() != t.nodes.size()) {
            return false;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            OsmPathElement e1 = this.nodes.get(i);
            OsmPathElement e2 = t.nodes.get(i);
            if (e1.getILon() == e2.getILon() && e1.getILat() == e2.getILat()) continue;
            return false;
        }
        return true;
    }

    public void prepareSpeedProfile(RoutingContext rc) {
        this.sendSpeedProfile = rc.keyValues != null && rc.keyValues.containsKey("vmax");
    }

    public void processVoiceHints(RoutingContext rc) {
        this.voiceHints = new VoiceHintList();
        this.voiceHints.setTransportMode(rc.carMode, rc.bikeMode);
        this.voiceHints.turnInstructionMode = rc.turnInstructionMode;
        if (this.detourMap == null) {
            return;
        }
        int nodeNr = this.nodes.size() - 1;
        OsmPathElement node = this.nodes.get(nodeNr);
        ArrayList<VoiceHint> inputs = new ArrayList<VoiceHint>();
        while (node != null) {
            if (node.origin != null) {
                VoiceHint input = new VoiceHint();
                inputs.add(input);
                input.ilat = node.origin.getILat();
                input.ilon = node.origin.getILon();
                input.selev = node.origin.getSElev();
                input.indexInTrack = --nodeNr;
                input.goodWay = node.message;
                input.oldWay = node.origin.message == null ? node.message : node.origin.message;
                OsmPathElementHolder detours = this.detourMap.get(node.origin.getIdFromPos());
                if (detours != null) {
                    OsmPathElementHolder h = detours;
                    while (h != null) {
                        OsmPathElement e = h.node;
                        input.addBadWay(this.startSection(e, node.origin));
                        h = h.nextHolder;
                    }
                }
            }
            node = node.origin;
        }
        VoiceHintProcessor vproc = new VoiceHintProcessor(rc.turnInstructionCatchingRange, rc.turnInstructionRoundabouts);
        List<VoiceHint> results = vproc.process(inputs);
        for (VoiceHint hint : results) {
            this.voiceHints.list.add(hint);
        }
    }

    private MessageData startSection(OsmPathElement element, OsmPathElement root) {
        OsmPathElement e = element;
        int cnt = 0;
        while (e != null && e.origin != null) {
            if (e.origin.getILat() == root.getILat() && e.origin.getILon() == root.getILon()) {
                return e.message;
            }
            e = e.origin;
            if (cnt++ != 1000000) continue;
            throw new IllegalArgumentException("ups: " + root + "->" + element);
        }
        return null;
    }

    private static class OsmPathElementHolder {
        public OsmPathElement node;
        public OsmPathElementHolder nextHolder;

        private OsmPathElementHolder() {
        }
    }
}

