/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.WaypointMatcher;
import btools.mapaccess.MatchedWaypoint;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodePairSet;
import btools.util.CheapRuler;
import java.util.List;

public final class WaypointMatcherImpl
implements WaypointMatcher {
    private List<MatchedWaypoint> waypoints;
    private OsmNodePairSet islandPairs;
    private int lonStart;
    private int latStart;
    private int lonTarget;
    private int latTarget;
    private boolean anyUpdate;
    private int lonLast;
    private int latLast;

    public WaypointMatcherImpl(List<MatchedWaypoint> waypoints, double maxDistance, OsmNodePairSet islandPairs) {
        this.waypoints = waypoints;
        this.islandPairs = islandPairs;
        for (MatchedWaypoint mwp : waypoints) {
            mwp.radius = maxDistance;
        }
    }

    private void checkSegment(int lon1, int lat1, int lon2, int lat2) {
        double dlon2m;
        double dx;
        double[] lonlat2m = CheapRuler.getLonLatToMeterScales(lat1 + lat2 >> 1);
        double dlat2m = lonlat2m[1];
        double dy = (double)(lat2 - lat1) * dlat2m;
        double d = Math.sqrt(dy * dy + (dx = (double)(lon2 - lon1) * (dlon2m = lonlat2m[0])) * dx);
        if (d == 0.0) {
            return;
        }
        for (MatchedWaypoint mwp : this.waypoints) {
            OsmNode wp = mwp.waypoint;
            double x1 = (double)(lon1 - wp.ilon) * dlon2m;
            double y1 = (double)(lat1 - wp.ilat) * dlat2m;
            double r12 = x1 * x1 + y1 * y1;
            double x2 = (double)(lon2 - wp.ilon) * dlon2m;
            double y2 = (double)(lat2 - wp.ilat) * dlat2m;
            double r22 = x2 * x2 + y2 * y2;
            double d2 = r12 < r22 ? y1 * dx - x1 * dy : y2 * dx - x2 * dy;
            double radius = Math.abs(d2) / d;
            if (!(radius < mwp.radius)) continue;
            double s1 = x1 * dx + y1 * dy;
            double s2 = x2 * dx + y2 * dy;
            if (s1 < 0.0) {
                s1 = -s1;
                s2 = -s2;
            }
            if (s2 > 0.0 && (radius = Math.sqrt(s1 < s2 ? r12 : r22)) > mwp.radius) continue;
            mwp.radius = radius;
            mwp.hasUpdate = true;
            this.anyUpdate = true;
            if (mwp.crosspoint == null) {
                mwp.crosspoint = new OsmNode();
            }
            if (s2 < 0.0) {
                double wayfraction = -s2 / (d * d);
                double xm = x2 - wayfraction * dx;
                double ym = y2 - wayfraction * dy;
                mwp.crosspoint.ilon = (int)(xm / dlon2m + (double)wp.ilon);
                mwp.crosspoint.ilat = (int)(ym / dlat2m + (double)wp.ilat);
                continue;
            }
            if (s1 > s2) {
                mwp.crosspoint.ilon = lon2;
                mwp.crosspoint.ilat = lat2;
                continue;
            }
            mwp.crosspoint.ilon = lon1;
            mwp.crosspoint.ilat = lat1;
        }
    }

    @Override
    public boolean start(int ilonStart, int ilatStart, int ilonTarget, int ilatTarget) {
        long n2;
        long n1;
        if (this.islandPairs.size() > 0 && this.islandPairs.hasPair(n1 = (long)ilonStart << 32 | (long)ilatStart, n2 = (long)ilonTarget << 32 | (long)ilatTarget)) {
            return false;
        }
        this.lonLast = this.lonStart = ilonStart;
        this.latLast = this.latStart = ilatStart;
        this.lonTarget = ilonTarget;
        this.latTarget = ilatTarget;
        this.anyUpdate = false;
        return true;
    }

    @Override
    public void transferNode(int ilon, int ilat) {
        this.checkSegment(this.lonLast, this.latLast, ilon, ilat);
        this.lonLast = ilon;
        this.latLast = ilat;
    }

    @Override
    public void end() {
        this.checkSegment(this.lonLast, this.latLast, this.lonTarget, this.latTarget);
        if (this.anyUpdate) {
            for (MatchedWaypoint mwp : this.waypoints) {
                if (!mwp.hasUpdate) continue;
                mwp.hasUpdate = false;
                mwp.node1 = new OsmNode(this.lonStart, this.latStart);
                mwp.node2 = new OsmNode(this.lonTarget, this.latTarget);
            }
        }
    }
}

