/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class MixCoderDataInputStream
extends DataInputStream {
    private int lastValue;
    private int repCount;
    private int diffshift;
    private int bm = 256;
    private int b;

    public MixCoderDataInputStream(InputStream is) {
        super(is);
    }

    public int readMixed() throws IOException {
        if (this.repCount == 0) {
            boolean negative = this.decodeBit();
            int d = this.decodeVarBits() + this.diffshift;
            this.repCount = this.decodeVarBits() + 1;
            this.lastValue += negative ? -d : d;
            this.diffshift = 1;
        }
        --this.repCount;
        return this.lastValue;
    }

    public final boolean decodeBit() throws IOException {
        if (this.bm == 256) {
            this.bm = 1;
            this.b = this.readByte();
        }
        boolean value = (this.b & this.bm) != 0;
        this.bm <<= 1;
        return value;
    }

    public final int decodeVarBits() throws IOException {
        int range = 0;
        int value = 0;
        while (!this.decodeBit()) {
            value += range + 1;
            range = 2 * range + 1;
        }
        return value + this.decodeBounded(range);
    }

    public final int decodeBounded(int max) throws IOException {
        int value = 0;
        int im = 1;
        while ((value | im) <= max) {
            if (this.bm == 256) {
                this.bm = 1;
                this.b = this.readByte();
            }
            if ((this.b & this.bm) != 0) {
                value |= im;
            }
            this.bm <<= 1;
            im <<= 1;
        }
        return value;
    }
}

