/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmLinkHolder;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.mapaccess.TurnRestriction;
import btools.router.MessageData;
import btools.router.OsmPathElement;
import btools.router.OsmPathElementWithTraffic;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.util.CheapRuler;
import java.io.IOException;

abstract class OsmPath
implements OsmLinkHolder {
    public int cost = 0;
    public short selev;
    public int airdistance = 0;
    protected OsmNode sourceNode;
    protected OsmNode targetNode;
    protected OsmLink link;
    public OsmPathElement originElement;
    public OsmPathElement myElement;
    protected float traffic;
    private OsmLinkHolder nextForLink = null;
    public int treedepth = 0;
    public int originLon;
    public int originLat;
    protected float lastClassifier;
    protected float lastInitialCost;
    protected int priorityclassifier;
    private static final int PATH_START_BIT = 1;
    private static final int CAN_LEAVE_DESTINATION_BIT = 2;
    private static final int IS_ON_DESTINATION_BIT = 4;
    private static final int HAD_DESTINATION_START_BIT = 8;
    protected int bitfield = 1;
    public MessageData message;

    OsmPath() {
    }

    private boolean getBit(int mask) {
        return (this.bitfield & mask) != 0;
    }

    private void setBit(int mask, boolean bit) {
        if (this.getBit(mask) != bit) {
            this.bitfield ^= mask;
        }
    }

    public boolean didEnterDestinationArea() {
        return !this.getBit(8) && this.getBit(4);
    }

    public void unregisterUpTree(RoutingContext rc) {
        try {
            OsmPathElement pe = this.originElement;
            while (pe instanceof OsmPathElementWithTraffic && ((OsmPathElementWithTraffic)pe).unregister(rc)) {
                pe = pe.origin;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void registerUpTree() {
        if (this.originElement instanceof OsmPathElementWithTraffic) {
            OsmPathElementWithTraffic ot = (OsmPathElementWithTraffic)this.originElement;
            ot.register();
            ot.addTraffic(this.traffic);
        }
    }

    public void init(OsmLink link) {
        this.link = link;
        this.targetNode = link.getTarget(null);
        this.selev = this.targetNode.getSElev();
        this.originLon = -1;
        this.originLat = -1;
    }

    public void init(OsmPath origin, OsmLink link, OsmTrack refTrack, boolean detailMode, RoutingContext rc) {
        if (origin.myElement == null) {
            origin.myElement = OsmPathElement.create(origin, rc.countTraffic);
        }
        this.originElement = origin.myElement;
        this.link = link;
        this.sourceNode = origin.targetNode;
        this.targetNode = link.getTarget(this.sourceNode);
        this.cost = origin.cost;
        this.lastClassifier = origin.lastClassifier;
        this.lastInitialCost = origin.lastInitialCost;
        this.bitfield = origin.bitfield;
        this.init(origin);
        this.addAddionalPenalty(refTrack, detailMode, origin, link, rc);
    }

    protected abstract void init(OsmPath var1);

    protected abstract void resetState();

    protected void addAddionalPenalty(OsmTrack refTrack, boolean detailMode, OsmPath origin, OsmLink link, RoutingContext rc) {
        short ele2;
        byte[] description = link.descriptionBitmap;
        if (description == null) {
            throw new IllegalArgumentException("null description for: " + link);
        }
        boolean recordTransferNodes = detailMode || rc.countTraffic;
        rc.nogoCost = 0.0;
        int lon0 = origin.originLon;
        int lat0 = origin.originLat;
        int lon1 = this.sourceNode.getILon();
        int lat1 = this.sourceNode.getILat();
        short ele1 = origin.selev;
        int linkdisttotal = 0;
        this.message = detailMode ? new MessageData() : null;
        boolean isReverse = link.isReverse(this.sourceNode);
        rc.expctxWay.evaluate(rc.inverseDirection ^ isReverse, description);
        float costfactor = rc.expctxWay.getCostfactor();
        boolean isTrafficBackbone = this.cost == 0 && rc.expctxWay.getIsTrafficBackbone() > 0.0f;
        int lastpriorityclassifier = this.priorityclassifier;
        this.priorityclassifier = (int)rc.expctxWay.getPriorityClassifier();
        float newClassifier = rc.expctxWay.getInitialClassifier();
        float newInitialCost = rc.expctxWay.getInitialcost();
        float classifierDiff = newClassifier - this.lastClassifier;
        if ((double)newClassifier != 0.0 && (double)this.lastClassifier != 0.0 && ((double)classifierDiff > 5.0E-4 || (double)classifierDiff < -5.0E-4)) {
            float initialcost;
            float f = initialcost = rc.inverseDirection ? this.lastInitialCost : newInitialCost;
            if ((double)initialcost >= 1000000.0) {
                this.cost = -1;
                return;
            }
            int iicost = (int)initialcost;
            if (this.message != null) {
                this.message.linkinitcost += iicost;
            }
            this.cost += iicost;
        }
        this.lastClassifier = newClassifier;
        this.lastInitialCost = newInitialCost;
        int classifiermask = (int)rc.expctxWay.getClassifierMask();
        boolean newDestination = (classifiermask & 0x40) != 0;
        boolean oldDestination = this.getBit(4);
        if (this.getBit(1)) {
            this.setBit(1, false);
            this.setBit(2, newDestination);
            this.setBit(8, newDestination);
        } else if (oldDestination && !newDestination) {
            if (this.getBit(2)) {
                this.setBit(2, false);
            } else {
                this.cost = -1;
                return;
            }
        }
        this.setBit(4, newDestination);
        OsmTransferNode transferNode = link.geometry == null ? null : rc.geometryDecoder.decodeGeometry(link.geometry, this.sourceNode, this.targetNode, isReverse);
        int nsection = 0;
        while (true) {
            double elevation;
            double sectionCost;
            boolean isStartpoint;
            int lat2;
            int lon2;
            this.originLon = lon1;
            this.originLat = lat1;
            if (transferNode == null) {
                lon2 = this.targetNode.ilon;
                lat2 = this.targetNode.ilat;
                ele2 = this.targetNode.selev;
            } else {
                lon2 = transferNode.ilon;
                lat2 = transferNode.ilat;
                ele2 = transferNode.selev;
            }
            boolean bl = isStartpoint = lon0 == -1 && lat0 == -1;
            if (nsection == 0 && rc.considerTurnRestrictions && !detailMode && !isStartpoint && (rc.inverseDirection ? TurnRestriction.isTurnForbidden(this.sourceNode.firstRestriction, lon2, lat2, lon0, lat0, rc.bikeMode, rc.carMode) : TurnRestriction.isTurnForbidden(this.sourceNode.firstRestriction, lon0, lat0, lon2, lat2, rc.bikeMode, rc.carMode))) {
                this.cost = -1;
                return;
            }
            if (this.message != null && this.message.wayKeyValues != null) {
                this.originElement.message = this.message;
                this.message = new MessageData();
            }
            int dist = rc.calcDistance(lon1, lat1, lon2, lat2);
            boolean stopAtEndpoint = false;
            if (rc.shortestmatch) {
                if (rc.isEndpoint) {
                    stopAtEndpoint = true;
                    ele2 = this.interpolateEle(ele1, ele2, rc.wayfraction);
                } else {
                    this.cost = 0;
                    this.resetState();
                    lon0 = -1;
                    lat0 = -1;
                    isStartpoint = true;
                    if (recordTransferNodes) {
                        if (rc.wayfraction > 0.0) {
                            ele1 = this.interpolateEle(ele1, ele2, 1.0 - rc.wayfraction);
                            this.originElement = OsmPathElement.create(rc.ilonshortest, rc.ilatshortest, ele1, null, rc.countTraffic);
                        } else {
                            this.originElement = null;
                        }
                    }
                }
            }
            if (this.message != null) {
                this.message.linkdist += dist;
            }
            linkdisttotal += dist;
            if (isStartpoint) {
                if (rc.startDirectionValid) {
                    double dir = (double)rc.startDirection.intValue() * (Math.PI / 180);
                    double[] lonlat2m = CheapRuler.getLonLatToMeterScales(lon0 + lat1 >> 1);
                    lon0 = lon1 - (int)(1000.0 * Math.sin(dir) / lonlat2m[0]);
                    lat0 = lat1 - (int)(1000.0 * Math.cos(dir) / lonlat2m[1]);
                } else {
                    lon0 = lon1 - (lon2 - lon1);
                    lat0 = lat1 - (lat2 - lat1);
                }
            }
            double angle = rc.anglemeter.calcAngle(lon0, lat0, lon1, lat1, lon2, lat2);
            double cosangle = rc.anglemeter.getCosAngle();
            double delta_h = 0.0;
            if (ele2 == Short.MIN_VALUE) {
                ele2 = ele1;
            }
            if (ele1 != Short.MIN_VALUE) {
                delta_h = (double)(ele2 - ele1) / 4.0;
                if (rc.inverseDirection) {
                    delta_h = -delta_h;
                }
            }
            if ((sectionCost = this.processWaySection(rc, dist, delta_h, elevation = ele2 == Short.MIN_VALUE ? 100.0 : (double)ele2 / 4.0, angle, cosangle, isStartpoint, nsection, lastpriorityclassifier)) < 0.0 || (double)costfactor > 9998.0 && !detailMode || sectionCost + (double)this.cost >= 2.0E9) {
                this.cost = -1;
                return;
            }
            if (isTrafficBackbone) {
                sectionCost = 0.0;
            }
            this.cost += (int)sectionCost;
            if (rc.countTraffic) {
                int minDist = (int)rc.trafficSourceMinDist;
                int cost2 = this.cost < minDist ? minDist : this.cost;
                this.traffic = (float)((double)this.traffic + (double)((float)dist * rc.expctxWay.getTrafficSourceDensity()) * Math.pow((float)cost2 / 10000.0f, rc.trafficSourceExponent));
            }
            this.computeKinematic(rc, dist, delta_h, detailMode);
            if (this.message != null) {
                this.message.turnangle = (float)angle;
                this.message.time = (float)this.getTotalTime();
                this.message.energy = (float)this.getTotalEnergy();
                this.message.priorityclassifier = this.priorityclassifier;
                this.message.classifiermask = classifiermask;
                this.message.lon = lon2;
                this.message.lat = lat2;
                this.message.ele = ele2;
                this.message.wayKeyValues = rc.expctxWay.getKeyValueDescription(isReverse, description);
            }
            if (stopAtEndpoint) {
                if (recordTransferNodes) {
                    this.originElement = OsmPathElement.create(rc.ilonshortest, rc.ilatshortest, ele2, this.originElement, rc.countTraffic);
                    this.originElement.cost = this.cost;
                    if (this.message != null) {
                        this.originElement.message = this.message;
                    }
                }
                this.cost = rc.nogoCost < 0.0 ? -1 : (int)((double)this.cost + rc.nogoCost);
                return;
            }
            if (transferNode == null) {
                if (refTrack != null && refTrack.containsNode(this.targetNode) && refTrack.containsNode(this.sourceNode)) {
                    int reftrackcost = linkdisttotal;
                    this.cost += reftrackcost;
                }
                break;
            }
            transferNode = transferNode.next;
            if (recordTransferNodes) {
                this.originElement = OsmPathElement.create(lon2, lat2, ele2, this.originElement, rc.countTraffic);
                this.originElement.cost = this.cost;
                this.originElement.addTraffic(this.traffic);
                this.traffic = 0.0f;
            }
            lon0 = lon1;
            lat0 = lat1;
            lon1 = lon2;
            lat1 = lat2;
            ele1 = ele2;
            ++nsection;
        }
        this.selev = ele2;
        if (rc.nogoCost < 0.0) {
            this.cost = -1;
            return;
        }
        this.cost = (int)((double)this.cost + rc.nogoCost);
        double targetCost = this.processTargetNode(rc);
        if (targetCost < 0.0 || targetCost + (double)this.cost >= 2.0E9) {
            this.cost = -1;
            return;
        }
        this.cost += (int)targetCost;
    }

    public short interpolateEle(short e1, short e2, double fraction) {
        if (e1 == Short.MIN_VALUE || e2 == Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)((double)e1 * (1.0 - fraction) + (double)e2 * fraction);
    }

    protected abstract double processWaySection(RoutingContext var1, double var2, double var4, double var6, double var8, double var10, boolean var12, int var13, int var14);

    protected abstract double processTargetNode(RoutingContext var1);

    protected void computeKinematic(RoutingContext rc, double dist, double delta_h, boolean detailMode) {
    }

    public abstract int elevationCorrection(RoutingContext var1);

    public abstract boolean definitlyWorseThan(OsmPath var1, RoutingContext var2);

    public OsmNode getSourceNode() {
        return this.sourceNode;
    }

    public OsmNode getTargetNode() {
        return this.targetNode;
    }

    public OsmLink getLink() {
        return this.link;
    }

    @Override
    public void setNextForLink(OsmLinkHolder holder) {
        this.nextForLink = holder;
    }

    @Override
    public OsmLinkHolder getNextForLink() {
        return this.nextForLink;
    }

    public double getTotalTime() {
        return 0.0;
    }

    public double getTotalEnergy() {
        return 0.0;
    }
}

