/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmNode;
import btools.util.CheapRuler;

public class OsmNodeNamed
extends OsmNode {
    public String name;
    public double radius;
    public double nogoWeight;
    public boolean isNogo = false;

    public OsmNodeNamed() {
    }

    public OsmNodeNamed(OsmNode n) {
        super(n.ilon, n.ilat);
    }

    @Override
    public String toString() {
        if (Double.isNaN(this.nogoWeight)) {
            return this.ilon + "," + this.ilat + "," + this.name;
        }
        return this.ilon + "," + this.ilat + "," + this.name + "," + this.nogoWeight;
    }

    public double distanceWithinRadius(int lon1, int lat1, int lon2, int lat2, double totalSegmentLength) {
        boolean isLastPointWithinCircle;
        double[] lonlat2m = CheapRuler.getLonLatToMeterScales(lat1 + lat2 >> 1);
        boolean isFirstPointWithinCircle = CheapRuler.distance(lon1, lat1, this.ilon, this.ilat) < this.radius;
        boolean bl = isLastPointWithinCircle = CheapRuler.distance(lon2, lat2, this.ilon, this.ilat) < this.radius;
        if (isFirstPointWithinCircle) {
            if (isLastPointWithinCircle) {
                return totalSegmentLength;
            }
            int tmp = lon2;
            lon2 = lon1;
            lon1 = tmp;
            tmp = lat2;
            lat2 = lat1;
            lat1 = tmp;
            isLastPointWithinCircle = isFirstPointWithinCircle;
            isFirstPointWithinCircle = false;
        }
        double initialToProject = ((double)((lon2 - lon1) * (this.ilon - lon1)) * lonlat2m[0] * lonlat2m[0] + (double)((lat2 - lat1) * (this.ilat - lat1)) * lonlat2m[1] * lonlat2m[1]) / totalSegmentLength;
        double initialToCenter = CheapRuler.distance(this.ilon, this.ilat, lon1, lat1);
        double halfDistanceWithin = Math.sqrt(this.radius * this.radius - (initialToCenter * initialToCenter - initialToProject * initialToProject));
        if (isLastPointWithinCircle) {
            return halfDistanceWithin + (totalSegmentLength - initialToProject);
        }
        return 2.0 * halfDistanceWithin;
    }

    public static OsmNodeNamed decodeNogo(String s) {
        OsmNodeNamed n = new OsmNodeNamed();
        int idx1 = s.indexOf(44);
        n.ilon = Integer.parseInt(s.substring(0, idx1));
        int idx2 = s.indexOf(44, idx1 + 1);
        n.ilat = Integer.parseInt(s.substring(idx1 + 1, idx2));
        int idx3 = s.indexOf(44, idx2 + 1);
        if (idx3 == -1) {
            n.name = s.substring(idx2 + 1);
            n.nogoWeight = Double.NaN;
        } else {
            n.name = s.substring(idx2 + 1, idx3);
            n.nogoWeight = Double.parseDouble(s.substring(idx3 + 1));
        }
        n.isNogo = true;
        return n;
    }
}

