/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContextNode;
import btools.expressions.BExpressionContextWay;
import btools.router.KinematicPath;
import btools.router.KinematicPrePath;
import btools.router.OsmPath;
import btools.router.OsmPathModel;
import btools.router.OsmPrePath;
import java.util.Map;

final class KinematicModel
extends OsmPathModel {
    public double turnAngleDecayLength;
    public double f_roll;
    public double f_air;
    public double f_recup;
    public double p_standby;
    public double outside_temp;
    public double recup_efficiency;
    public double totalweight;
    public double vmax;
    public double leftWaySpeed;
    public double rightWaySpeed;
    public double pw;
    public double cost0;
    private int wayIdxMaxspeed;
    private int wayIdxMaxspeedExplicit;
    private int wayIdxMinspeed;
    private int nodeIdxMaxspeed;
    protected BExpressionContextWay ctxWay;
    protected BExpressionContextNode ctxNode;
    protected Map<String, String> params;
    private boolean initDone = false;
    private double lastEffectiveLimit;
    private double lastBreakingSpeed;

    KinematicModel() {
    }

    @Override
    public OsmPrePath createPrePath() {
        return new KinematicPrePath();
    }

    @Override
    public OsmPath createPath() {
        return new KinematicPath();
    }

    @Override
    public void init(BExpressionContextWay expctxWay, BExpressionContextNode expctxNode, Map<String, String> extraParams) {
        if (!this.initDone) {
            this.ctxWay = expctxWay;
            this.ctxNode = expctxNode;
            this.wayIdxMaxspeed = this.ctxWay.getOutputVariableIndex("maxspeed", false);
            this.wayIdxMaxspeedExplicit = this.ctxWay.getOutputVariableIndex("maxspeed_explicit", false);
            this.wayIdxMinspeed = this.ctxWay.getOutputVariableIndex("minspeed", false);
            this.nodeIdxMaxspeed = this.ctxNode.getOutputVariableIndex("maxspeed", false);
            this.initDone = true;
        }
        this.params = extraParams;
        this.turnAngleDecayLength = this.getParam("turnAngleDecayLength", 50.0f);
        this.f_roll = this.getParam("f_roll", 232.0f);
        this.f_air = this.getParam("f_air", 0.4f);
        this.f_recup = this.getParam("f_recup", 400.0f);
        this.p_standby = this.getParam("p_standby", 250.0f);
        this.outside_temp = this.getParam("outside_temp", 20.0f);
        this.recup_efficiency = this.getParam("recup_efficiency", 0.7f);
        this.totalweight = this.getParam("totalweight", 1640.0f);
        this.vmax = (double)this.getParam("vmax", 80.0f) / 3.6;
        this.leftWaySpeed = (double)this.getParam("leftWaySpeed", 12.0f) / 3.6;
        this.rightWaySpeed = (double)this.getParam("rightWaySpeed", 12.0f) / 3.6;
        this.pw = 2.0 * this.f_air * this.vmax * this.vmax * this.vmax - this.p_standby;
        this.cost0 = (this.pw + this.p_standby) / this.vmax + this.f_roll + this.f_air * this.vmax * this.vmax;
    }

    protected float getParam(String name, float defaultValue) {
        String sval;
        String string = sval = this.params == null ? null : this.params.get(name);
        if (sval != null) {
            return Float.parseFloat(sval);
        }
        float v = this.ctxWay.getVariableValue(name, defaultValue);
        if (this.params != null) {
            this.params.put(name, "" + v);
        }
        return v;
    }

    public float getWayMaxspeed() {
        return this.ctxWay.getBuildInVariable(this.wayIdxMaxspeed) / 3.6f;
    }

    public float getWayMaxspeedExplicit() {
        return this.ctxWay.getBuildInVariable(this.wayIdxMaxspeedExplicit) / 3.6f;
    }

    public float getWayMinspeed() {
        return this.ctxWay.getBuildInVariable(this.wayIdxMinspeed) / 3.6f;
    }

    public float getNodeMaxspeed() {
        return this.ctxNode.getBuildInVariable(this.nodeIdxMaxspeed) / 3.6f;
    }

    public double getEffectiveSpeedLimit() {
        double minspeed = this.getWayMinspeed();
        double espeed = minspeed > this.vmax ? minspeed : this.vmax;
        double maxspeed = this.getWayMaxspeed();
        return maxspeed < espeed ? maxspeed : espeed;
    }

    public double getBreakingSpeed(double vl) {
        if (vl == this.lastEffectiveLimit) {
            return this.lastBreakingSpeed;
        }
        double v = vl * 0.8;
        double pw2 = this.pw + this.p_standby;
        double e = this.recup_efficiency;
        double x0 = pw2 / vl + this.f_air * e * vl * vl + (1.0 - e) * this.f_roll;
        for (int i = 0; i < 5; ++i) {
            double v2 = v * v;
            double x = pw2 / v + this.f_air * e * v2 - x0;
            double dx = 2.0 * e * this.f_air * v - pw2 / v2;
            v -= x / dx;
        }
        this.lastEffectiveLimit = vl;
        this.lastBreakingSpeed = v;
        return v;
    }
}

