/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmTransferNode;
import btools.util.ByteDataReader;

public final class GeometryDecoder {
    private ByteDataReader r = new ByteDataReader(null);
    private OsmTransferNode[] cachedNodes = new OsmTransferNode[this.nCachedNodes];
    private int nCachedNodes = 128;
    private OsmTransferNode firstTransferNode;
    private boolean lastReverse;
    private byte[] lastGeometry;

    public GeometryDecoder() {
        for (int i = 0; i < this.nCachedNodes; ++i) {
            this.cachedNodes[i] = new OsmTransferNode();
        }
    }

    public OsmTransferNode decodeGeometry(byte[] geometry, OsmNode sourceNode, OsmNode targetNode, boolean reverseLink) {
        if (this.lastGeometry == geometry && this.lastReverse == reverseLink) {
            return this.firstTransferNode;
        }
        this.firstTransferNode = null;
        OsmTransferNode lastTransferNode = null;
        OsmNode startnode = reverseLink ? targetNode : sourceNode;
        this.r.reset(geometry);
        int olon = startnode.ilon;
        int olat = startnode.ilat;
        short oselev = startnode.selev;
        int idx = 0;
        while (this.r.hasMoreData()) {
            OsmTransferNode trans = idx < this.nCachedNodes ? this.cachedNodes[idx++] : new OsmTransferNode();
            trans.ilon = olon + this.r.readVarLengthSigned();
            trans.ilat = olat + this.r.readVarLengthSigned();
            trans.selev = (short)(oselev + this.r.readVarLengthSigned());
            olon = trans.ilon;
            olat = trans.ilat;
            oselev = trans.selev;
            if (reverseLink) {
                trans.next = this.firstTransferNode;
                this.firstTransferNode = trans;
                continue;
            }
            trans.next = null;
            if (lastTransferNode == null) {
                this.firstTransferNode = trans;
            } else {
                lastTransferNode.next = trans;
            }
            lastTransferNode = trans;
        }
        this.lastReverse = reverseLink;
        this.lastGeometry = geometry;
        return this.firstTransferNode;
    }
}

