/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.util.Random;

public final class SortedHeap<V> {
    private int size;
    private int peaksize;
    private SortedBin first;
    private SortedBin second;
    private SortedBin firstNonEmpty;

    public SortedHeap() {
        this.clear();
    }

    public V popLowestKeyValue() {
        SortedBin bin = this.firstNonEmpty;
        if (bin == null) {
            return null;
        }
        --this.size;
        int minId = bin.lv;
        SortedBin minBin = bin;
        while ((bin = bin.nextNonEmpty) != null) {
            if (bin.lv >= minId) continue;
            minId = bin.lv;
            minBin = bin;
        }
        return (V)minBin.dropLowest();
    }

    public void add(int key, V value) {
        ++this.size;
        if (this.first.lp == 0 && this.second.lp == 0) {
            this.sortUp();
        }
        if (this.first.lp > 0) {
            this.first.add(key, value);
            if (this.firstNonEmpty != this.first) {
                this.first.nextNonEmpty = this.firstNonEmpty;
                this.firstNonEmpty = this.first;
            }
        } else {
            this.second.add(key, value);
            if (this.first.nextNonEmpty != this.second) {
                this.second.nextNonEmpty = this.first.nextNonEmpty;
                this.first.nextNonEmpty = this.second;
            }
        }
    }

    private void sortUp() {
        if (this.size > this.peaksize) {
            this.peaksize = this.size;
        }
        int cnt = 8;
        SortedBin tbin = this.second;
        SortedBin lastNonEmpty = this.second;
        do {
            tbin = tbin.next();
            int nentries = tbin.binsize - tbin.lp;
            if (nentries <= 0) continue;
            cnt += nentries;
            lastNonEmpty = tbin;
        } while (cnt > tbin.binsize);
        int[] al_t = tbin.al;
        Object[] vla_t = tbin.vla;
        int tp = tbin.binsize - cnt;
        SortedBin otherNonEmpty = lastNonEmpty.nextNonEmpty;
        lastNonEmpty.nextNonEmpty = null;
        while (this.firstNonEmpty != null) {
            SortedBin ne;
            SortedBin minBin = ne = this.firstNonEmpty;
            int minId = minBin.lv;
            while ((ne = ne.nextNonEmpty) != null) {
                if (ne.lv >= minId) continue;
                minBin = ne;
                minId = minBin.lv;
            }
            al_t[tp] = minId;
            vla_t[tp++] = minBin.dropLowest();
        }
        tbin.lp = tp = tbin.binsize - cnt;
        tbin.lv = tbin.al[tp];
        tbin.nextNonEmpty = otherNonEmpty;
        this.firstNonEmpty = tbin;
    }

    public void clear() {
        this.size = 0;
        this.first = new SortedBin(4, this);
        this.second = new SortedBin(4, this);
        this.firstNonEmpty = null;
    }

    public int getSize() {
        return this.size;
    }

    public int getPeakSize() {
        return this.peaksize;
    }

    public int getExtract(Object[] targetArray) {
        int tsize = targetArray.length;
        int div = this.size / tsize + 1;
        int tp = 0;
        int lpi = 0;
        SortedBin bin = this.firstNonEmpty;
        while (bin != null) {
            lpi += bin.lp;
            Object[] vlai = bin.vla;
            int n = bin.binsize;
            while (lpi < n) {
                targetArray[tp++] = vlai[lpi];
                lpi += div;
            }
            lpi -= n;
            bin = bin.nextNonEmpty;
        }
        return tp;
    }

    public static void main(String[] args) {
        String s;
        SortedHeap<String> sh = new SortedHeap<String>();
        Random rnd = new Random();
        for (int i = 0; i < 1000; ++i) {
            int val = rnd.nextInt(1000000);
            sh.add(val, "" + val);
            val = rnd.nextInt(1000000);
            sh.add(val, "" + val);
            sh.popLowestKeyValue();
        }
        int cnt = 0;
        int lastval = 0;
        while ((s = (String)sh.popLowestKeyValue()) != null) {
            ++cnt;
            int val = Integer.parseInt(s);
            System.out.println("popLowestKeyValue: " + val);
            lastval = val;
        }
    }

    private static final class SortedBin {
        SortedHeap parent;
        SortedBin next;
        SortedBin nextNonEmpty;
        int binsize;
        int[] al;
        Object[] vla;
        int lv;
        int lp;

        SortedBin(int binsize, SortedHeap parent) {
            this.binsize = binsize;
            this.parent = parent;
            this.al = new int[binsize];
            this.vla = new Object[binsize];
            this.lp = binsize;
        }

        SortedBin next() {
            if (this.next == null) {
                this.next = new SortedBin(this.binsize << 1, this.parent);
            }
            return this.next;
        }

        Object dropLowest() {
            int lpOld = this.lp++;
            if (this.lp == this.binsize) {
                this.unlink();
            } else {
                this.lv = this.al[this.lp];
            }
            Object res = this.vla[lpOld];
            this.vla[lpOld] = null;
            return res;
        }

        void unlink() {
            SortedBin neBin = this.parent.firstNonEmpty;
            if (neBin == this) {
                this.parent.firstNonEmpty = this.nextNonEmpty;
                return;
            }
            while (true) {
                SortedBin next;
                if ((next = neBin.nextNonEmpty) == this) {
                    neBin.nextNonEmpty = this.nextNonEmpty;
                    return;
                }
                neBin = next;
            }
        }

        void add(int key, Object value) {
            int p = this.lp;
            while (true) {
                if (p == this.binsize || key < this.al[p]) {
                    this.al[p - 1] = key;
                    this.vla[p - 1] = value;
                    this.lv = this.al[--this.lp];
                    return;
                }
                this.al[p - 1] = this.al[p];
                this.vla[p - 1] = this.vla[p];
                ++p;
            }
        }
    }
}

