/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.Crc32;
import btools.util.IByteArrayUnifier;

public final class ByteArrayUnifier
implements IByteArrayUnifier {
    private byte[][] byteArrayCache;
    private int[] crcCrosscheck;
    private int size;

    public ByteArrayUnifier(int size, boolean validateImmutability) {
        this.size = size;
        this.byteArrayCache = new byte[size][];
        if (validateImmutability) {
            this.crcCrosscheck = new int[size];
        }
    }

    public byte[] unify(byte[] ab) {
        return this.unify(ab, 0, ab.length);
    }

    @Override
    public byte[] unify(byte[] ab, int offset, int len) {
        int crc = Crc32.crc(ab, offset, len);
        int idx = (crc & 0xFFFFFFF) % this.size;
        byte[] abc = this.byteArrayCache[idx];
        if (abc != null && abc.length == len) {
            int i;
            for (i = 0; i < len && ab[offset + i] == abc[i]; ++i) {
            }
            if (i == len) {
                return abc;
            }
        }
        if (this.crcCrosscheck != null) {
            byte[] abold;
            int crcold;
            if (this.byteArrayCache[idx] != null && (crcold = Crc32.crc(abold = this.byteArrayCache[idx], 0, abold.length)) != this.crcCrosscheck[idx]) {
                throw new IllegalArgumentException("ByteArrayUnifier: immutablity validation failed!");
            }
            this.crcCrosscheck[idx] = crc;
        }
        byte[] nab = new byte[len];
        System.arraycopy(ab, offset, nab, 0, len);
        this.byteArrayCache[idx] = nab;
        return nab;
    }
}

