/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.codec.MicroCache;
import btools.codec.MicroCache2;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.OsmPos;
import btools.mapaccess.TurnRestriction;
import btools.util.ByteArrayUnifier;
import btools.util.CheapRuler;
import btools.util.IByteArrayUnifier;

public class OsmNode
extends OsmLink
implements OsmPos {
    public int ilat;
    public int ilon;
    public short selev;
    public byte[] nodeDescription;
    public TurnRestriction firstRestriction;
    public int visitID;
    public OsmLink firstlink;

    public void addTurnRestriction(TurnRestriction tr) {
        tr.next = this.firstRestriction;
        this.firstRestriction = tr;
    }

    public OsmNode() {
    }

    public OsmNode(int ilon, int ilat) {
        this.ilon = ilon;
        this.ilat = ilat;
    }

    public OsmNode(long id) {
        this.ilon = (int)(id >> 32);
        this.ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public final int getILat() {
        return this.ilat;
    }

    @Override
    public final int getILon() {
        return this.ilon;
    }

    @Override
    public final short getSElev() {
        return this.selev;
    }

    @Override
    public final double getElev() {
        return (double)this.selev / 4.0;
    }

    public final void addLink(OsmLink link, boolean isReverse, OsmNode tn) {
        if (link == this.firstlink) {
            throw new IllegalArgumentException("UUUUPS");
        }
        if (isReverse) {
            link.n1 = tn;
            link.n2 = this;
            link.next = tn.firstlink;
            link.previous = this.firstlink;
            tn.firstlink = link;
            this.firstlink = link;
        } else {
            link.n1 = this;
            link.n2 = tn;
            link.next = this.firstlink;
            link.previous = tn.firstlink;
            tn.firstlink = link;
            this.firstlink = link;
        }
    }

    @Override
    public final int calcDistance(OsmPos p) {
        return (int)(CheapRuler.distance(this.ilon, this.ilat, p.getILon(), p.getILat()) + 1.0);
    }

    public String toString() {
        return "n_" + (this.ilon - 180000000) + "_" + (this.ilat - 90000000);
    }

    public final void parseNodeBody(MicroCache mc, OsmNodesMap hollowNodes, IByteArrayUnifier expCtxWay) {
        if (!(mc instanceof MicroCache2)) {
            throw new IllegalArgumentException("unknown cache version: " + mc.getClass());
        }
        this.parseNodeBody2((MicroCache2)mc, hollowNodes, expCtxWay);
    }

    public final void parseNodeBody2(MicroCache2 mc, OsmNodesMap hollowNodes, IByteArrayUnifier expCtxWay) {
        ByteArrayUnifier abUnifier = hollowNodes.getByteArrayUnifier();
        while (mc.readBoolean()) {
            TurnRestriction tr = new TurnRestriction();
            tr.exceptions = mc.readShort();
            tr.isPositive = mc.readBoolean();
            tr.fromLon = mc.readInt();
            tr.fromLat = mc.readInt();
            tr.toLon = mc.readInt();
            tr.toLat = mc.readInt();
            this.addTurnRestriction(tr);
        }
        this.selev = mc.readShort();
        int nodeDescSize = mc.readVarLengthUnsigned();
        byte[] byArray = this.nodeDescription = nodeDescSize == 0 ? null : mc.readUnified(nodeDescSize, abUnifier);
        while (mc.hasMoreData()) {
            int endPointer = mc.getEndPointer();
            int linklon = this.ilon + mc.readVarLengthSigned();
            int linklat = this.ilat + mc.readVarLengthSigned();
            int sizecode = mc.readVarLengthUnsigned();
            boolean isReverse = (sizecode & 1) != 0;
            byte[] description = null;
            int descSize = sizecode >> 1;
            if (descSize > 0) {
                description = mc.readUnified(descSize, expCtxWay);
            }
            byte[] geometry = mc.readDataUntil(endPointer);
            this.addLink(linklon, linklat, description, geometry, hollowNodes, isReverse);
        }
        hollowNodes.remove(this);
    }

    public void addLink(int linklon, int linklat, byte[] description, byte[] geometry, OsmNodesMap hollowNodes, boolean isReverse) {
        if (linklon == this.ilon && linklat == this.ilat) {
            return;
        }
        OsmNode tn = null;
        OsmLink link = null;
        for (OsmLink l = this.firstlink; l != null; l = l.getNext(this)) {
            OsmNode t = l.getTarget(this);
            if (t.ilon != linklon || t.ilat != linklat) continue;
            tn = t;
            if (!isReverse && (l.descriptionBitmap != null || l.isReverse(this))) continue;
            link = l;
            break;
        }
        if (tn == null && (tn = hollowNodes.get(linklon, linklat)) == null) {
            tn = new OsmNode(linklon, linklat);
            tn.setHollow();
            hollowNodes.put(tn);
            link = tn;
            this.addLink(link, isReverse, tn);
        }
        if (link == null) {
            link = new OsmLink();
            this.addLink(link, isReverse, tn);
        }
        if (!isReverse) {
            link.descriptionBitmap = description;
            link.geometry = geometry;
        }
    }

    public final boolean isHollow() {
        return this.selev == -12345;
    }

    public final void setHollow() {
        this.selev = (short)-12345;
    }

    @Override
    public final long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public void vanish() {
        if (!this.isHollow()) {
            OsmLink l = this.firstlink;
            while (l != null) {
                OsmNode target = l.getTarget(this);
                OsmLink nextLink = l.getNext(this);
                if (!target.isHollow()) {
                    this.unlinkLink(l);
                    if (!l.isLinkUnused()) {
                        target.unlinkLink(l);
                    }
                }
                l = nextLink;
            }
        }
    }

    public final void unlinkLink(OsmLink link) {
        OsmLink n = link.clear(this);
        if (link == this.firstlink) {
            this.firstlink = n;
            return;
        }
        OsmLink l = this.firstlink;
        while (l != null) {
            OsmLink nl;
            if (l.n1 != this && l.n1 != null) {
                nl = l.previous;
                if (nl == link) {
                    l.previous = n;
                    return;
                }
                l = nl;
                continue;
            }
            if (l.n2 != this && l.n2 != null) {
                nl = l.next;
                if (nl == link) {
                    l.next = n;
                    return;
                }
                l = nl;
                continue;
            }
            throw new IllegalArgumentException("unlinkLink: unknown source");
        }
    }

    public final boolean equals(Object o) {
        return ((OsmNode)o).ilon == this.ilon && ((OsmNode)o).ilat == this.ilat;
    }

    public final int hashCode() {
        return this.ilon + this.ilat;
    }
}

