/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpressionContext;
import java.util.StringTokenizer;

final class BExpression {
    private static final int OR_EXP = 10;
    private static final int AND_EXP = 11;
    private static final int NOT_EXP = 12;
    private static final int ADD_EXP = 20;
    private static final int MULTIPLY_EXP = 21;
    private static final int MAX_EXP = 22;
    private static final int EQUAL_EXP = 23;
    private static final int GREATER_EXP = 24;
    private static final int MIN_EXP = 25;
    private static final int SUB_EXP = 26;
    private static final int LESSER_EXP = 27;
    private static final int XOR_EXP = 28;
    private static final int SWITCH_EXP = 30;
    private static final int ASSIGN_EXP = 31;
    private static final int LOOKUP_EXP = 32;
    private static final int NUMBER_EXP = 33;
    private static final int VARIABLE_EXP = 34;
    private static final int FOREIGN_VARIABLE_EXP = 35;
    private int typ;
    private BExpression op1;
    private BExpression op2;
    private BExpression op3;
    private float numberValue;
    private int variableIdx;
    private int lookupNameIdx;
    private int[] lookupValueIdxArray;

    BExpression() {
    }

    public static BExpression parse(BExpressionContext ctx, int level) throws Exception {
        return BExpression.parse(ctx, level, null);
    }

    private static BExpression parse(BExpressionContext ctx, int level, String optionalToken) throws Exception {
        boolean brackets = false;
        String operator = ctx.parseToken();
        if (optionalToken != null && optionalToken.equals(operator)) {
            operator = ctx.parseToken();
        }
        if ("(".equals(operator)) {
            brackets = true;
            operator = ctx.parseToken();
        }
        if (operator == null) {
            if (level == 0) {
                return null;
            }
            throw new IllegalArgumentException("unexpected end of file");
        }
        if (level == 0 && !"assign".equals(operator)) {
            throw new IllegalArgumentException("operator " + operator + " is invalid on toplevel (only 'assign' allowed)");
        }
        BExpression exp = new BExpression();
        int nops = 3;
        boolean ifThenElse = false;
        if ("switch".equals(operator)) {
            exp.typ = 30;
        } else if ("if".equals(operator)) {
            exp.typ = 30;
            ifThenElse = true;
        } else {
            nops = 2;
            if ("or".equals(operator)) {
                exp.typ = 10;
            } else if ("and".equals(operator)) {
                exp.typ = 11;
            } else if ("multiply".equals(operator)) {
                exp.typ = 21;
            } else if ("add".equals(operator)) {
                exp.typ = 20;
            } else if ("max".equals(operator)) {
                exp.typ = 22;
            } else if ("min".equals(operator)) {
                exp.typ = 25;
            } else if ("equal".equals(operator)) {
                exp.typ = 23;
            } else if ("greater".equals(operator)) {
                exp.typ = 24;
            } else if ("sub".equals(operator)) {
                exp.typ = 26;
            } else if ("lesser".equals(operator)) {
                exp.typ = 27;
            } else if ("xor".equals(operator)) {
                exp.typ = 28;
            } else {
                nops = 1;
                if ("assign".equals(operator)) {
                    if (level > 0) {
                        throw new IllegalArgumentException("assign operator within expression");
                    }
                    exp.typ = 31;
                    String variable = ctx.parseToken();
                    if (variable == null) {
                        throw new IllegalArgumentException("unexpected end of file");
                    }
                    if (variable.indexOf(61) >= 0) {
                        throw new IllegalArgumentException("variable name cannot contain '=': " + variable);
                    }
                    if (variable.indexOf(58) >= 0) {
                        throw new IllegalArgumentException("cannot assign context-prefixed variable: " + variable);
                    }
                    exp.variableIdx = ctx.getVariableIdx(variable, true);
                    if (exp.variableIdx < ctx.getMinWriteIdx()) {
                        throw new IllegalArgumentException("cannot assign to readonly variable " + variable);
                    }
                } else if ("not".equals(operator)) {
                    exp.typ = 12;
                } else {
                    nops = 0;
                    int idx = operator.indexOf(61);
                    if (idx >= 0) {
                        exp.typ = 32;
                        String name = operator.substring(0, idx);
                        String values = operator.substring(idx + 1);
                        exp.lookupNameIdx = ctx.getLookupNameIdx(name);
                        if (exp.lookupNameIdx < 0) {
                            throw new IllegalArgumentException("unknown lookup name: " + name);
                        }
                        ctx.markLookupIdxUsed(exp.lookupNameIdx);
                        StringTokenizer tk = new StringTokenizer(values, "|");
                        int nt = tk.countTokens();
                        int nt2 = nt == 0 ? 1 : nt;
                        exp.lookupValueIdxArray = new int[nt2];
                        for (int ti = 0; ti < nt2; ++ti) {
                            String value = ti < nt ? tk.nextToken() : "";
                            exp.lookupValueIdxArray[ti] = ctx.getLookupValueIdx(exp.lookupNameIdx, value);
                            if (exp.lookupValueIdxArray[ti] >= 0) continue;
                            throw new IllegalArgumentException("unknown lookup value: " + value);
                        }
                    } else {
                        idx = operator.indexOf(58);
                        if (idx >= 0) {
                            String context = operator.substring(0, idx);
                            String varname = operator.substring(idx + 1);
                            exp.typ = 35;
                            exp.variableIdx = ctx.getForeignVariableIdx(context, varname);
                        } else {
                            idx = ctx.getVariableIdx(operator, false);
                            if (idx >= 0) {
                                exp.typ = 34;
                                exp.variableIdx = idx;
                            } else if ("true".equals(operator)) {
                                exp.numberValue = 1.0f;
                                exp.typ = 33;
                            } else if ("false".equals(operator)) {
                                exp.numberValue = 0.0f;
                                exp.typ = 33;
                            } else {
                                try {
                                    exp.numberValue = Float.parseFloat(operator);
                                    exp.typ = 33;
                                }
                                catch (NumberFormatException nfe) {
                                    throw new IllegalArgumentException("unknown expression: " + operator);
                                }
                            }
                        }
                    }
                }
            }
        }
        if (nops > 0) {
            exp.op1 = BExpression.parse(ctx, level + 1, exp.typ == 31 ? "=" : null);
        }
        if (nops > 1) {
            if (ifThenElse) {
                BExpression.checkExpectedToken(ctx, "then");
            }
            exp.op2 = BExpression.parse(ctx, level + 1, null);
        }
        if (nops > 2) {
            if (ifThenElse) {
                BExpression.checkExpectedToken(ctx, "else");
            }
            exp.op3 = BExpression.parse(ctx, level + 1, null);
        }
        if (brackets) {
            BExpression.checkExpectedToken(ctx, ")");
        }
        return exp;
    }

    private static void checkExpectedToken(BExpressionContext ctx, String expected) throws Exception {
        String token = ctx.parseToken();
        if (!expected.equals(token)) {
            throw new IllegalArgumentException("unexpected token: " + token + ", expected: " + expected);
        }
    }

    public float evaluate(BExpressionContext ctx) {
        switch (this.typ) {
            case 10: {
                return this.op1.evaluate(ctx) != 0.0f ? 1.0f : (this.op2.evaluate(ctx) != 0.0f ? 1.0f : 0.0f);
            }
            case 28: {
                return this.op1.evaluate(ctx) != 0.0f ^ this.op2.evaluate(ctx) != 0.0f ? 1.0f : 0.0f;
            }
            case 11: {
                return this.op1.evaluate(ctx) != 0.0f ? (this.op2.evaluate(ctx) != 0.0f ? 1.0f : 0.0f) : 0.0f;
            }
            case 20: {
                return this.op1.evaluate(ctx) + this.op2.evaluate(ctx);
            }
            case 26: {
                return this.op1.evaluate(ctx) - this.op2.evaluate(ctx);
            }
            case 21: {
                return this.op1.evaluate(ctx) * this.op2.evaluate(ctx);
            }
            case 22: {
                return this.max(this.op1.evaluate(ctx), this.op2.evaluate(ctx));
            }
            case 25: {
                return this.min(this.op1.evaluate(ctx), this.op2.evaluate(ctx));
            }
            case 23: {
                return this.op1.evaluate(ctx) == this.op2.evaluate(ctx) ? 1.0f : 0.0f;
            }
            case 24: {
                return this.op1.evaluate(ctx) > this.op2.evaluate(ctx) ? 1.0f : 0.0f;
            }
            case 27: {
                return this.op1.evaluate(ctx) < this.op2.evaluate(ctx) ? 1.0f : 0.0f;
            }
            case 30: {
                return this.op1.evaluate(ctx) != 0.0f ? this.op2.evaluate(ctx) : this.op3.evaluate(ctx);
            }
            case 31: {
                return ctx.assign(this.variableIdx, this.op1.evaluate(ctx));
            }
            case 32: {
                return ctx.getLookupMatch(this.lookupNameIdx, this.lookupValueIdxArray);
            }
            case 33: {
                return this.numberValue;
            }
            case 34: {
                return ctx.getVariableValue(this.variableIdx);
            }
            case 35: {
                return ctx.getForeignVariableValue(this.variableIdx);
            }
            case 12: {
                return this.op1.evaluate(ctx) == 0.0f ? 1.0f : 0.0f;
            }
        }
        throw new IllegalArgumentException("unknown op-code: " + this.typ);
    }

    private float max(float v1, float v2) {
        return v1 > v2 ? v1 : v2;
    }

    private float min(float v1, float v2) {
        return v1 < v2 ? v1 : v2;
    }
}

