/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public class BitCoderContext {
    private byte[] ab;
    private int idxMax;
    private int idx = -1;
    private int bm = 256;
    private int bits;
    private int b;
    private static final int[] vl_values = new int[4096];
    private static final int[] vl_length = new int[4096];
    private static final int[] reverse_byte = new int[256];

    public BitCoderContext(byte[] ab) {
        this.ab = ab;
        this.idxMax = ab.length - 1;
    }

    public final void reset(byte[] ab) {
        this.ab = ab;
        this.idxMax = ab.length - 1;
        this.reset();
    }

    public final void reset() {
        this.idx = -1;
        this.bm = 256;
        this.bits = 0;
        this.b = 0;
    }

    public final void encodeVarBits(int value) {
        int range = 0;
        while (value > range) {
            this.encodeBit(false);
            value -= range + 1;
            range = 2 * range + 1;
        }
        this.encodeBit(true);
        this.encodeBounded(range, value);
    }

    public final int decodeVarBits2() {
        int range = 0;
        while (!this.decodeBit()) {
            range = 2 * range + 1;
        }
        return range + this.decodeBounded(range);
    }

    public final int decodeVarBits() {
        this.fillBuffer();
        int b12 = this.b & 0xFFF;
        int len = vl_length[b12];
        if (len <= 12) {
            this.b >>>= len;
            this.bits -= len;
            return vl_values[b12];
        }
        if (len <= 23) {
            int len2 = len >> 1;
            this.b >>>= len2 + 1;
            int mask = -1 >>> 32 - len2;
            mask += this.b & mask;
            this.b >>>= len2;
            this.bits -= len;
            return mask;
        }
        return this.decodeVarBits2();
    }

    public final void encodeBit(boolean value) {
        if (this.bm == 256) {
            this.bm = 1;
            this.ab[++this.idx] = 0;
        }
        if (value) {
            int n = this.idx;
            this.ab[n] = (byte)(this.ab[n] | this.bm);
        }
        this.bm <<= 1;
    }

    public final boolean decodeBit() {
        if (this.bits == 0) {
            this.bits = 8;
            this.b = this.ab[++this.idx] & 0xFF;
        }
        boolean value = (this.b & 1) != 0;
        this.b >>>= 1;
        --this.bits;
        return value;
    }

    public final void encodeBounded(int max, int value) {
        for (int im = 1; im <= max; im <<= 1) {
            if (this.bm == 256) {
                this.bm = 1;
                this.ab[++this.idx] = 0;
            }
            if ((value & im) != 0) {
                int n = this.idx;
                this.ab[n] = (byte)(this.ab[n] | this.bm);
                max -= im;
            }
            this.bm <<= 1;
        }
    }

    public final int decodeBounded(int max) {
        int value = 0;
        int im = 1;
        while ((value | im) <= max) {
            if (this.bits == 0) {
                this.bits = 8;
                this.b = this.ab[++this.idx] & 0xFF;
            }
            if ((this.b & 1) != 0) {
                value |= im;
            }
            this.b >>>= 1;
            --this.bits;
            im <<= 1;
        }
        return value;
    }

    public final int decodeBits(int count) {
        this.fillBuffer();
        int mask = -1 >>> 32 - count;
        int value = this.b & mask;
        this.b >>>= count;
        this.bits -= count;
        return value;
    }

    public final int decodeBitsReverse(int count) {
        this.fillBuffer();
        int value = 0;
        while (count > 8) {
            value = value << 8 | reverse_byte[this.b & 0xFF];
            this.b >>= 8;
            count -= 8;
            this.bits -= 8;
            this.fillBuffer();
        }
        value = value << count | reverse_byte[this.b & 0xFF] >> 8 - count;
        this.bits -= count;
        this.b >>= count;
        return value;
    }

    private void fillBuffer() {
        while (this.bits < 24) {
            if (this.idx < this.idxMax) {
                this.b |= (this.ab[++this.idx] & 0xFF) << this.bits;
            }
            this.bits += 8;
        }
    }

    public final int getEncodedLength() {
        return this.idx + 1;
    }

    public final long getWritingBitPosition() {
        long bitpos = this.idx << 3;
        for (int m = this.bm; m > 1; m >>= 1) {
            ++bitpos;
        }
        return bitpos;
    }

    public final int getReadingBitPosition() {
        return (this.idx << 3) + 8 - this.bits;
    }

    public final void setReadingBitPosition(int pos) {
        this.idx = pos >>> 3;
        this.bits = (this.idx << 3) + 8 - pos;
        this.b = this.ab[this.idx] & 0xFF;
        this.b >>>= 8 - this.bits;
    }

    public final void copyBitsTo(byte[] dst, int bitcount) {
        int dstIdx = 0;
        while (bitcount > 8) {
            if (this.bits < 8) {
                this.b |= (this.ab[++this.idx] & 0xFF) << this.bits;
            } else {
                this.bits -= 8;
            }
            dst[dstIdx++] = (byte)this.b;
            this.b >>>= 8;
            bitcount -= 8;
        }
        if (this.bits < bitcount) {
            this.b |= (this.ab[++this.idx] & 0xFF) << this.bits;
            this.bits += 8;
        }
        int mask = 255 >>> 8 - bitcount;
        dst[dstIdx] = (byte)(this.b & mask);
        this.bits -= bitcount;
        this.b >>>= bitcount;
    }

    static {
        BitCoderContext bc = new BitCoderContext(new byte[4]);
        for (int i = 0; i < 4096; ++i) {
            bc.reset();
            bc.bits = 14;
            bc.b = 4096 + i;
            int b0 = bc.getReadingBitPosition();
            BitCoderContext.vl_values[i] = bc.decodeVarBits2();
            BitCoderContext.vl_length[i] = bc.getReadingBitPosition() - b0;
        }
        for (int b = 0; b < 256; ++b) {
            int r = 0;
            for (int i = 0; i < 8; ++i) {
                if ((b & 1 << i) == 0) continue;
                r |= 1 << 7 - i;
            }
            BitCoderContext.reverse_byte[b] = r;
        }
    }
}

