/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.router.OsmPath;
import btools.router.RoutingContext;
import btools.util.FastMath;

final class StdPath
extends OsmPath {
    private int ehbd;
    private int ehbu;
    private float totalTime;
    private float totalEnergy;
    private float elevation_buffer;
    private static final double GRAVITY = 9.81;

    StdPath() {
    }

    @Override
    public void init(OsmPath orig) {
        StdPath origin = (StdPath)orig;
        this.ehbd = origin.ehbd;
        this.ehbu = origin.ehbu;
        this.totalTime = origin.totalTime;
        this.totalEnergy = origin.totalEnergy;
        this.elevation_buffer = origin.elevation_buffer;
    }

    @Override
    protected void resetState() {
        this.ehbd = 0;
        this.ehbu = 0;
        this.totalTime = 0.0f;
        this.totalEnergy = 0.0f;
        this.elevation_buffer = 0.0f;
    }

    @Override
    protected double processWaySection(RoutingContext rc, double distance, double delta_h, double elevation, double angle, double cosangle, boolean isStartpoint, int nsection, int lastpriorityclassifier) {
        float turncostbase = rc.expctxWay.getTurncost();
        float cfup = rc.expctxWay.getUphillCostfactor();
        float cfdown = rc.expctxWay.getDownhillCostfactor();
        float cf = rc.expctxWay.getCostfactor();
        cfup = cfup == 0.0f ? cf : cfup;
        cfdown = cfdown == 0.0f ? cf : cfdown;
        int dist = (int)distance;
        int turncost = (int)((1.0 - cosangle) * (double)turncostbase + 0.2);
        if (this.message != null) {
            this.message.linkturncost += turncost;
            this.message.turnangle = (float)angle;
        }
        double sectionCost = turncost;
        int delta_h_micros = (int)(1000000.0 * delta_h);
        this.ehbd += -delta_h_micros - dist * rc.downhillcutoff;
        this.ehbu += delta_h_micros - dist * rc.uphillcutoff;
        float downweight = 0.0f;
        if (this.ehbd > rc.elevationpenaltybuffer) {
            downweight = 1.0f;
            int reduce = dist * rc.elevationbufferreduce;
            int excess = this.ehbd - rc.elevationpenaltybuffer;
            if (reduce > excess) {
                downweight = (float)excess / (float)reduce;
                reduce = excess;
            }
            if (reduce < (excess = this.ehbd - rc.elevationmaxbuffer)) {
                reduce = excess;
            }
            this.ehbd -= reduce;
            if (rc.downhillcostdiv > 0) {
                int elevationCost = reduce / rc.downhillcostdiv;
                sectionCost += (double)elevationCost;
                if (this.message != null) {
                    this.message.linkelevationcost += elevationCost;
                }
            }
        } else if (this.ehbd < 0) {
            this.ehbd = 0;
        }
        float upweight = 0.0f;
        if (this.ehbu > rc.elevationpenaltybuffer) {
            upweight = 1.0f;
            int reduce = dist * rc.elevationbufferreduce;
            int excess = this.ehbu - rc.elevationpenaltybuffer;
            if (reduce > excess) {
                upweight = (float)excess / (float)reduce;
                reduce = excess;
            }
            if (reduce < (excess = this.ehbu - rc.elevationmaxbuffer)) {
                reduce = excess;
            }
            this.ehbu -= reduce;
            if (rc.uphillcostdiv > 0) {
                int elevationCost = reduce / rc.uphillcostdiv;
                sectionCost += (double)elevationCost;
                if (this.message != null) {
                    this.message.linkelevationcost += elevationCost;
                }
            }
        } else if (this.ehbu < 0) {
            this.ehbu = 0;
        }
        float costfactor = cfup * upweight + cf * (1.0f - upweight - downweight) + cfdown * downweight;
        if (this.message != null) {
            this.message.costfactor = costfactor;
        }
        return sectionCost += (double)((float)dist * costfactor + 0.5f);
    }

    @Override
    protected double processTargetNode(RoutingContext rc) {
        if (this.targetNode.nodeDescription != null) {
            boolean nodeAccessGranted = (double)rc.expctxWay.getNodeAccessGranted() != 0.0;
            rc.expctxNode.evaluate(nodeAccessGranted, this.targetNode.nodeDescription);
            float initialcost = rc.expctxNode.getInitialcost();
            if ((double)initialcost >= 1000000.0) {
                return -1.0;
            }
            if (this.message != null) {
                this.message.linknodecost += (int)initialcost;
                this.message.nodeKeyValues = rc.expctxNode.getKeyValueDescription(nodeAccessGranted, this.targetNode.nodeDescription);
            }
            return initialcost;
        }
        return 0.0;
    }

    @Override
    public int elevationCorrection(RoutingContext rc) {
        return (rc.downhillcostdiv > 0 ? this.ehbd / rc.downhillcostdiv : 0) + (rc.uphillcostdiv > 0 ? this.ehbu / rc.uphillcostdiv : 0);
    }

    @Override
    public boolean definitlyWorseThan(OsmPath path, RoutingContext rc) {
        int delta;
        StdPath p = (StdPath)path;
        int c = p.cost;
        if (rc.downhillcostdiv > 0 && (delta = p.ehbd - this.ehbd) > 0) {
            c += delta / rc.downhillcostdiv;
        }
        if (rc.uphillcostdiv > 0 && (delta = p.ehbu - this.ehbu) > 0) {
            c += delta / rc.uphillcostdiv;
        }
        return this.cost > c;
    }

    private double calcIncline(double dist) {
        double shift;
        double min_delta = 3.0;
        if ((double)this.elevation_buffer > min_delta) {
            shift = -min_delta;
        } else if ((double)this.elevation_buffer < min_delta) {
            shift = -min_delta;
        } else {
            return 0.0;
        }
        double decayFactor = FastMath.exp(-dist / 100.0);
        float new_elevation_buffer = (float)(((double)this.elevation_buffer + shift) * decayFactor - shift);
        double incline = (double)(this.elevation_buffer - new_elevation_buffer) / dist;
        this.elevation_buffer = new_elevation_buffer;
        return incline;
    }

    @Override
    protected void computeKinematic(RoutingContext rc, double dist, double delta_h, boolean detailMode) {
        double speed;
        if (!detailMode) {
            return;
        }
        this.elevation_buffer = (float)((double)this.elevation_buffer + delta_h);
        double incline = this.calcIncline(dist);
        double wayMaxspeed = rc.expctxWay.getMaxspeed() / 3.6f;
        if (wayMaxspeed == 0.0) {
            wayMaxspeed = rc.maxSpeed;
        }
        wayMaxspeed = Math.min(wayMaxspeed, rc.maxSpeed);
        double f_roll = rc.totalMass * 9.81 * (rc.defaultC_r + incline);
        if (rc.footMode || (double)rc.expctxWay.getCostfactor() > 4.9) {
            speed = 6.0 * FastMath.exp(-3.5 * Math.abs(incline + 0.05)) / 3.6;
        } else if (rc.bikeMode) {
            speed = StdPath.solveCubic(rc.S_C_x, f_roll, rc.bikerPower);
            speed = Math.min(speed, wayMaxspeed);
        } else {
            return;
        }
        float dt = (float)(dist / speed);
        this.totalTime += dt;
        double energy = dist * (rc.S_C_x * speed * speed + f_roll);
        if (energy > 0.0) {
            this.totalEnergy = (float)((double)this.totalEnergy + energy);
        }
    }

    private static double solveCubic(double a, double c, double d) {
        double v = 8.0;
        boolean findingStartvalue = true;
        for (int i = 0; i < 10; ++i) {
            double y = (a * v * v + c) * v - d;
            if (y < 0.1) {
                if (!findingStartvalue) break;
                v *= 2.0;
                continue;
            }
            findingStartvalue = false;
            double y_prime = 3.0 * a * v * v + c;
            v -= y / y_prime;
        }
        return v;
    }

    @Override
    public double getTotalTime() {
        return this.totalTime;
    }

    @Override
    public double getTotalEnergy() {
        return this.totalEnergy;
    }
}

